/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.util;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.StatusBar;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteProjectUtil {
    private static transient Logger log = Log.getLogger(RemoteProjectUtil.class);
    private static Thread statusBarUpdateThread;
    private static final int DELAY_MSEC = 2000;

    public static void configure(ProjectView projectView) {
        StatusBar statusBar = new StatusBar();
        projectView.add((Component)statusBar, "South");
        RemoteProjectUtil.createUpdateThread((RemoteClientProject)projectView.getProject(), statusBar);
    }

    public static void dispose(ProjectView projectView) {
        statusBarUpdateThread = null;
    }

    private static void createUpdateThread(final RemoteClientProject remoteClientProject, final StatusBar statusBar) {
        statusBarUpdateThread = new Thread("Status Bar Updater"){

            public void run() {
                try {
                    while (statusBarUpdateThread == this) {
                        try {
                            1.sleep(2000L);
                            RemoteProjectUtil.updateStatus(remoteClientProject, statusBar);
                        }
                        catch (InterruptedException interruptedException) {
                            log.log(Level.INFO, "Exception caught", interruptedException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    log.log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        statusBarUpdateThread.setDaemon(true);
        statusBarUpdateThread.start();
    }

    private static void updateStatus(RemoteClientProject remoteClientProject, StatusBar statusBar) {
        ArrayList arrayList = new ArrayList(remoteClientProject.getCurrentUsers());
        arrayList.remove(remoteClientProject.getLocalUser());
        String string = StringUtilities.commaSeparatedList(arrayList);
        String string2 = string.length() == 0 ? "No other users" : "Other users: " + string;
        statusBar.setText(string2);
    }

    public static RemoteServer getRemoteServer(KnowledgeBase knowledgeBase) {
        if (!knowledgeBase.getProject().isMultiUserClient()) {
            return null;
        }
        FrameStoreManager frameStoreManager = ((DefaultKnowledgeBase)knowledgeBase).getFrameStoreManager();
        RemoteClientFrameStore remoteClientFrameStore = frameStoreManager.getFrameStoreFromClass(RemoteClientFrameStore.class);
        RemoteServer remoteServer = remoteClientFrameStore.getRemoteServer();
        return remoteServer;
    }

    public static boolean isOperationAllowed(RemoteServer remoteServer, RemoteSession remoteSession, String string, Operation operation) {
        try {
            return remoteServer.isOperationAllowed(remoteSession, operation, string);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.WARNING, "Could not figure out from server whether session: " + remoteSession + " is allowed to: " + operation + " on remote project: " + string + ". Allowing the operation");
            return true;
        }
    }

    public static boolean isServerOperationAllowed(RemoteServer remoteServer, RemoteSession remoteSession, Operation operation) {
        try {
            return remoteServer.isServerOperationAllowed(remoteSession, operation);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.WARNING, "Could not figure out from server whether session: " + remoteSession + " is allowed to: " + operation);
            return true;
        }
    }
}

