/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreeSelectionHelper;
import edu.stanford.smi.protege.util.UnaryFunction;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentUtilities {
    private static final int BORDER_SIZE = 50;
    private static final int STANDARD_ROW_HEIGHT = 60;
    private static final int STANDARD_COLUMN_WIDTH = 100;
    private static Collection _openWindows = new ArrayList();

    public static TableColumn addColumn(JTable jTable, TableCellRenderer tableCellRenderer) {
        return ComponentUtilities.addColumn(jTable, null, tableCellRenderer);
    }

    public static TableColumn addColumn(JTable jTable, String string, TableCellRenderer tableCellRenderer) {
        return ComponentUtilities.addColumn(jTable, tableCellRenderer, null);
    }

    public static TableColumn addColumn(JTable jTable, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        return ComponentUtilities.addColumn(jTable, tableCellRenderer, null, tableCellEditor);
    }

    public static TableColumn addColumn(JTable jTable, TableCellRenderer tableCellRenderer, String string, TableCellEditor tableCellEditor) {
        int n = jTable.getColumnCount();
        TableColumn tableColumn = new TableColumn(n);
        tableColumn.setCellRenderer(tableCellRenderer);
        tableColumn.setCellEditor(tableCellEditor);
        tableColumn.setHeaderValue(string);
        jTable.addColumn(tableColumn);
        return tableColumn;
    }

    public static int addListValue(JList jList, Object object) {
        return ComponentUtilities.getModel(jList).addValue(object);
    }

    public static void addListValue(JList jList, Object object, int n) {
        ComponentUtilities.getModel(jList).addValue(object, n);
    }

    public static int addListValue(JList jList, Object object, Comparator comparator) {
        int n = ComponentUtilities.getPositionIndex(jList, object, comparator);
        ComponentUtilities.addListValue(jList, object, n);
        return n;
    }

    public static void addListValues(JList jList, Collection collection) {
        if (!collection.isEmpty()) {
            ComponentUtilities.getModel(jList).addValues(collection);
        }
    }

    public static int addSelectedListValue(JList jList, Object object) {
        int n = ComponentUtilities.getModel(jList).addValue(object);
        jList.setSelectedIndex(n);
        return n;
    }

    public static void addSelectedListValues(JList jList, Collection collection) {
        if (!collection.isEmpty()) {
            int n = ComponentUtilities.getModel(jList).addValues(collection);
            jList.setSelectionInterval(n, n + collection.size() - 1);
        }
    }

    public static void addUniqueListValues(JList jList, Collection collection) {
        HashSet hashSet = new HashSet(collection);
        hashSet.removeAll(ComponentUtilities.getModel(jList).getValues());
        ComponentUtilities.addListValues(jList, hashSet);
    }

    public static void apply(Component component, UnaryFunction unaryFunction) {
        unaryFunction.apply(component);
        ComponentUtilities.applyToDescendents(component, unaryFunction);
    }

    public static void applyToDescendents(Component component, UnaryFunction unaryFunction) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                ComponentUtilities.apply(component2, unaryFunction);
            }
        }
    }

    public static void center(Component component) {
        Dimension dimension = component.getToolkit().getScreenSize();
        dimension.width -= 50;
        dimension.height -= 50;
        Dimension dimension2 = component.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        n = Math.max(n, 0);
        int n2 = (dimension.height - dimension2.height) / 2;
        n2 = Math.max(n2, 0);
        component.setLocation(new Point(n, n2));
    }

    public static void clearListValues(JList jList) {
        ComponentUtilities.getModel(jList).clear();
    }

    private static void clearSelectionIfNecessary(JList jList, int n) {
        if (jList.getModel().getSize() == n) {
            jList.clearSelection();
        }
    }

    public static void closeAllWindows() {
        for (Window window : new ArrayList(_openWindows)) {
            ComponentUtilities.closeWindow(window);
        }
    }

    public static void closeWindow(Window window) {
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    public static void deregisterWindow(Window window) {
        _openWindows.remove(window);
    }

    private static void disassemble(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ComponentUtilities.disassemble(container.getComponent(i));
            }
            container.removeAll();
        }
    }

    public static void dispose(Component component) {
        if (component != null) {
            component.setVisible(false);
            UnaryFunction unaryFunction = new UnaryFunction(){

                public Object apply(Object object) {
                    if (object instanceof Disposable) {
                        ((Disposable)object).dispose();
                    }
                    return Boolean.TRUE;
                }
            };
            ComponentUtilities.apply(component, unaryFunction);
            ComponentUtilities.disassemble(component);
            component.setBackground(Color.pink);
            component.setForeground(Color.green);
        }
    }

    public static void ensureSelectionIsVisible(JList jList) {
    }

    public static void extendSelection(JTree jTree, Object object) {
        LazyTreeNode lazyTreeNode = (LazyTreeNode)jTree.getLastSelectedPathComponent();
        if (lazyTreeNode == null) {
            return;
        }
        int n = lazyTreeNode.getUserObjectIndex(object);
        if (n == -1) {
            Log.getLogger().warning("object not found: " + object);
        } else {
            TreeNode treeNode = lazyTreeNode.getChildAt(n);
            ComponentUtilities.setSelectedNode(jTree, treeNode);
        }
    }

    private static int fullExpand(JTree jTree, TreePath treePath, int n) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2 && n > 0; ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
            n = ComponentUtilities.fullExpand(jTree, treePath2, n);
        }
        jTree.expandPath(treePath);
        return --n;
    }

    public static void fullSelectionCollapse(JTree jTree) {
        int n = jTree.getLeadSelectionRow();
        int n2 = ComponentUtilities.getStopRow(jTree, n);
        for (int i = n2 - 1; i >= n; --i) {
            jTree.collapseRow(i);
        }
    }

    public static void fullSelectionExpand(JTree jTree, int n) {
        TreePath treePath = jTree.getLeadSelectionPath();
        if (treePath != null) {
            ComponentUtilities.fullExpand(jTree, treePath, n);
        }
    }

    public static LazyTreeNode getChildNode(LazyTreeNode lazyTreeNode, Object object) {
        LazyTreeNode lazyTreeNode2 = null;
        int n = lazyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            lazyTreeNode2 = (LazyTreeNode)lazyTreeNode.getChildAt(i);
            if (!ComponentUtilities.equals(lazyTreeNode2.getUserObject(), object)) continue;
            return lazyTreeNode2;
        }
        return null;
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public static Component getDescendentOfClass(Class clazz, Component component) {
        Collection collection = ComponentUtilities.getDescendentsOfClass(clazz, component);
        return (Component)CollectionUtilities.getFirstItem(collection);
    }

    public static Collection getDescendentsOfClass(final Class clazz, Component component) {
        final ArrayList arrayList = new ArrayList();
        UnaryFunction unaryFunction = new UnaryFunction(){

            public Object apply(Object object) {
                if (clazz.isInstance(object)) {
                    arrayList.add(object);
                }
                return null;
            }
        };
        ComponentUtilities.apply(component, unaryFunction);
        return arrayList;
    }

    public static Dialog getDialog(Component component) {
        return (Dialog)SwingUtilities.windowForComponent(component);
    }

    public static Object getFirstSelectionParent(JTree jTree) {
        LazyTreeNode lazyTreeNode;
        LazyTreeNode lazyTreeNode2 = (LazyTreeNode)jTree.getLastSelectedPathComponent();
        Object object = lazyTreeNode2 == null ? null : ((lazyTreeNode = lazyTreeNode2.getLazyTreeNodeParent()) instanceof LazyTreeRoot ? null : lazyTreeNode.getUserObject());
        return object;
    }

    public static Frame getFrame(Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.windowForComponent(component);
        return frame;
    }

    public static Collection getListValues(JList jList) {
        ListModel listModel = jList.getModel();
        if (listModel instanceof SimpleListModel) {
            return ((SimpleListModel)listModel).getValues();
        }
        return ComponentUtilities.getGenericListValues(jList);
    }

    private static Collection getGenericListValues(JList jList) {
        ArrayList arrayList = new ArrayList();
        ListModel listModel = jList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        return arrayList;
    }

    private static SimpleListModel getModel(JList jList) {
        SimpleListModel simpleListModel = jList.getModel();
        if (!(simpleListModel instanceof SimpleListModel)) {
            simpleListModel = new SimpleListModel();
            jList.setModel(simpleListModel);
        }
        return simpleListModel;
    }

    private static int getPositionIndex(JList jList, Object object, Comparator comparator) {
        int n = Collections.binarySearch(ComponentUtilities.getModel(jList).getValues(), object, comparator);
        if (n < 0) {
            n = -(n + 1);
        }
        return n;
    }

    public static Object getSelectedValue(JList jList) {
        return CollectionUtilities.getFirstItem(ComponentUtilities.getSelection(jList));
    }

    public static Collection getSelection(JList jList) {
        return Arrays.asList(jList.getSelectedValues());
    }

    public static void setSelectedValue(JList jList, Object object) {
        jList.setSelectedValue(object, true);
    }

    public static void setSelectedValues(JList jList, Collection collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Object e : collection) {
            nArray[n++] = ComponentUtilities.indexOf(jList, e);
        }
        jList.setSelectedIndices(nArray);
    }

    private static int indexOf(JList jList, Object object) {
        int n = -1;
        ListModel listModel = jList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            if (!e.equals(object)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static Collection getSelection(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        int[] nArray = jTable.getSelectedRows();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(tableModel.getValueAt(nArray[i], 0));
        }
        return arrayList;
    }

    public static Collection getSelection(JTree jTree) {
        return ComponentUtilities.getSelection(jTree, Object.class);
    }

    public static Collection getSelection(JTree jTree, Class clazz) {
        Assert.assertNotNull("tree", jTree);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        TreePath[] treePathArray = jTree.getSelectionModel().getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                if (treePath.getPathCount() <= 1) continue;
                Object object = treePathArray[i].getLastPathComponent();
                if (object instanceof LazyTreeNode) {
                    object = ((LazyTreeNode)object).getUserObject();
                }
                if (clazz != null && !clazz.isInstance(object)) continue;
                linkedHashSet.add(object);
            }
        }
        return linkedHashSet;
    }

    public static int getStandardColumnWidth() {
        return 100;
    }

    public static int getStandardRowHeight() {
        return 60;
    }

    private static int getStopRow(JTree jTree, int n) {
        int n2;
        int n3 = jTree.getPathForRow(n).getPathCount();
        int n4 = n2 = jTree.getRowCount();
        for (int i = n + 1; i < n2; ++i) {
            int n5 = jTree.getPathForRow(i).getPathCount();
            if (n5 > n3) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    public static TreePath getTreePath(JTree jTree, Collection collection) {
        LinkedList<LazyTreeNode> linkedList = new LinkedList<LazyTreeNode>();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)jTree.getModel().getRoot();
        linkedList.add(lazyTreeNode);
        for (Object e : collection) {
            if ((lazyTreeNode = ComponentUtilities.getChildNode(lazyTreeNode, e)) == null) {
                return null;
            }
            linkedList.add(lazyTreeNode);
        }
        return new TreePath(linkedList.toArray());
    }

    public static Collection getObjectPath(TreePath treePath) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = treePath.getPath();
        for (int i = 1; i < objectArray.length; ++i) {
            TreeNode treeNode = (TreeNode)objectArray[i];
            if (!(treeNode instanceof LazyTreeNode)) continue;
            Object object = ((LazyTreeNode)treeNode).getUserObject();
            arrayList.add(object);
        }
        return arrayList;
    }

    public static void hide(final Component component, final int n) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    3.sleep(n);
                    Component component2 = SwingUtilities.getRoot(component);
                    component2.setVisible(false);
                }
                catch (Exception exception) {
                    Log.getLogger().severe(Log.toString(exception));
                }
            }
        };
        thread.start();
    }

    public static boolean isDragAndDropEnabled(JComponent jComponent) {
        Object object = jComponent.getClientProperty(ComponentUtilities.class);
        return object == null ? true : (Boolean)object;
    }

    public static boolean listValuesContain(JList jList, Object object) {
        return ComponentUtilities.getModel(jList).contains(object);
    }

    public static ImageIcon loadImageIcon(Class clazz, String string) {
        ImageIcon imageIcon = null;
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    public static void pack(Component component) {
        Frame frame = ComponentUtilities.getFrame(component);
        frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension();
        dimension2.width = Math.min(frame.getWidth(), dimension.width * 8 / 10);
        dimension2.height = Math.min(frame.getHeight(), dimension.height * 8 / 10);
        frame.setSize(dimension2);
    }

    public static Dimension getDefaultMainFrameSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width = dimension.width * 8 / 10;
        dimension.height = dimension.height * 8 / 10;
        return dimension;
    }

    public static void paintImmediately(Component component) {
        Graphics graphics = component.getGraphics();
        component.paint(graphics);
        graphics.dispose();
    }

    public static void registerWindow(Window window) {
        _openWindows.add(window);
    }

    public static void removeListValue(JList jList, Object object) {
        ComponentUtilities.clearSelectionIfNecessary(jList, 1);
        int n = jList.getSelectedIndex();
        int n2 = ComponentUtilities.getModel(jList).removeValue(object);
        if (n == n2) {
            ComponentUtilities.setSelectedIndex(jList, n2);
        }
    }

    public static void removeListValues(JList jList, Collection collection) {
        ComponentUtilities.clearSelectionIfNecessary(jList, collection.size());
        int n = jList.getSelectedIndex();
        int n2 = ComponentUtilities.getModel(jList).removeValues(collection);
        if (n == n2) {
            ComponentUtilities.setSelectedIndex(jList, n2);
        }
    }

    public static void removeSelection(JTree jTree) {
        LazyTreeNode lazyTreeNode = (LazyTreeNode)jTree.getLastSelectedPathComponent();
        if (lazyTreeNode != null) {
            int n;
            LazyTreeNode lazyTreeNode2 = lazyTreeNode.getLazyTreeNodeParent();
            int n2 = lazyTreeNode2.getUserObjectIndex(lazyTreeNode.getUserObject());
            TreeNode treeNode = n2 == (n = lazyTreeNode2.getChildCount()) - 1 ? (n == 1 ? lazyTreeNode2 : lazyTreeNode2.getChildAt(n2 - 1)) : lazyTreeNode2.getChildAt(n2 + 1);
            ComponentUtilities.setSelectedNode(jTree, treeNode);
        }
    }

    public static void replaceListValue(JList jList, Object object, Object object2) {
        SimpleListModel simpleListModel = ComponentUtilities.getModel(jList);
        if (object2 == null) {
            simpleListModel.removeValue(object);
        } else {
            int n = simpleListModel.indexOf(object);
            if (n != -1) {
                simpleListModel.setValue(n, object2);
            }
        }
    }

    public static void reposition(JList jList, Object object, Comparator comparator) {
        int n = jList.getSelectedIndex();
        SimpleListModel simpleListModel = ComponentUtilities.getModel(jList);
        int n2 = simpleListModel.indexOf(object);
        simpleListModel.removeValue(object);
        int n3 = ComponentUtilities.getPositionIndex(jList, object, comparator);
        ComponentUtilities.getModel(jList).addValue(object, n3);
        if (n != -1) {
            int n4 = n;
            if (n2 == n) {
                n4 = n3;
            } else if (n2 < n && n3 > n) {
                --n4;
            } else if (n2 > n && n3 < n) {
                ++n4;
            }
            jList.setSelectedIndex(n4);
            jList.ensureIndexIsVisible(n4);
        }
    }

    public static void setDragAndDropEnabled(JComponent jComponent, boolean bl) {
        jComponent.putClientProperty(ComponentUtilities.class, bl);
    }

    public static void setEnabled(Component component, final boolean bl) {
        ComponentUtilities.apply(component, new UnaryFunction(){

            public Object apply(Object object) {
                ((Component)object).setEnabled(bl);
                return null;
            }
        });
    }

    public static void setExpanded(JTree jTree, Collection collection, boolean bl) {
        TreePath treePath = ComponentUtilities.getTreePath(jTree, collection);
        if (treePath != null) {
            if (bl) {
                jTree.scrollPathToVisible(treePath);
                jTree.expandPath(treePath);
                jTree.updateUI();
            } else {
                jTree.collapsePath(treePath);
            }
        }
    }

    public static void setFrameTitle(Component component, String string) {
        ComponentUtilities.getFrame(component).setTitle(string);
    }

    public static void setListValues(JList jList, Collection collection) {
        ComponentUtilities.getModel(jList).setValues(collection);
    }

    private static void setSelectedIndex(JList jList, int n) {
        int n2 = jList.getModel().getSize();
        n = Math.min(n, n2 - 1);
        jList.setSelectedIndex(n);
    }

    public static void setSelectedNode(final JTree jTree, TreeNode treeNode) {
        TreePath treePath = new TreePath(((LazyTreeModel)jTree.getModel()).getPathToRoot(treeNode));
        if (treePath != null) {
            jTree.scrollPathToVisible(treePath);
            jTree.setSelectionPath(treePath);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTree.updateUI();
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTree.updateUI();
            }
        });
    }

    public static void setSelectedObjectPath(final JTree jTree, Collection collection) {
        final TreePath treePath = ComponentUtilities.getTreePath(jTree, collection);
        if (treePath != null) {
            final WaitCursor waitCursor = new WaitCursor(jTree);
            jTree.scrollPathToVisible(treePath);
            jTree.updateUI();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTree.setSelectionPath(treePath);
                    jTree.updateUI();
                    waitCursor.hide();
                }
            });
        }
    }

    public static void setSelectedObjectPaths(JTree jTree, Collection collection) {
        TreePath[] treePathArray2;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (TreePath[] treePathArray2 : collection) {
            arrayList.add(ComponentUtilities.getTreePath(jTree, (Collection)treePathArray2));
        }
        treePathArray2 = arrayList.toArray(new TreePath[arrayList.size()]);
        jTree.setSelectionPaths(treePathArray2);
        if (treePathArray2.length > 0) {
            jTree.scrollPathToVisible(treePathArray2[0]);
            jTree.updateUI();
        }
    }

    public static void requestFocus(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jComponent.requestFocus();
            }
        });
    }

    public static void setDisplayParent(JTree jTree, Object object, Traverser traverser) {
        Object object2 = ((LazyTreeNode)jTree.getSelectionPath().getLastPathComponent()).getUserObject();
        ComponentUtilities.setDisplayParent(jTree, object, object2, traverser);
    }

    public static void setDisplayParent(JTree jTree, Object object, Object object2, Traverser traverser) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(0, object2);
        while (object != null) {
            linkedList.add(0, object);
            object = traverser.get(object);
        }
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext() && treeNode != null) {
            Object e = iterator.next();
            treeNode = ComponentUtilities.getMatchingChildNode(treeNode, e);
        }
        if (treeNode != null) {
            ComponentUtilities.setSelectedNode(jTree, treeNode);
        }
    }

    private static TreeNode getMatchingChildNode(TreeNode treeNode, Object object) {
        LazyTreeNode lazyTreeNode = null;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            LazyTreeNode lazyTreeNode2 = (LazyTreeNode)treeNode.getChildAt(i);
            if (!ComponentUtilities.equals(lazyTreeNode2.getUserObject(), object)) continue;
            lazyTreeNode = lazyTreeNode2;
            break;
        }
        return lazyTreeNode;
    }

    public static JLabel setTitleLabelFont(JLabel jLabel) {
        return ComponentUtilities.modifyLabelFont(jLabel, 1, 0);
    }

    public static JLabel setSmallLabelFont(JLabel jLabel) {
        return ComponentUtilities.modifyLabelFont(jLabel, 1, 0);
    }

    public static JLabel modifyLabelFont(JLabel jLabel, int n, int n2) {
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(n, font.getSize() + n2));
        jLabel.setForeground(new Color(140, 140, 140));
        return jLabel;
    }

    public static void enableTextAntialiasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemUtilities.useAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public static void enableAllAntialiasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemUtilities.useAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public static Border getAlignBorder() {
        return BorderFactory.createEmptyBorder(5, 0, 0, 0);
    }

    public static void scrollToVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jTable.scrollRectToVisible(rectangle);
    }

    public static JMenu getMenu(JMenuBar jMenuBar, String string) {
        return ComponentUtilities.getMenu(jMenuBar, string, false);
    }

    public static JMenu getMenu(JMenuBar jMenuBar, String string, boolean bl) {
        return ComponentUtilities.getMenu(jMenuBar, string, bl, jMenuBar.getMenuCount());
    }

    public static JMenu getMenu(JMenuBar jMenuBar, String string, boolean bl, int n) {
        int n2 = jMenuBar.getMenuCount();
        for (int i = 0; i < n2; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (!jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        if (bl) {
            JMenu jMenu = new JMenu(string);
            jMenuBar.add((Component)jMenu, n);
            jMenuBar.revalidate();
            jMenuBar.repaint();
            return jMenu;
        }
        return null;
    }

    public static void removeMenuItem(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !string.equals(jMenuItem.getText())) continue;
            jMenu.remove(jMenuItem);
        }
    }

    public static void setSelectedNode(final KnowledgeBase knowledgeBase, JTree jTree, FrameWithBrowserText frameWithBrowserText) {
        TreeSelectionHelper<FrameWithBrowserText> treeSelectionHelper = new TreeSelectionHelper<FrameWithBrowserText>(jTree){
            private Slot superclsesSlot;
            {
                super(jTree);
                this.superclsesSlot = knowledgeBase.getSystemFrames().getDirectSuperclassesSlot();
            }

            @Override
            protected Collection<FrameWithBrowserText> getParents(FrameWithBrowserText frameWithBrowserText) {
                edu.stanford.smi.protege.model.Frame frame = frameWithBrowserText.getFrame();
                return FrameWithBrowserText.getFramesWithBrowserText(frame.getOwnSlotValues(this.superclsesSlot));
            }

            @Override
            protected boolean isVisible(FrameWithBrowserText frameWithBrowserText) {
                edu.stanford.smi.protege.model.Frame frame = frameWithBrowserText.getFrame();
                return frame.isVisible();
            }
        };
        treeSelectionHelper.setSelectedNode(frameWithBrowserText);
    }
}

