/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache;

import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheFactory;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class Cache_Test
extends TestCase {
    public static final String SESSION1 = "Timothy Redmond";
    public static final String SESSION2 = "Jennifer Vendetti";
    public static final String SESSION3 = "Tania Tudorache";
    public static Set<String> SESSIONS = new HashSet<String>();
    public static final String VAR1 = "x";
    public static final String VAR2 = "y";
    public static final String VAR3 = "z";
    public static final String VAL1 = "Claudia";
    public static final String VAL2 = "natalia";
    public static final String VAL3 = "troglodyte";

    public void testCommon() {
        for (TransactionIsolationLevel transactionIsolationLevel : TransactionIsolationLevel.values()) {
            Cache<String, String, String> cache = CacheFactory.createEmptyCache(transactionIsolationLevel);
            cache.modifyCache(SESSION1, VAR1, VAL1);
            CacheResult cacheResult = cache.readCache(SESSION1, VAR1);
            Cache_Test.assertTrue((boolean)cacheResult.isValid());
            Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL1));
            cache.modifyCache(SESSION2, VAR2);
            cacheResult = cache.readCache(SESSION3, VAR1);
            Cache_Test.assertTrue((boolean)cacheResult.isValid());
            Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL1));
            cacheResult = cache.readCache(SESSION1, VAR2);
            Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
            cacheResult = cache.readCache(SESSION2, VAR2);
            Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
            cache.modifyCache(SESSION3, VAR1, VAL3);
            cacheResult = cache.readCache(SESSION2, VAR1);
            Cache_Test.assertTrue((boolean)cacheResult.isValid());
            Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL3));
        }
    }

    public void testNesting() {
        for (TransactionIsolationLevel transactionIsolationLevel : TransactionIsolationLevel.values()) {
            Cache<String, String, String> cache = CacheFactory.createEmptyCache(transactionIsolationLevel);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
            cache.beginTransaction(SESSION1);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
            cache.modifyCache(SESSION1, VAR1, VAL1);
            Cache_Test.assertTrue((boolean)cache.readCache(SESSION1, VAR1).isValid());
            Cache_Test.assertTrue((boolean)((String)cache.readCache(SESSION1, VAR1).getResult()).equals(VAL1));
            cache.beginTransaction(SESSION2);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
            cache.modifyCache(SESSION1, VAR2, VAL2);
            Cache_Test.assertTrue((boolean)cache.readCache(SESSION1, VAR2).isValid());
            Cache_Test.assertTrue((boolean)((String)cache.readCache(SESSION1, VAR2).getResult()).equals(VAL2));
            cache.beginTransaction(SESSION1);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 2 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
            cache.beginTransaction(SESSION3);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 2 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 1 ? 1 : 0) != 0);
            cache.commitTransaction(SESSION2);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 2 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 1 ? 1 : 0) != 0);
            cache.rollbackTransaction(SESSION1);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 1 ? 1 : 0) != 0);
            cache.commitTransaction(SESSION3);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 1 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
            cache.rollbackTransaction(SESSION1);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION1) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION2) == 0 ? 1 : 0) != 0);
            Cache_Test.assertTrue((cache.getTransactionNesting(SESSION3) == 0 ? 1 : 0) != 0);
        }
    }

    public void testReadUncommitted() {
        Cache<String, String, String> cache = CacheFactory.createEmptyCache(TransactionIsolationLevel.READ_UNCOMMITTED);
        cache.updateCache(SESSION1, VAR1, VAL1);
        cache.updateCache(SESSION2, VAR2, VAL2);
        cache.modifyCache(SESSION3, VAR3, VAL3);
        cache.beginTransaction(SESSION2);
        CacheResult cacheResult = cache.readCache(SESSION2, VAR3);
        Cache_Test.assertTrue((boolean)cacheResult.isValid());
        Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL3));
        cache.modifyCache(SESSION2, VAR1, VAL2);
        cacheResult = cache.readCache(SESSION3, VAR1);
        Cache_Test.assertTrue((boolean)cacheResult.isValid());
        Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL2));
        cache.rollbackTransaction(SESSION2);
        cacheResult = cache.readCache(SESSION1, VAR1);
        Cache_Test.assertTrue((!cacheResult.isValid() || ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
        cacheResult = cache.readCache(SESSION1, VAR3);
        Cache_Test.assertTrue((boolean)cacheResult.isValid());
        Cache_Test.assertTrue((boolean)((String)cacheResult.getResult()).equals(VAL3));
        cache.beginTransaction(SESSION1);
        cache.modifyCache(SESSION1, VAR3, VAL2);
        cacheResult = cache.readCache(SESSION2, VAR3);
        Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL2) ? 1 : 0) != 0);
        cache.commitTransaction(SESSION1);
        cacheResult = cache.readCache(SESSION3, VAR3);
        Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL2) ? 1 : 0) != 0);
    }

    public void testReadCommitted01() {
        this.itestReadCommitted01(true);
        this.itestReadCommitted01(false);
    }

    public void itestReadCommitted01(boolean bl) {
        for (TransactionIsolationLevel transactionIsolationLevel : TransactionIsolationLevel.values()) {
            if (transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) < 0) continue;
            Cache<String, String, String> cache = CacheFactory.createEmptyCache(transactionIsolationLevel);
            cache.updateCache(SESSION1, VAR1, VAL1);
            cache.updateCache(SESSION2, VAR2, VAL2);
            cache.updateCache(SESSION3, VAR3, VAL3);
            cache.beginTransaction(SESSION3);
            cache.modifyCache(SESSION3, VAR1, VAL3);
            CacheResult cacheResult = cache.readCache(SESSION1, VAR1);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
            cacheResult = cache.readCache(SESSION3, VAR1);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL3) ? 1 : 0) != 0);
            cacheResult = cache.readCache(SESSION1, VAR2);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL2) ? 1 : 0) != 0);
            cache.modifyCache(SESSION2, VAR2, VAL1);
            cacheResult = cache.readCache(SESSION1, VAR2);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
            cacheResult = cache.readCache(SESSION2, VAR2);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
            cache.modifyCache(SESSION3, VAR2);
            cacheResult = cache.readCache(SESSION2, VAR2);
            Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
            cacheResult = cache.readCache(SESSION3, VAR2);
            Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
            if (bl) {
                cache.commitTransaction(SESSION3);
                for (String string : SESSIONS) {
                    cacheResult = cache.readCache(string, VAR1);
                    Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL3) ? 1 : 0) != 0);
                    cacheResult = cache.readCache(string, VAR2);
                    Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
                    cacheResult = cache.readCache(string, VAR3);
                    Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL3) ? 1 : 0) != 0);
                }
            } else {
                cache.rollbackTransaction(SESSION3);
                for (String string : SESSIONS) {
                    cacheResult = cache.readCache(string, VAR1);
                    Cache_Test.assertTrue((!cacheResult.isValid() || ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
                    cacheResult = cache.readCache(string, VAR2);
                    Cache_Test.assertTrue((!cacheResult.isValid() || ((String)cacheResult.getResult()).equals(VAL1) ? 1 : 0) != 0);
                    cacheResult = cache.readCache(string, VAR3);
                    Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL3) ? 1 : 0) != 0);
                }
            }
            cache.modifyCache(SESSION1, VAR1, VAL1);
            cache.modifyCache(SESSION1, VAR2, VAL2);
            cache.beginTransaction(SESSION2);
            cache.modifyCache(SESSION2, VAR1, VAL2);
            cache.modifyCache(SESSION2, VAR2);
            cache.modifyCache(SESSION1, VAR1);
            cache.modifyCache(SESSION1, VAR2, VAL3);
            if (bl) {
                cache.commitTransaction(SESSION2);
                for (String string : SESSIONS) {
                    cacheResult = cache.readCache(string, VAR1);
                    Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL2) ? 1 : 0) != 0);
                    cacheResult = cache.readCache(string, VAR2);
                    Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
                }
                continue;
            }
            cache.rollbackTransaction(SESSION2);
            for (String string : SESSIONS) {
                cacheResult = cache.readCache(string, VAR1);
                Cache_Test.assertTrue((!cacheResult.isValid() ? 1 : 0) != 0);
                cacheResult = cache.readCache(string, VAR2);
                Cache_Test.assertTrue((cacheResult.isValid() && ((String)cacheResult.getResult()).equals(VAL3) ? 1 : 0) != 0);
            }
        }
    }

    static {
        SESSIONS.add(SESSION1);
        SESSIONS.add(SESSION2);
        SESSIONS.add(SESSION3);
    }
}

