/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public class ComboBoxWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -1649506562178607049L;
    protected static final String NONE = "";
    private JComboBox _comboBox;
    private boolean _displayNullEntry = true;
    private ActionListener _listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ComboBoxWidget.this.comboBoxValueChanged();
        }
    };

    protected void comboBoxValueChanged() {
        this.valueChanged();
    }

    public JComboBox createComboBox() {
        return ComponentFactory.createComboBox();
    }

    public ComboBoxModel createModel() {
        DefaultComboBoxModel<Object> defaultComboBoxModel;
        Slot slot = this.getSlot();
        if (slot == null) {
            Log.getLogger().warning("No slot");
            defaultComboBoxModel = new DefaultComboBoxModel();
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ValueType valueType = this.getCls().getTemplateSlotValueType(slot);
            if (valueType == ValueType.BOOLEAN) {
                arrayList.add(Boolean.TRUE);
                arrayList.add(Boolean.FALSE);
            } else if (valueType == ValueType.SYMBOL) {
                arrayList.addAll(this.getCls().getTemplateSlotAllowedValues(slot));
            } else {
                Assert.fail("bad type");
            }
            if (this._displayNullEntry) {
                arrayList.add(0, NONE);
            }
            defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        }
        return defaultComboBoxModel;
    }

    public JComboBox getComboBox() {
        return this._comboBox;
    }

    public Object getComboBoxSelection() {
        return this._comboBox.getSelectedItem();
    }

    public boolean getDisplayNullEntry() {
        return this._displayNullEntry;
    }

    public Collection getValues() {
        Object object = this._comboBox.getSelectedItem();
        if (object == NONE) {
            object = null;
        }
        return CollectionUtilities.createList(object);
    }

    public void initialize() {
        this._comboBox = this.createComboBox();
        this.setComboBoxModel(this.createModel());
        this.add(new LabeledComponent(this.getLabel(), this._comboBox));
        this.setPreferredColumns(1);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            boolean bl2 = valueType == ValueType.SYMBOL || valueType == ValueType.BOOLEAN;
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && !bl3;
        }
        return bl;
    }

    public void setComboBoxModel(ComboBoxModel comboBoxModel) {
        this._comboBox.removeActionListener(this._listener);
        this._comboBox.setModel(comboBoxModel);
        this._comboBox.addActionListener(this._listener);
    }

    protected void setComboBoxValue(String string) {
        this._comboBox.removeActionListener(this._listener);
        this._comboBox.setSelectedItem(string);
        this._comboBox.addActionListener(this._listener);
    }

    public void setDisplayNullEntry(boolean bl) {
        this._displayNullEntry = bl;
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        this._comboBox.setEnabled(bl);
    }

    public void setLabel(String string) {
        super.setLabel(string);
        LabeledComponent labeledComponent = (LabeledComponent)this.getComponent(0);
        labeledComponent.setHeaderLabel(string);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this._comboBox.setRenderer(listCellRenderer);
    }

    public void setValues(Collection collection) {
        Object x = CollectionUtilities.getFirstItem(collection);
        this._comboBox.setSelectedItem(x);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = super.createWidgetConfigurationPanel();
        widgetConfigurationPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return widgetConfigurationPanel;
    }
}

