/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormWidgetConfigurationLayoutTab
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -722901270560732259L;
    private static final String ALL = "<<all>>";
    private static final String NONE = "<<none>>";
    private FormWidget _formWidget;
    private JComboBox _horizontalStretcherComponent;
    private JComboBox _verticalStretcherComponent;

    public FormWidgetConfigurationLayoutTab(FormWidget formWidget) {
        this._formWidget = formWidget;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        jPanel.add(this.createVerticalStretcherComponent());
        jPanel.add(this.createHorizontalStretcherComponent());
        this.add((Component)jPanel, "North");
    }

    private JComponent createHorizontalStretcherComponent() {
        this._horizontalStretcherComponent = ComponentFactory.createComboBox();
        this._horizontalStretcherComponent.setRenderer(FrameRenderer.createInstance());
        ArrayList<String> arrayList = new ArrayList<String>(this._formWidget.getCls().getVisibleTemplateSlots());
        arrayList.add(0, ALL);
        arrayList.add(1, NONE);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._horizontalStretcherComponent.setModel(defaultComboBoxModel);
        this.setSelection(this._horizontalStretcherComponent, this._formWidget.getHorizontalStretcher(), true);
        return new LabeledComponent("Fill Horizontal Space With:", this._horizontalStretcherComponent);
    }

    private JComponent createVerticalStretcherComponent() {
        this._verticalStretcherComponent = ComponentFactory.createComboBox();
        this._verticalStretcherComponent.setRenderer(FrameRenderer.createInstance());
        ArrayList<String> arrayList = new ArrayList<String>(this._formWidget.getCls().getVisibleTemplateSlots());
        arrayList.add(0, ALL);
        arrayList.add(1, NONE);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._verticalStretcherComponent.setModel(defaultComboBoxModel);
        this.setSelection(this._verticalStretcherComponent, this._formWidget.getVerticalStretcher(), false);
        return new LabeledComponent("Fill Vertical Space With:", this._verticalStretcherComponent);
    }

    private String getSelection(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object != null && object != ALL && object != NONE) {
            Slot slot = (Slot)object;
            object = slot.getName();
        }
        return object == null ? null : object.toString();
    }

    public void saveContents() {
        String string = this.getSelection(this._horizontalStretcherComponent);
        String string2 = this.getSelection(this._verticalStretcherComponent);
        this._formWidget.setHorizontalStretcher(string == null ? ALL.toString() : string);
        this._formWidget.setVerticalStretcher(string2 == null ? NONE.toString() : string2);
    }

    private void setSelection(JComboBox jComboBox, String string, boolean bl) {
        Object object = string == null ? (bl ? ALL : NONE) : (string.equals(ALL) ? ALL : (string.equals(NONE) ? NONE : this._formWidget.getKnowledgeBase().getSlot(string)));
        jComboBox.setSelectedItem(object);
    }

    public boolean validateContents() {
        return true;
    }
}

