/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrappedInstance
implements Localizable,
Serializable,
Disposable {
    private Instance wrappedProtegeInstance;

    protected AbstractWrappedInstance(Instance instance) {
        this.wrappedProtegeInstance = instance;
    }

    protected AbstractWrappedInstance() {
    }

    public Instance getWrappedProtegeInstance() {
        return this.wrappedProtegeInstance;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.wrappedProtegeInstance == null ? null : this.wrappedProtegeInstance.getKnowledgeBase();
    }

    public String getName() {
        return this.wrappedProtegeInstance.getName();
    }

    protected boolean hasSlotValues(Slot slot) {
        return this.getKnowledgeBase().getOwnSlotValueCount(this.wrappedProtegeInstance, slot) > 0;
    }

    protected void addSlotValue(Slot slot, Object object) {
        this.wrappedProtegeInstance.addOwnSlotValue(slot, this.getUnwrappedObject(object));
    }

    protected void removeSlotValue(Slot slot, Object object) {
        this.wrappedProtegeInstance.removeOwnSlotValue(slot, this.getUnwrappedObject(object));
    }

    protected void setSlotValue(Slot slot, Object object) {
        this.wrappedProtegeInstance.setOwnSlotValue(slot, this.getUnwrappedObject(object));
    }

    protected void setSlotValues(Slot slot, Collection<?> collection) {
        this.wrappedProtegeInstance.setOwnSlotValues(slot, this.getUnwrappedCollection(collection));
    }

    public boolean canAs(Class<?> clazz) {
        return OntologyJavaMappingUtil.canAs(this, clazz);
    }

    public <X> X as(Class<? extends X> clazz) {
        return OntologyJavaMappingUtil.as(this, clazz);
    }

    public void delete() {
        this.wrappedProtegeInstance.delete();
    }

    private Collection<?> getUnwrappedCollection(Collection<?> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object obj : collection) {
            arrayList.add(this.getUnwrappedObject(obj));
        }
        return arrayList;
    }

    private Object getUnwrappedObject(Object object) {
        if (object instanceof AbstractWrappedInstance) {
            object = ((AbstractWrappedInstance)object).getWrappedProtegeInstance();
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractWrappedInstance)) {
            return false;
        }
        Instance instance = ((AbstractWrappedInstance)object).getWrappedProtegeInstance();
        if (instance == null) {
            return this.getWrappedProtegeInstance() == null;
        }
        return instance.equals(this.getWrappedProtegeInstance());
    }

    public int hashCode() {
        return this.getWrappedProtegeInstance().getName().length() + 42;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this.wrappedProtegeInstance, knowledgeBase);
    }

    @Override
    public void dispose() {
        this.wrappedProtegeInstance = null;
    }

    public String toString() {
        return this.getName();
    }
}

