/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.event.TransactionListener;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.MinimumCardinalityConstraint;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.DefaultFrameFactory;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.job.GetServerProjectName;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKnowledgeBase
implements KnowledgeBase {
    private static transient Logger log = Log.getLogger(DefaultKnowledgeBase.class);
    private static final int GENERATED_NAME_LENGTH = 8;
    private FrameStoreManager _frameStoreManager;
    private SystemFrames _systemFrames;
    private FrameFactory _frameFactory;
    private Cls _defaultClsMetaCls;
    private Cls _defaultSlotMetaCls;
    private Cls _defaultFacetMetaCls;
    private String _buildString;
    private String _frameNamePrefix;
    private Map _clientInformation = new HashMap();
    private KnowledgeBaseFactory _knowledgeBaseFactory;
    private Project _project;
    private String _name;
    private String _versionString;
    private FrameNameValidator _frameNameValidator;
    private ServerCacheStateMachine cacheMachine;
    private String _userName;
    public static final String SERVER_PROCESS_USER = "**Server Process UserId**";
    private boolean clientServerAdjusted;

    private void initializeKBName() {
        String string = String.valueOf(Math.random());
        int n = Math.min(string.length(), 8);
        this._name = "KB_" + string.substring(2, n);
    }

    protected SystemFrames createSystemFrames() {
        return new SystemFrames(this);
    }

    protected FrameFactory createFrameFactory() {
        return new DefaultFrameFactory(this);
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new FrameStoreManager(this);
    }

    @Override
    public FrameStoreManager getFrameStoreManager() {
        return this._frameStoreManager;
    }

    public FrameStore getHeadFrameStore() {
        if (this._frameStoreManager == null) {
            throw new RuntimeException("Method called on closed knowledgeBase: " + this.getName());
        }
        return this._frameStoreManager.getHeadFrameStore();
    }

    public DefaultKnowledgeBase(KnowledgeBaseFactory knowledgeBaseFactory) {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
        this.clientServerAdjusted = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 1 Initialization of Model starts");
        }
        this._knowledgeBaseFactory = knowledgeBaseFactory;
    }

    public DefaultKnowledgeBase() {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
        this.clientServerAdjusted = false;
    }

    @Override
    public synchronized SystemFrames getSystemFrames() {
        return this._systemFrames;
    }

    @Override
    public synchronized FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public synchronized void close() {
        this._frameStoreManager.close();
    }

    @Override
    public synchronized boolean setCleanDispatchEnabled(boolean bl) {
        return this._frameStoreManager.setCleanDispatchEnabled(bl);
    }

    @Override
    public synchronized boolean setArgumentCheckingEnabled(boolean bl) {
        return this._frameStoreManager.setArgumentCheckingEnabled(bl);
    }

    @Override
    public synchronized boolean isJournalingEnabled() {
        return this._frameStoreManager.isJournalingEnabled();
    }

    @Override
    public synchronized boolean isCallCachingEnabled() {
        return this._frameStoreManager.isCallCachingEnabled();
    }

    @Override
    public synchronized boolean setJournalingEnabled(boolean bl) {
        return this._frameStoreManager.setJournalingEnabled(bl);
    }

    @Override
    public synchronized boolean setUndoEnabled(boolean bl) {
        return this._frameStoreManager.setUndoEnabled(bl);
    }

    public synchronized boolean setEventDispatchEnabled(boolean bl) {
        return this._frameStoreManager.setEventDispatchEnabled(bl);
    }

    @Override
    public synchronized boolean setCallCachingEnabled(boolean bl) {
        return this._frameStoreManager.setCallCachingEnabled(bl);
    }

    @Override
    public synchronized boolean setGenerateEventsEnabled(boolean bl) {
        return this._frameStoreManager.setGenerateEventsEnabled(bl);
    }

    private UndoFrameStore getUndoFrameStore() {
        return this._frameStoreManager.getUndoFrameStore();
    }

    @Override
    public synchronized boolean isUndoEnabled() {
        return this._frameStoreManager.isUndoEnabled();
    }

    @Override
    public void flushEvents() throws ProtegeException {
        this._frameStoreManager.flushEvents();
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValues(frame, slot);
    }

    public synchronized Cls createCls(String string, Collection collection, Collection collection2, boolean bl) {
        return this.createCls(new FrameID(string), collection, collection2, bl);
    }

    @Override
    public synchronized Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        return this.getHeadFrameStore().createCls(frameID, collection2, collection, bl);
    }

    @Override
    public synchronized Slot createSlot(String string, Cls cls, Collection collection, boolean bl) {
        return this.createSlot(new FrameID(string), CollectionUtilities.createCollection(cls), collection, bl);
    }

    public synchronized Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        return this.getHeadFrameStore().createSlot(frameID, collection, collection2, bl);
    }

    public synchronized SimpleInstance createSimpleInstance(String string, Cls cls, boolean bl) {
        return this.createSimpleInstance(new FrameID(string), cls, bl);
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        return this.getHeadFrameStore().createSimpleInstance(frameID, collection, bl);
    }

    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, Cls cls, boolean bl) {
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        return this.createSimpleInstance(frameID, collection, bl);
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Slot && slot.equals(this._systemFrames.getValueTypeSlot())) {
            ValueType valueType = ValueTypeConstraint.getType(collection);
            collection = CollectionUtilities.removeFirst(collection);
            this.setValueTypeValues((Slot)frame, valueType, collection);
        } else {
            this.getHeadFrameStore().setDirectOwnSlotValues(frame, slot, collection);
        }
    }

    @Override
    public synchronized Frame getFrame(FrameID frameID) {
        return this.getHeadFrameStore().getFrame(frameID);
    }

    @Override
    public synchronized Frame getFrame(String string) {
        return this.getHeadFrameStore().getFrame(string);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(list);
    }

    @Override
    public synchronized Collection<Slot> getOwnSlots(Frame frame) {
        return this.getHeadFrameStore().getOwnSlots(frame);
    }

    @Override
    public synchronized Collection getTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getTemplateSlots(cls);
    }

    public synchronized Collection<Reference> getReferences(Frame frame) {
        return this.getHeadFrameStore().getReferences(frame);
    }

    @Override
    public synchronized void deleteFrame(Frame frame) {
        if (frame instanceof Cls) {
            this.deleteCls((Cls)frame);
        } else if (frame instanceof Slot) {
            this.deleteSlot((Slot)frame);
        } else if (frame instanceof Facet) {
            this.deleteFacet((Facet)frame);
        } else {
            this.deleteSimpleInstance((SimpleInstance)frame);
        }
    }

    @Override
    @Deprecated
    public synchronized boolean setEventsEnabled(boolean bl) {
        return this.setGenerateEventsEnabled(bl);
    }

    @Override
    @Deprecated
    public synchronized boolean getEventsEnabled() {
        return this.getGenerateEventsEnabled();
    }

    @Override
    public synchronized boolean getGenerateEventsEnabled() {
        return this._frameStoreManager.getGenerateEventsEnabled();
    }

    @Override
    public synchronized boolean getDispatchEventsEnabled() {
        return this._frameStoreManager.getDispatchEventsEnabled();
    }

    @Override
    public synchronized boolean setDispatchEventsEnabled(boolean bl) {
        return this._frameStoreManager.setEventDispatchEnabled(bl);
    }

    @Override
    public synchronized boolean setChangeMonitorEnabled(boolean bl) {
        return this._frameStoreManager.setChangeMonitorEnabled(bl);
    }

    @Override
    public synchronized Cls getDirectType(Instance instance) {
        Collection collection = this.getDirectTypes(instance);
        return (Cls)CollectionUtilities.getFirstItem(collection);
    }

    @Override
    public synchronized Collection<Cls> getDirectSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSuperclasses(cls);
    }

    @Override
    public synchronized String getName(Frame frame) {
        return this.getHeadFrameStore().getFrameName(frame);
    }

    @Override
    public synchronized void addJavaLoadPackage(String string) {
        this._frameFactory.addJavaPackage(string);
    }

    @Override
    public synchronized boolean areValidOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        boolean bl = true;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (bl && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            bl = facet.areValidValues(frame, slot, collection);
        }
        return bl;
    }

    @Override
    public synchronized boolean containsFrame(String string) {
        return this.getFrame(string) != null;
    }

    @Override
    public synchronized Cls createCls(String string, Collection collection) {
        return this.createCls(string, collection, this.getDefaultClsMetaCls(collection));
    }

    private Cls getDefaultClsMetaCls(Collection collection) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        Cls cls2 = cls == null || DefaultKnowledgeBase.equals(cls, this._systemFrames.getRootCls()) ? this._defaultClsMetaCls : cls.getDirectType();
        return cls2;
    }

    @Override
    public synchronized Cls createCls(String string, Collection collection, Cls cls) {
        return this.createCls(string, collection, cls, true);
    }

    @Override
    public synchronized Cls createCls(String string, Collection collection, Cls cls, boolean bl) {
        Collection<Cls> collection2 = CollectionUtilities.createCollection(cls);
        return this.createCls(string, collection, collection2, bl);
    }

    @Override
    public synchronized Facet createFacet(String string) {
        return this.createFacet(string, this._defaultFacetMetaCls);
    }

    @Override
    public synchronized Facet createFacet(String string, Cls cls) {
        return this.createFacet(string, cls, true);
    }

    @Override
    public synchronized Facet createFacet(String string, Cls cls, boolean bl) {
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        return this.createFacet(new FrameID(string), collection, bl);
    }

    public synchronized Facet createFacet(FrameID frameID, Collection arrayList, boolean bl) {
        if (arrayList.isEmpty()) {
            arrayList = new ArrayList<Cls>();
            arrayList.add(this._defaultFacetMetaCls);
        }
        return this.getHeadFrameStore().createFacet(frameID, arrayList, bl);
    }

    @Override
    public synchronized Instance createInstance(String string, Cls cls) {
        return this.createInstance(string, cls, true);
    }

    @Override
    public synchronized Instance createInstance(String string, Collection collection) {
        return this.createInstance(new FrameID(string), collection, true);
    }

    @Override
    public synchronized Instance createInstance(String string, Cls cls, boolean bl) {
        return this.createInstance(new FrameID(string), cls, bl);
    }

    @Override
    public synchronized Instance createInstance(FrameID frameID, Cls cls, boolean bl) {
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        return this.createInstance(frameID, collection, bl);
    }

    @Override
    public synchronized Instance createInstance(FrameID frameID, Collection collection, boolean bl) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        Instance instance = cls == null ? this.createSimpleInstance(frameID, cls, bl) : (this.isClsMetaCls(cls) ? this.createCls(frameID, (Collection)Collections.EMPTY_LIST, collection, bl) : (this.isSlotMetaCls(cls) ? this.createSlot(frameID, collection, (Collection)Collections.EMPTY_LIST, bl) : (this.isFacetMetaCls(cls) ? this.createFacet(frameID, collection, bl) : this.createSimpleInstance(frameID, collection, bl))));
        return instance;
    }

    @Override
    public synchronized Slot createSlot(String string) {
        return this.createSlot(string, this._defaultSlotMetaCls);
    }

    @Override
    public synchronized Slot createSlot(String string, Cls cls) {
        return this.createSlot(string, cls, true);
    }

    @Override
    public synchronized Slot createSlot(String string, Cls cls, boolean bl) {
        return this.createSlot(string, cls, (Collection)Collections.EMPTY_LIST, bl);
    }

    @Override
    @Deprecated
    public String createUniqueFrameName(String string) {
        return null;
    }

    @Override
    public synchronized void deleteCls(Cls cls) {
        if (!this.getInstances(cls).isEmpty()) {
            throw new RuntimeException("Delete of class with instances.");
        }
        this.getHeadFrameStore().deleteCls(cls);
        DefaultKnowledgeBase.markAsDeleted(cls);
    }

    private void moveSubclassesToParents(Cls cls, Collection collection) {
        for (Cls cls2 : new ArrayList(this.getDirectSubclasses(cls))) {
            this.moveSubclassToParents(cls2, cls, collection);
        }
    }

    private void moveSubclassToParents(Cls cls, Cls cls2, Collection collection) {
        for (Cls cls3 : collection) {
            this.addDirectSuperclass(cls, cls3);
            this.removeDirectSuperclass(cls, cls2);
        }
    }

    private void moveInstancesToParents(Cls cls, Collection collection) {
        for (Instance instance : new ArrayList<Instance>(this.getDirectInstances(cls))) {
            this.moveInstanceToParents(instance, cls, collection);
        }
    }

    private void moveInstanceToParents(Instance instance, Cls cls, Collection collection) {
        for (Cls cls2 : collection) {
            this.addDirectType(instance, cls2);
            this.removeDirectType(instance, cls);
        }
    }

    @Override
    public synchronized void deleteFacet(Facet facet) {
        this.getHeadFrameStore().deleteFacet(facet);
        DefaultKnowledgeBase.markAsDeleted(facet);
    }

    @Override
    public synchronized void deleteInstance(Instance instance) {
        this.deleteFrame(instance);
    }

    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.getHeadFrameStore().deleteSimpleInstance(simpleInstance);
        DefaultKnowledgeBase.markAsDeleted(simpleInstance);
    }

    @Override
    public synchronized void deleteSlot(Slot slot) {
        this.getHeadFrameStore().deleteSlot(slot);
        DefaultKnowledgeBase.markAsDeleted(slot);
    }

    private static void markAsDeleted(Frame frame) {
        frame.markDeleted(true);
    }

    @Override
    public synchronized String getBuildString() {
        return this._buildString;
    }

    @Override
    public synchronized Object getClientInformation(Object object) {
        return this._clientInformation.get(object);
    }

    @Override
    public synchronized Cls getCls(String string) {
        return (Cls)this.getFrameOfType(string, Cls.class);
    }

    private Frame getFrameOfType(String string, Class clazz) {
        Frame frame = this.getFrame(string);
        if (frame != null && !clazz.isInstance(frame)) {
            this.getFrame(string);
            Log.getLogger().warning("Wrong type: " + frame);
            frame = null;
        }
        return frame;
    }

    @Override
    public synchronized int getClsCount() {
        return this.getHeadFrameStore().getClsCount();
    }

    @Override
    public synchronized int getSimpleInstanceCount() {
        return this.getHeadFrameStore().getSimpleInstanceCount();
    }

    @Override
    public synchronized Collection<Cls> getClses() {
        return this.getHeadFrameStore().getClses();
    }

    @Override
    public synchronized Collection getClsNameMatches(String string, int n) {
        Collection<Frame> collection = this.getFrameNameMatches(string, n);
        Iterator<Frame> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Frame frame = iterator.next();
            if (frame instanceof Cls) continue;
            iterator.remove();
        }
        return collection;
    }

    @Override
    public synchronized Cls getDefaultClsMetaCls() {
        return this._defaultClsMetaCls;
    }

    @Override
    public synchronized Cls getDefaultFacetMetaCls() {
        return this._defaultFacetMetaCls;
    }

    @Override
    public synchronized Cls getDefaultSlotMetaCls() {
        return this._defaultSlotMetaCls;
    }

    @Override
    public synchronized Facet getFacet(String string) {
        return (Facet)this.getFrameOfType(string, Facet.class);
    }

    @Override
    public synchronized int getFacetCount() {
        return this.getHeadFrameStore().getFacetCount();
    }

    @Override
    public synchronized Collection getFacets() {
        return this.getHeadFrameStore().getFacets();
    }

    @Override
    public synchronized int getFrameCount() {
        return this.getHeadFrameStore().getFrameCount();
    }

    @Override
    public synchronized String getFrameCreationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreationTimestampSlot());
    }

    @Override
    public synchronized String getFrameCreator(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreatorSlot());
    }

    @Override
    public synchronized String getFrameLastModificationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModificationTimestampSlot());
    }

    @Override
    public synchronized String getFrameLastModifier(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModifierSlot());
    }

    @Override
    public synchronized Collection<Frame> getFrameNameMatches(String string, int n) {
        return this.getFramesWithMatchingDirectOwnSlotValue(this._systemFrames.getNameSlot(), string, n);
    }

    @Override
    public synchronized Collection getFramesWithValue(Slot slot, Facet facet, boolean bl, Object object) {
        Set<Object> set = facet == null ? (bl ? this.getHeadFrameStore().getClsesWithDirectTemplateSlotValue(slot, object) : this.getHeadFrameStore().getFramesWithDirectOwnSlotValue(slot, object)) : this.getHeadFrameStore().getClsesWithDirectTemplateFacetValue(slot, facet, object);
        return set;
    }

    public synchronized Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        return this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
    }

    @Override
    public synchronized String getFrameNamePrefix() {
        return this._frameNamePrefix;
    }

    public synchronized Collection getFrames() {
        return this.getHeadFrameStore().getFrames();
    }

    @Override
    public synchronized Instance getInstance(String string) {
        return (Instance)this.getFrame(string);
    }

    @Override
    public synchronized SimpleInstance getSimpleInstance(String string) {
        return (SimpleInstance)this.getFrame(string);
    }

    @Override
    public synchronized Collection<Instance> getInstances() {
        return this.getFrames();
    }

    @Override
    @Deprecated
    public synchronized Collection<Instance> getInstances(Cls cls) {
        return this.getHeadFrameStore().getInstances(cls);
    }

    @Override
    public synchronized String getInvalidOwnSlotValuesText(Frame frame, Slot slot, Collection collection) {
        String string = null;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (string == null && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            string = facet.getInvalidValuesText(frame, slot, collection);
        }
        return string;
    }

    @Override
    public synchronized String getInvalidOwnSlotValueText(Frame frame, Slot slot, Object object) {
        String string = null;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (string == null && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            string = facet.getInvalidValueText(frame, slot, object);
        }
        return string;
    }

    @Override
    public synchronized KnowledgeBaseFactory getKnowledgeBaseFactory() {
        return this._knowledgeBaseFactory;
    }

    public synchronized Collection getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        Set<Object> set = facet == null ? (bl ? this.getHeadFrameStore().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n) : this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, string, n)) : this.getHeadFrameStore().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
        return set;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    @Deprecated
    public synchronized int getNextFrameNumber() {
        return 0;
    }

    @Override
    public synchronized Project getProject() {
        return this._project;
    }

    @Override
    public synchronized Collection getReachableSimpleInstances(Collection collection) {
        HashSet hashSet = new HashSet();
        for (Instance instance : collection) {
            this.addReachableSimpleInstances(instance, hashSet);
        }
        return hashSet;
    }

    private void addReachableSimpleInstances(Instance instance, Collection collection) {
        if (!collection.contains(instance)) {
            collection.add(instance);
            for (Slot slot : this.getOwnSlots(instance)) {
                this.addInstances(instance, slot, collection);
            }
        }
    }

    private synchronized void addInstances(Instance instance, Slot slot, Collection collection) {
        if (instance.getOwnSlotValueType(slot) == ValueType.INSTANCE) {
            for (Instance instance2 : instance.getOwnSlotValues(slot)) {
                if (!(instance2 instanceof SimpleInstance)) continue;
                this.addReachableSimpleInstances(instance2, collection);
            }
        }
    }

    public synchronized Collection getReferences(Object object, int n) {
        return this.getHeadFrameStore().getReferences(object);
    }

    @Override
    public synchronized Collection<Reference> getMatchingReferences(String string, int n) {
        return this.getHeadFrameStore().getMatchingReferences(string, n);
    }

    @Override
    public synchronized Collection<Cls> getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        return this.getHeadFrameStore().getClsesWithMatchingBrowserText(string, collection, n);
    }

    @Override
    public synchronized Cls getRootCls() {
        return this._systemFrames.getRootCls();
    }

    @Override
    public synchronized Collection getRootClses() {
        return CollectionUtilities.createCollection(this.getRootCls());
    }

    @Override
    public synchronized Cls getRootClsMetaCls() {
        return this._systemFrames.getRootClsMetaCls();
    }

    @Override
    public synchronized Cls getRootFacetMetaCls() {
        return this._systemFrames.getRootFacetMetaCls();
    }

    @Override
    public synchronized Cls getRootSlotMetaCls() {
        return this._systemFrames.getRootSlotMetaCls();
    }

    @Override
    public synchronized Collection getRootSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>(this.getSlots());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (this.getDirectSuperslotCount(slot) <= 0) continue;
            iterator.remove();
        }
        return arrayList;
    }

    @Override
    public synchronized Slot getSlot(String string) {
        return (Slot)this.getFrameOfType(string, Slot.class);
    }

    @Override
    public synchronized int getSlotCount() {
        return this.getHeadFrameStore().getSlotCount();
    }

    @Override
    public synchronized Collection<Slot> getSlots() {
        return this.getHeadFrameStore().getSlots();
    }

    @Override
    @Deprecated
    public synchronized String getSlotValueLastModificationTimestamp(Frame frame, Slot slot, boolean bl) {
        return null;
    }

    @Override
    @Deprecated
    public synchronized String getSlotValueLastModifier(Frame frame, Slot slot, boolean bl) {
        return null;
    }

    @Override
    public synchronized Collection getSubclasses(Cls cls) {
        return this.getHeadFrameStore().getSubclasses(cls);
    }

    @Override
    public synchronized Collection getUnreachableSimpleInstances(Collection collection) {
        HashSet hashSet = new HashSet(this.getFrames());
        hashSet.removeAll(this.getClses());
        hashSet.removeAll(this.getSlots());
        hashSet.removeAll(this.getFacets());
        hashSet.removeAll(this.getReachableSimpleInstances(collection));
        return hashSet;
    }

    @Override
    public synchronized String getUserName() {
        if (this._userName != null) {
            return this._userName;
        }
        Project project = this.getProject();
        if (project != null && project.isMultiUserClient()) {
            FrameStoreManager frameStoreManager = this.getFrameStoreManager();
            RemoteClientFrameStore remoteClientFrameStore = frameStoreManager.getFrameStoreFromClass(RemoteClientFrameStore.class);
            this._userName = remoteClientFrameStore.getSession().getUserName();
            return this._userName;
        }
        if (project != null && project.isMultiUserServer()) {
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            if (remoteSession != null) {
                return remoteSession.getUserName();
            }
            return SERVER_PROCESS_USER;
        }
        this._userName = ApplicationProperties.getUserName();
        return this._userName;
    }

    @Override
    public synchronized String getVersionString() {
        return this._versionString;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this._frameStoreManager.hasChanged();
    }

    @Override
    public synchronized boolean isAutoUpdatingFacetValues() {
        return false;
    }

    @Override
    public synchronized boolean isClsMetaCls(Cls cls) {
        Cls cls2 = this.getRootClsMetaCls();
        return DefaultKnowledgeBase.equals(cls, cls2) || this.hasSuperclass(cls, cls2);
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    @Override
    public synchronized boolean isDefaultClsMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultClsMetaCls);
    }

    @Override
    public synchronized boolean isDefaultFacetMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultFacetMetaCls);
    }

    @Override
    public synchronized boolean isDefaultSlotMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultSlotMetaCls);
    }

    @Override
    public synchronized boolean isFacetMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootFacetMetaCls());
    }

    @Override
    public synchronized boolean isLoading() {
        return false;
    }

    @Override
    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    @Override
    public synchronized boolean isValidOwnSlotValue(Frame frame, Slot slot, Object object) {
        boolean bl = true;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (bl && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            bl = facet.isValidValue(frame, slot, object);
        }
        return bl;
    }

    @Override
    public synchronized void removeJavaLoadPackage(String string) {
        this._frameFactory.removeJavaPackage(string);
    }

    @Override
    @Deprecated
    public synchronized void setAutoUpdateFacetValues(boolean bl) {
        this.setModificationRecordUpdatingEnabled(bl);
    }

    @Override
    public synchronized boolean setModificationRecordUpdatingEnabled(boolean bl) {
        return this._frameStoreManager.setModificationRecordUpdatingEnabled(bl);
    }

    @Override
    public synchronized void setBuildString(String string) {
        this._buildString = string;
    }

    @Override
    public synchronized void setChanged(boolean bl) {
        this._frameStoreManager.setChanged(bl);
    }

    @Override
    public synchronized Object setClientInformation(Object object, Object object2) {
        Object v = this._clientInformation.get(object);
        this._clientInformation.put(object, object2);
        return v;
    }

    @Override
    public synchronized void setDefaultClsMetaCls(Cls cls) {
        if (cls == null || this.isClsMetaCls(cls)) {
            this._defaultClsMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a class meta class: " + cls);
        }
    }

    @Override
    public synchronized void setDefaultFacetMetaCls(Cls cls) {
        if (cls == null || this.isFacetMetaCls(cls)) {
            this._defaultFacetMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a facet meta class: " + cls);
        }
    }

    @Override
    public synchronized void setDefaultSlotMetaCls(Cls cls) {
        if (cls == null || this.isSlotMetaCls(cls)) {
            this._defaultSlotMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a slot meta class: " + cls);
        }
    }

    @Override
    public synchronized void setFrameNamePrefix(String string) {
        this._frameNamePrefix = string;
    }

    public synchronized void setLoading(boolean bl) {
        this.setEventsEnabled(!bl);
    }

    @Override
    public synchronized void setName(String string) {
        this._name = string;
    }

    @Override
    @Deprecated
    public synchronized void setNextFrameNumber(int n) {
    }

    @Override
    public synchronized void setProject(Project project) {
        this._project = project;
        if (!this.clientServerAdjusted) {
            if (project.isMultiUserClient()) {
                this.adjustForClient();
            }
            if (project.isMultiUserServer()) {
                this.adjustForServer();
            }
            this.clientServerAdjusted = true;
        }
    }

    protected void adjustForClient() {
        DeleteSimplificationFrameStore deleteSimplificationFrameStore = this._frameStoreManager.getFrameStoreFromClass(DeleteSimplificationFrameStore.class);
        this._frameStoreManager.setEnabled(deleteSimplificationFrameStore, false);
        EventGeneratorFrameStore eventGeneratorFrameStore = this._frameStoreManager.getFrameStoreFromClass(EventGeneratorFrameStore.class);
        if (eventGeneratorFrameStore != null) {
            this._frameStoreManager.setEnabled(eventGeneratorFrameStore, false);
        }
    }

    protected void adjustForServer() {
    }

    @Override
    @Deprecated
    public synchronized void setValueChecking(boolean bl) {
        this.setFacetCheckingEnabled(bl);
    }

    @Override
    public synchronized boolean setFacetCheckingEnabled(boolean bl) {
        return this._frameStoreManager.setFacetCheckingEnabled(bl);
    }

    @Override
    public synchronized void setVersionString(String string) {
        this._versionString = string;
    }

    @Override
    public synchronized void dispose() {
        if (this._frameStoreManager != null) {
            this._frameStoreManager.close();
        }
        this._frameStoreManager = null;
        this._project = null;
    }

    @Override
    public synchronized boolean isClosed() {
        return this._frameStoreManager != null;
    }

    public synchronized Collection getReachableSimpleInstances(Frame frame) {
        return this.getReachableSimpleInstances(CollectionUtilities.createCollection(frame));
    }

    @Override
    @Deprecated
    public synchronized void addOwnSlotValue(Frame frame, Slot slot, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getDirectOwnSlotValues(frame, slot));
        arrayList.add(object);
        this.setDirectOwnSlotValues(frame, slot, arrayList);
    }

    @Override
    public synchronized Collection getDocumentation(Frame frame) {
        return this.getOwnSlotValues(frame, this._systemFrames.getDocumentationSlot());
    }

    @Override
    public synchronized boolean getOwnSlotAllowsMultipleValues(Frame frame, Slot slot) {
        Cls cls = ((Instance)frame).getDirectType();
        return this.getTemplateSlotAllowsMultipleValues(cls, slot);
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotAndSubslotValues(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized Collection getOwnSlotDefaultValues(Frame frame, Slot slot) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Cls cls : ((Instance)frame).getDirectTypes()) {
            linkedHashSet.addAll(this.getTemplateSlotDefaultValues(cls, slot));
        }
        return linkedHashSet;
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotFacets(Frame frame, Slot slot) {
        return this.getOwnFacets(frame, slot);
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getOwnFacetValues(frame, slot, facet);
    }

    public synchronized Collection getOwnFacets(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnFacets(frame, slot);
    }

    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Object getOwnSlotValue(Frame frame, Slot slot) {
        Collection collection = this.getOwnSlotValues(frame, slot);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    @Override
    public synchronized int getOwnSlotValueCount(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot).size();
    }

    @Override
    public synchronized ValueType getOwnSlotValueType(Frame frame, Slot slot) {
        Collection collection = this.getOwnFacetValues(frame, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(collection);
    }

    @Override
    public synchronized boolean hasOwnSlot(Frame frame, Slot slot) {
        return this.getOwnSlots(frame).contains(slot);
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.getHeadFrameStore().moveDirectOwnSlotValue(frame, slot, n, n2);
    }

    @Override
    @Deprecated
    public synchronized void removeOwnSlotValue(Frame frame, Slot slot, Object object) {
        ArrayList arrayList = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        arrayList.remove(object);
        this.setDirectOwnSlotValues(frame, slot, arrayList);
    }

    @Override
    public synchronized void setDocumentation(Frame frame, String string) {
        this.setDirectOwnSlotValue(frame, this._systemFrames.getDocumentationSlot(), string);
    }

    @Override
    public synchronized void setDocumentation(Frame frame, Collection collection) {
        this.setDirectOwnSlotValues(frame, this._systemFrames.getDocumentationSlot(), collection);
    }

    @Deprecated
    public synchronized void setOwnSlotValue(Frame frame, Slot slot, Object object) {
        this.setDirectOwnSlotValue(frame, slot, object);
    }

    public synchronized void setDirectOwnSlotValue(Frame frame, Slot slot, Object object) {
        Collection<Object> collection = CollectionUtilities.createCollection(object);
        this.setDirectOwnSlotValues(frame, slot, collection);
    }

    @Override
    @Deprecated
    public synchronized void setOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(frame, slot, collection);
    }

    @Override
    public synchronized void notifyVisibilityChanged(Frame frame) {
    }

    @Override
    public synchronized Slot getAssociatedSlot(Facet facet) {
        return (Slot)this.getOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot());
    }

    @Override
    public synchronized void setAssociatedSlot(Facet facet, Slot slot) {
        this.setDirectOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot(), slot);
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls cls2) {
        this.getHeadFrameStore().addDirectSuperclass(cls, cls2);
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.getHeadFrameStore().removeDirectSuperclass(cls, cls2);
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls cls) {
        this.getHeadFrameStore().addDirectType(instance, cls);
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls cls) {
        this.getHeadFrameStore().removeDirectType(instance, cls);
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls cls, int n) {
        this.getHeadFrameStore().moveDirectType(instance, cls, n);
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().addDirectTemplateSlot(cls, slot);
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateSlot(cls, slot);
    }

    @Override
    @Deprecated
    public synchronized void addTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getDirectTemplateFacetValues(cls, slot, facet));
        arrayList.add(object);
        this.setDirectTemplateFacetValues(cls, slot, facet, arrayList);
    }

    @Override
    @Deprecated
    public synchronized void addTemplateSlotValue(Cls cls, Slot slot, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot));
        arrayList.add(object);
        this.setDirectTemplateSlotValues(cls, slot, arrayList);
    }

    @Override
    public synchronized Slot getNameSlot() {
        return this._systemFrames.getNameSlot();
    }

    @Override
    public synchronized int getDirectInstanceCount(Cls cls) {
        return this.getDirectInstances(cls).size();
    }

    @Override
    public synchronized Collection<Instance> getDirectInstances(Cls cls) {
        return this.getHeadFrameStore().getDirectInstances(cls);
    }

    @Override
    public synchronized int getDirectSubclassCount(Cls cls) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesCount(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public synchronized Collection getDirectSubclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSubclasses(cls);
    }

    @Override
    public synchronized int getDirectSuperclassCount(Cls cls) {
        return this.getDirectSuperclasses(cls).size();
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getDirectTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized Collection getDirectTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectTemplateSlots(cls);
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized int getInstanceCount(Cls cls) {
        return this.getInstances(cls).size();
    }

    @Override
    public synchronized Collection getSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getSuperclasses(cls);
    }

    @Override
    public synchronized Collection getTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateFacets(cls, slot);
    }

    @Override
    public synchronized Object getTemplateFacetValue(Cls cls, Slot slot, Facet facet) {
        Collection collection = this.getTemplateFacetValues(cls, slot, facet);
        return CollectionUtilities.getFirstItem(collection);
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedClses(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedClses(collection);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedParents(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedParents(collection);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedValues(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedValues(collection);
    }

    @Override
    public synchronized boolean getTemplateSlotAllowsMultipleValues(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(n);
    }

    @Override
    public synchronized Collection getTemplateSlotDefaultValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet());
    }

    @Override
    public synchronized Collection getTemplateSlotDocumentation(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet());
    }

    @Override
    public synchronized int getTemplateSlotMaximumCardinality(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.getValue(n);
    }

    public synchronized Integer getTemplateSlotMaximumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet());
    }

    public synchronized Integer getTemplateSlotMinimumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet());
    }

    @Override
    public synchronized Number getTemplateSlotMaximumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet());
    }

    @Override
    public synchronized int getTemplateSlotMinimumCardinality(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMinimumCardinality2(cls, slot);
        return MinimumCardinalityConstraint.getValue(n);
    }

    @Override
    public synchronized Number getTemplateSlotMinimumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet());
    }

    @Override
    public synchronized Object getTemplateSlotValue(Cls cls, Slot slot) {
        Collection collection = this.getTemplateSlotValues(cls, slot);
        return CollectionUtilities.getFirstItem(collection);
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized ValueType getTemplateSlotValueType(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(collection);
    }

    @Override
    public synchronized boolean hasDirectlyOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        List list = this.getDirectTemplateFacetValues(cls, slot, facet);
        return !list.isEmpty();
    }

    @Override
    public synchronized boolean hasDirectlyOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectlyOverriddenTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized Collection getDirectlyOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized Collection getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public synchronized boolean hasDirectSuperslot(Slot slot, Slot slot2) {
        return this.getDirectSuperslots(slot).contains(slot2);
    }

    @Override
    public synchronized boolean hasSuperslot(Slot slot, Slot slot2) {
        return this.getSuperslots(slot).contains(slot2);
    }

    @Override
    public synchronized boolean hasDirectSuperclass(Cls cls, Cls cls2) {
        return this.getDirectSuperclasses(cls).contains(cls2);
    }

    @Override
    public synchronized boolean hasDirectTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized boolean hasInheritedTemplateSlot(Cls cls, Slot slot) {
        return this.getInheritedTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getInheritedTemplateSlots(Cls cls) {
        HashSet hashSet = new HashSet(this.getTemplateSlots(cls));
        hashSet.removeAll(this.getDirectTemplateSlots(cls));
        return hashSet;
    }

    @Override
    public synchronized boolean hasOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getOverriddenTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized boolean hasOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        return this.getOverriddenTemplateFacets(cls, slot).contains(facet);
    }

    @Override
    public synchronized Collection getOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    @Deprecated
    public synchronized void removeTemplateFacetOverrides(Cls cls, Slot slot) {
        this.removeDirectTemplateFacetOverrides(cls, slot);
    }

    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateFacetOverrides(cls, slot);
    }

    @Override
    public synchronized boolean hasSuperclass(Cls cls, Cls cls2) {
        return this.getSuperclasses(cls).contains(cls2);
    }

    @Override
    public synchronized boolean hasTemplateSlot(Cls cls, Slot slot) {
        return this.getTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized boolean isAbstract(Cls cls) {
        String string = (String)this.getOwnSlotValue(cls, this._systemFrames.getRoleSlot());
        return RoleConstraint.isAbstract(string);
    }

    @Override
    public synchronized boolean isMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this._systemFrames.getRootMetaCls());
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, Cls cls3) {
        int n;
        ArrayList arrayList = new ArrayList(this.getDirectSubclasses(cls));
        int n2 = arrayList.indexOf(cls2);
        int n3 = n = cls3 == null ? 0 : arrayList.indexOf(cls3);
        if (n2 > n) {
            ++n;
        }
        this.moveDirectSubclass(cls, cls2, n);
    }

    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.getHeadFrameStore().moveDirectSubclass(cls, cls2, n);
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, Slot slot3) {
        int n;
        ArrayList arrayList = new ArrayList(this.getDirectSubslots(slot));
        int n2 = arrayList.indexOf(slot2);
        int n3 = n = slot3 == null ? 0 : arrayList.indexOf(slot3);
        if (n2 > n) {
            ++n;
        }
        this.moveDirectSubslot(slot, slot2, n);
    }

    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.getHeadFrameStore().moveDirectSubslot(slot, slot2, n);
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.getHeadFrameStore().moveDirectTemplateSlot(cls, slot, n);
    }

    @Override
    public synchronized void setAbstract(Cls cls, boolean bl) {
        String string = bl ? "Abstract" : "Concrete";
        this.setDirectOwnSlotValue(cls, this._systemFrames.getRoleSlot(), string);
    }

    @Override
    public synchronized void setDirectTypeOfSubclasses(Cls cls, Cls cls2) {
        for (Cls cls3 : this.getSubclasses(cls)) {
            this.setDirectType(cls3, cls2);
        }
    }

    @Override
    @Deprecated
    public synchronized void setTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        this.setDirectTemplateFacetValue(cls, slot, facet, object);
    }

    public synchronized void setDirectTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        Collection<Object> collection = CollectionUtilities.createCollection(object);
        this.setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    @Override
    @Deprecated
    public synchronized void setTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        if (facet.equals(this._systemFrames.getValueTypeFacet())) {
            this.setTemplateSlotValueTypeValues(cls, slot, collection);
        } else {
            this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, facet, collection);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, ValueType valueType, Collection collection) {
        List list = ValueTypeConstraint.getValues(valueType, collection);
        this.setTemplateSlotValueTypeValues(cls, slot, list);
    }

    @Override
    public synchronized void setTemplateSlotAllowedClses(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.INSTANCE, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    @Override
    public synchronized void setTemplateSlotAllowedParents(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.CLS, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    @Override
    public synchronized void setTemplateSlotAllowedValues(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.SYMBOL, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    @Override
    public synchronized void setTemplateSlotAllowsMultipleValues(Cls cls, Slot slot, boolean bl) {
        Integer n = MaximumCardinalityConstraint.getValue(bl);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), n);
    }

    @Override
    public synchronized void setTemplateSlotDefaultValues(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet(), collection);
    }

    @Override
    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, String string) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getDocumentationFacet(), string);
    }

    @Override
    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet(), collection);
    }

    @Override
    public synchronized void setTemplateSlotMaximumCardinality(Cls cls, Slot slot, int n) {
        Integer n2 = MaximumCardinalityConstraint.getValue(n);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), n2);
    }

    @Override
    public synchronized void setTemplateSlotMaximumValue(Cls cls, Slot slot, Number number) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet(), number);
    }

    @Override
    public synchronized void setTemplateSlotMinimumCardinality(Cls cls, Slot slot, int n) {
        Integer n2 = MinimumCardinalityConstraint.getValue(n);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet(), n2);
    }

    @Override
    public synchronized void setTemplateSlotMinimumValue(Cls cls, Slot slot, Number number) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet(), number);
    }

    @Override
    public synchronized void setTemplateSlotValue(Cls cls, Slot slot, Object object) {
        Collection<Object> collection = CollectionUtilities.createCollection(object);
        this.setDirectTemplateSlotValues(cls, slot, collection);
    }

    @Override
    @Deprecated
    public synchronized void setTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateSlotValues(cls, slot, collection);
    }

    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.getHeadFrameStore().setDirectTemplateSlotValues(cls, slot, collection);
    }

    @Override
    public synchronized void setTemplateSlotValueType(Cls cls, Slot slot, ValueType valueType) {
        if (!this.getTemplateSlotValueType(cls, slot).equals(valueType)) {
            this.setTemplateSlotValueTypeValues(cls, slot, valueType, Collections.EMPTY_LIST);
        }
    }

    @Override
    public synchronized void addInstance(Instance instance, String string, Cls cls, boolean bl) {
    }

    @Override
    public synchronized String getBrowserText(Instance instance) {
        String string;
        if (instance.isDeleted()) {
            string = "<<deleted>>";
        } else {
            Cls cls = instance.getDirectType();
            if (this._project == null) {
                string = this.getName(instance);
            } else if (cls == null) {
                string = this.getMissingTypeString(instance);
            } else {
                BrowserSlotPattern browserSlotPattern = this._project.getBrowserSlotPattern(cls);
                if (browserSlotPattern == null) {
                    string = this.getDisplaySlotNotSetString(instance);
                } else {
                    string = browserSlotPattern.getBrowserText(instance);
                    if (string == null) {
                        string = this.getDisplaySlotPatternValueNotSetString(instance, browserSlotPattern);
                    }
                }
            }
        }
        return string;
    }

    protected String getMissingTypeString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotNotSetString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotPatternValueNotSetString(Instance instance, BrowserSlotPattern browserSlotPattern) {
        return instance.getName();
    }

    protected String toString(BrowserSlotPattern browserSlotPattern) {
        return this.getBrowserText(browserSlotPattern.getFirstSlot());
    }

    protected String toString(Object object) {
        return object instanceof Frame ? this.toStringForFrame((Frame)object) : this.toStringForObject(object);
    }

    protected String toStringForFrame(Frame frame) {
        return frame.getBrowserText();
    }

    protected String toStringForObject(Object object) {
        return object.toString();
    }

    @Override
    public synchronized Collection getDirectTypes(Instance instance) {
        return this.getHeadFrameStore().getDirectTypes(instance);
    }

    @Override
    public synchronized boolean hasDirectType(Instance instance, Cls cls) {
        return this.getDirectTypes(instance).contains(cls);
    }

    @Override
    public synchronized boolean hasType(Instance instance, Cls cls) {
        return this.getTypes(instance).contains(cls);
    }

    public synchronized Collection getTypes(Instance instance) {
        return this.getHeadFrameStore().getTypes(instance);
    }

    @Override
    public synchronized Instance setDirectType(Instance instance, Cls cls) {
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        return this.setDirectTypes(instance, collection);
    }

    @Override
    public synchronized Instance setDirectTypes(Instance instance, Collection collection) {
        ArrayList arrayList = new ArrayList(this.getDirectTypes(instance));
        ArrayList arrayList2 = new ArrayList(arrayList);
        arrayList2.removeAll(collection);
        ArrayList arrayList3 = new ArrayList(collection);
        arrayList3.removeAll(arrayList);
        this.addDirectTypes(instance, arrayList3);
        this.removeDirectTypes(instance, arrayList2);
        return instance;
    }

    public synchronized void addDirectTypes(Instance instance, Collection collection) {
        for (Cls cls : collection) {
            this.getHeadFrameStore().addDirectType(instance, cls);
        }
    }

    public synchronized void removeDirectTypes(Instance instance, Collection collection) {
        for (Cls cls : collection) {
            this.getHeadFrameStore().removeDirectType(instance, cls);
        }
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot slot2) {
        this.getHeadFrameStore().addDirectSuperslot(slot, slot2);
    }

    @Override
    public synchronized Collection getAllowedClses(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedClses(collection);
    }

    @Override
    public synchronized Collection getAllowedParents(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedParents(collection);
    }

    @Override
    public synchronized Collection getAllowedValues(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedValues(collection);
    }

    private Object getStandardSlotValue(Slot slot, Slot slot2) {
        Collection collection = this.getStandardSlotValues(slot, slot2);
        return CollectionUtilities.getFirstItem(collection);
    }

    private Collection getStandardSlotValues(Slot slot, Slot slot2) {
        Collection collection = this.getDirectOwnSlotValues(slot, slot2);
        if (collection.isEmpty()) {
            collection = this.getOwnSlotValues(slot, slot2);
        }
        return collection;
    }

    @Override
    public synchronized boolean getAllowsMultipleValues(Slot slot) {
        Integer n = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(n);
    }

    @Override
    public synchronized Facet getAssociatedFacet(Slot slot) {
        Facet facet = null;
        Object object = this.getOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot());
        if (object instanceof Facet) {
            facet = (Facet)object;
        } else if (object != null) {
            Log.getLogger().warning("Invalid facet: " + object);
        }
        return facet;
    }

    @Override
    public synchronized Collection getDefaultValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot());
    }

    @Override
    public synchronized int getDirectSubslotCount(Slot slot) {
        return this.getDirectSubslots(slot).size();
    }

    @Override
    public synchronized Collection getDirectSubslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSubslots(slot);
    }

    @Override
    public synchronized Collection getDirectSuperslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSuperslots(slot);
    }

    @Override
    public synchronized int getDirectSuperslotCount(Slot slot) {
        return this.getDirectSuperslots(slot).size();
    }

    @Override
    public synchronized Slot getInverseSlot(Slot slot) {
        return (Slot)this.getOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot());
    }

    public synchronized Integer getMaximumCardinality2(Slot slot) {
        return (Integer)this.getStandardSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot());
    }

    @Override
    public synchronized int getMaximumCardinality(Slot slot) {
        Integer n = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.getValue(n);
    }

    @Override
    public synchronized Number getMaximumValue(Slot slot) {
        return (Number)this.getStandardSlotValue(slot, this._systemFrames.getMaximumValueSlot());
    }

    @Override
    public synchronized int getMinimumCardinality(Slot slot) {
        Integer n = (Integer)this.getOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot());
        return MinimumCardinalityConstraint.getValue(n);
    }

    @Override
    public synchronized Number getMinimumValue(Slot slot) {
        return (Number)this.getOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot());
    }

    @Override
    public synchronized Collection getSubslots(Slot slot) {
        return this.getHeadFrameStore().getSubslots(slot);
    }

    @Override
    public synchronized Collection getSuperslots(Slot slot) {
        return this.getHeadFrameStore().getSuperslots(slot);
    }

    @Override
    public synchronized Collection getDirectDomain(Slot slot) {
        return this.getHeadFrameStore().getDirectDomain(slot);
    }

    @Override
    public synchronized Collection getDomain(Slot slot) {
        return this.getHeadFrameStore().getDomain(slot);
    }

    @Override
    public synchronized Collection getValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getValuesSlot());
    }

    @Override
    public synchronized ValueType getValueType(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getType(collection);
    }

    @Override
    public synchronized boolean hasSlotValueAtSomeFrame(Slot slot) {
        return false;
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.getHeadFrameStore().removeDirectSuperslot(slot, slot2);
    }

    private void setValueTypeValues(Slot slot, ValueType valueType, Collection collection) {
        ValueType valueType2 = this.getValueType(slot);
        List list = ValueTypeConstraint.getValues(valueType, collection);
        this.getHeadFrameStore().setDirectOwnSlotValues(slot, this._systemFrames.getValueTypeSlot(), list);
        if (!DefaultKnowledgeBase.areComparableTypes(valueType2, valueType)) {
            this.setDefaultValues(slot, Collections.EMPTY_LIST);
            this.setValues(slot, Collections.EMPTY_LIST);
            this.clearValues(null, slot);
        }
    }

    private static boolean areComparableTypes(ValueType valueType, ValueType valueType2) {
        return DefaultKnowledgeBase.equals(valueType, valueType2) || DefaultKnowledgeBase.isFrameType(valueType) && DefaultKnowledgeBase.isFrameType(valueType2) || DefaultKnowledgeBase.isStringType(valueType) && DefaultKnowledgeBase.isStringType(valueType2) || valueType.equals(ValueType.ANY) || valueType2 == null || valueType2.equals(ValueType.ANY);
    }

    private static boolean isFrameType(ValueType valueType) {
        return DefaultKnowledgeBase.equals(valueType, ValueType.CLS) || DefaultKnowledgeBase.equals(valueType, ValueType.INSTANCE);
    }

    private static boolean isStringType(ValueType valueType) {
        return DefaultKnowledgeBase.equals(valueType, ValueType.STRING) || DefaultKnowledgeBase.equals(valueType, ValueType.SYMBOL);
    }

    private void clearValues(Cls cls, Slot slot) {
        this.clearOwnSlotValues(cls, slot);
        this.clearTemplateSlotValues(cls, slot);
    }

    private void clearOwnSlotValues(Cls cls, Slot slot) {
        for (Frame frame : new ArrayList<Frame>(this.getFramesWithAnyOwnSlotValue(slot))) {
            if (cls != null && !this.hasType((Instance)frame, cls)) continue;
            this.setOwnSlotValues(frame, slot, Collections.EMPTY_SET);
        }
    }

    private Collection<Frame> getFramesWithAnyOwnSlotValue(Slot slot) {
        return this.getHeadFrameStore().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    private Collection<Cls> getClsesWithAnyTemplateSlotValue(Slot slot) {
        return this.getHeadFrameStore().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    private void clearTemplateSlotValues(Cls cls, Slot slot) {
        for (Cls cls2 : new ArrayList<Cls>(this.getClsesWithAnyTemplateSlotValue(slot))) {
            if (cls != null && !this.hasSuperclass(cls2, cls)) continue;
            this.setTemplateSlotValues(cls2, slot, Collections.EMPTY_SET);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, Collection collection) {
        ValueType valueType = this.getTemplateSlotValueType(cls, slot);
        ValueType valueType2 = collection.isEmpty() ? null : ValueTypeConstraint.getType(collection);
        this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet(), collection);
        if (!DefaultKnowledgeBase.areComparableTypes(valueType, valueType2)) {
            this.setTemplateSlotDefaultValues(cls, slot, Collections.EMPTY_LIST);
            this.setTemplateSlotValues(cls, slot, Collections.EMPTY_LIST);
            this.clearValues(cls, slot);
        }
    }

    @Override
    public synchronized void setAllowedClses(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.INSTANCE, collection);
    }

    @Override
    public synchronized void setAllowedParents(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.CLS, collection);
    }

    @Override
    public synchronized void setAllowedValues(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.SYMBOL, collection);
    }

    @Override
    public synchronized void setAllowsMultipleValues(Slot slot, boolean bl) {
        Integer n = MaximumCardinalityConstraint.getValue(bl);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), n);
    }

    @Override
    public synchronized void setAssociatedFacet(Slot slot, Facet facet) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot(), facet);
    }

    @Override
    public synchronized void setDefaultValues(Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot(), collection);
    }

    @Override
    public synchronized void setDirectTypeOfSubslots(Slot slot, Cls cls) {
        for (Slot slot2 : this.getSubslots(slot)) {
            this.setDirectType(slot2, cls);
        }
    }

    @Override
    public synchronized void setInverseSlot(Slot slot, Slot slot2) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot(), slot2);
    }

    @Override
    public synchronized void setMaximumCardinality(Slot slot, int n) {
        Integer n2 = MaximumCardinalityConstraint.getValue(n);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), n2);
    }

    @Override
    public synchronized void setMaximumValue(Slot slot, Number number) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumValueSlot(), number);
    }

    @Override
    public synchronized void setMinimumCardinality(Slot slot, int n) {
        Integer n2 = MinimumCardinalityConstraint.getValue(n);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot(), n2);
    }

    @Override
    public synchronized void setMinimumValue(Slot slot, Number number) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot(), number);
    }

    @Override
    public synchronized void setValues(Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getValuesSlot(), collection);
    }

    @Override
    public synchronized void setValueType(Slot slot, ValueType valueType) {
        if (!this.getValueType(slot).equals(valueType)) {
            this.setValueTypeValues(slot, valueType, Collections.EMPTY_LIST);
        }
    }

    public synchronized void setUserName(String string) {
        this._userName = string;
    }

    @Override
    public synchronized void addFrameListener(Frame frame, FrameListener frameListener) {
        this.addListener(FrameListener.class, frame, frameListener);
    }

    @Override
    public synchronized void addFrameListener(FrameListener frameListener) {
        this.addFrameListener(null, frameListener);
    }

    @Override
    public synchronized void removeFrameListener(Frame frame, FrameListener frameListener) {
        this.removeListener(FrameListener.class, frame, frameListener);
    }

    @Override
    public synchronized void removeFrameListener(FrameListener frameListener) {
        this.removeFrameListener(null, frameListener);
    }

    @Override
    public synchronized void addSlotListener(Slot slot, SlotListener slotListener) {
        this.addListener(SlotListener.class, slot, slotListener);
    }

    @Override
    public synchronized void addSlotListener(SlotListener slotListener) {
        this.addSlotListener(null, slotListener);
    }

    @Override
    public synchronized void removeSlotListener(Slot slot, SlotListener slotListener) {
        this.removeListener(SlotListener.class, slot, slotListener);
    }

    @Override
    public synchronized void removeSlotListener(SlotListener slotListener) {
        this.removeSlotListener(null, slotListener);
    }

    @Override
    public synchronized void addInstanceListener(Instance instance, InstanceListener instanceListener) {
        this.addListener(InstanceListener.class, instance, instanceListener);
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.addInstanceListener(null, instanceListener);
    }

    @Override
    public synchronized void removeInstanceListener(Instance instance, InstanceListener instanceListener) {
        this.removeListener(InstanceListener.class, instance, instanceListener);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.removeInstanceListener(null, instanceListener);
    }

    @Override
    public synchronized void addClsListener(ClsListener clsListener) {
        this.addClsListener(null, clsListener);
    }

    @Override
    public synchronized void addClsListener(Cls cls, ClsListener clsListener) {
        this.addListener(ClsListener.class, cls, clsListener);
    }

    @Override
    public synchronized void removeClsListener(Cls cls, ClsListener clsListener) {
        this.removeListener(ClsListener.class, cls, clsListener);
    }

    @Override
    public synchronized void removeClsListener(ClsListener clsListener) {
        this.removeClsListener(null, clsListener);
    }

    @Override
    public synchronized void addKnowledgeBaseListener(KnowledgeBaseListener knowledgeBaseListener) {
        this.addListener(KnowledgeBaseListener.class, this, knowledgeBaseListener);
    }

    @Override
    public synchronized void removeKnowledgeBaseListener(KnowledgeBaseListener knowledgeBaseListener) {
        this.removeListener(KnowledgeBaseListener.class, this, knowledgeBaseListener);
    }

    @Override
    public synchronized void addFacetListener(Facet facet, FacetListener facetListener) {
        this.addListener(FacetListener.class, this, facetListener);
    }

    @Override
    public synchronized void addFacetListener(FacetListener facetListener) {
        this.addFacetListener(null, facetListener);
    }

    @Override
    public synchronized void removeFacetListener(Facet facet, FacetListener facetListener) {
        this.removeListener(FacetListener.class, facet, facetListener);
    }

    @Override
    public synchronized void removeFacetListener(FacetListener facetListener) {
        this.removeFacetListener(null, facetListener);
    }

    @Override
    public synchronized void addServerProjectListener(ServerProjectListener serverProjectListener) {
        String string = (String)new GetServerProjectName(this).execute();
        this.addListener(ServerProjectListener.class, string, serverProjectListener);
    }

    @Override
    public synchronized void removeServerProjectListener(ServerProjectListener serverProjectListener) {
        String string = (String)new GetServerProjectName(this).execute();
        this.removeListener(ServerProjectListener.class, string, serverProjectListener);
    }

    private void addListener(Class clazz, Object object, EventListener eventListener) {
        this._frameStoreManager.addListener(clazz, object, eventListener);
    }

    private void removeListener(Class clazz, Object object, EventListener eventListener) {
        this._frameStoreManager.removeListener(clazz, object, eventListener);
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.getName() + ")";
    }

    @Override
    public synchronized Collection getCurrentUsers() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public synchronized boolean beginTransaction(String string) {
        return this.getHeadFrameStore().beginTransaction(string);
    }

    @Override
    public synchronized boolean beginTransaction(String string, String string2) {
        if (string2 == null) {
            return this.beginTransaction(string);
        }
        return this.beginTransaction(string + " -- Apply to: " + string2);
    }

    @Override
    public synchronized boolean commitTransaction() {
        return this.getHeadFrameStore().commitTransaction();
    }

    @Override
    public synchronized boolean rollbackTransaction() {
        return this.getHeadFrameStore().rollbackTransaction();
    }

    @Override
    @Deprecated
    public synchronized boolean endTransaction(boolean bl) {
        boolean bl2 = bl ? this.commitTransaction() : !this.rollbackTransaction();
        return bl2;
    }

    @Override
    @Deprecated
    public synchronized boolean endTransaction() {
        return this.commitTransaction();
    }

    @Override
    public synchronized void setFrameFactory(FrameFactory frameFactory) {
        this._frameFactory = frameFactory;
    }

    @Override
    public CommandManager getCommandManager() {
        return this.getUndoFrameStore();
    }

    @Override
    public synchronized void setFrameNameValidator(FrameNameValidator frameNameValidator) {
        this._frameNameValidator = frameNameValidator;
    }

    @Override
    public synchronized boolean isValidFrameName(String string, Frame frame) {
        return this._frameNameValidator == null ? true : this._frameNameValidator.isValid(string, frame);
    }

    @Override
    public synchronized String getInvalidFrameNameDescription(String string, Frame frame) {
        String string2 = null;
        if (this._frameNameValidator != null) {
            string2 = this._frameNameValidator.getErrorMessage(string, frame);
        }
        return string2;
    }

    @Override
    public synchronized void setPollForEvents(boolean bl) {
        this._frameStoreManager.setPollForEvents(bl);
    }

    @Override
    @Deprecated
    public synchronized void setDirectBrowserSlot(Cls cls, Slot slot) {
        this.setDirectBrowserSlotPattern(cls, new BrowserSlotPattern(slot));
    }

    @Override
    public synchronized void setDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, browserSlotPattern);
        this._frameStoreManager.notifyInstancesOfBrowserTextChange(cls);
    }

    @Override
    public synchronized void removeFrameStore(FrameStore frameStore) {
        this._frameStoreManager.removeFrameStore(frameStore);
    }

    @Override
    public synchronized void insertFrameStore(FrameStore frameStore) {
        this._frameStoreManager.insertFrameStore(frameStore);
    }

    @Override
    public synchronized void insertFrameStore(FrameStore frameStore, int n) {
        this._frameStoreManager.insertFrameStore(frameStore, n);
    }

    @Override
    public synchronized List<FrameStore> getFrameStores() {
        return this._frameStoreManager.getFrameStores();
    }

    public synchronized void setTerminalFrameStore(FrameStore frameStore) {
        this._frameStoreManager.setTerminalFrameStore(frameStore);
    }

    public synchronized FrameStore getTerminalFrameStore() {
        return this._frameStoreManager.getTerminalFrameStore();
    }

    @Override
    public synchronized void clearAllListeners() {
        this._frameStoreManager.clearAllListeners();
    }

    @Override
    public synchronized FrameCounts getFrameCounts() {
        return this.getProject().getFrameCounts();
    }

    @Override
    public BrowserSlotPattern getDirectBrowserSlotPattern(Cls cls) {
        return this.getProject().getDirectBrowserSlotPattern(cls);
    }

    public void setDirectBrowserTextPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, browserSlotPattern);
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesClosure(frame, slot);
    }

    @Override
    @Deprecated
    public boolean getValueChecking() {
        return this.getFacetCheckingEnabled();
    }

    public synchronized boolean getFacetCheckingEnabled() {
        return this._frameStoreManager.getFacetCheckingEnabled();
    }

    @Override
    public void startJournaling(URI uRI) {
        this._frameStoreManager.startJournaling(uRI);
    }

    @Override
    public void stopJournaling() {
        this._frameStoreManager.stopJournaling();
    }

    @Override
    public synchronized boolean setGenerateDeletingFrameEventsEnabled(boolean bl) {
        return this._frameStoreManager.setGenerateDeletingFrameEventsEnabled(bl);
    }

    @Override
    public synchronized void flushCache() {
        this.getFrameStoreManager().reinitialize();
    }

    @Override
    public synchronized Cls getReifiedRelationCls() {
        return this._systemFrames.getRelationCls();
    }

    @Override
    public synchronized Slot getReifedRelationFromSlot() {
        return this._systemFrames.getFromSlot();
    }

    @Override
    public synchronized Slot getReifedRelationToSlot() {
        return this._systemFrames.getToSlot();
    }

    @Override
    public synchronized void addTransactionListener(TransactionListener transactionListener) {
        this.addListener(TransactionListener.class, this, transactionListener);
    }

    @Override
    public synchronized void removeTransactionListener(TransactionListener transactionListener) {
        this.removeListener(TransactionListener.class, this, transactionListener);
    }

    @Override
    public Collection<Frame> executeQuery(Query query) {
        SynchronizeQueryCallback synchronizeQueryCallback = new SynchronizeQueryCallback(this);
        this.getHeadFrameStore().executeQuery(query, synchronizeQueryCallback);
        return synchronizeQueryCallback.waitForResults();
    }

    public ServerCacheStateMachine getCacheMachine() {
        return this.cacheMachine;
    }

    public void setCacheMachine(ServerCacheStateMachine serverCacheStateMachine) {
        this.cacheMachine = serverCacheStateMachine;
    }

    @Override
    public Frame rename(Frame frame, String string) {
        FrameFactory frameFactory = this.getFrameFactory();
        return frameFactory.rename(frame, string);
    }

    @Override
    public void assertFrameName(Frame frame) {
        this.setDirectOwnSlotValue(frame, this._systemFrames.getNameSlot(), frame.getName());
    }
}

