/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerActivityFrameStore
extends AbstractFrameStoreInvocationHandler {
    private static transient Logger log = Log.getLogger(ServerActivityFrameStore.class);
    private boolean serverActive = false;
    private KnowledgeBase kb;
    private FrameCalculator frameCalculator;

    public ServerActivityFrameStore(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    private FrameCalculator getFrameCalculator() {
        if (this.frameCalculator == null) {
            ServerProject serverProject = Server.getInstance().getServerProject(this.kb.getProject());
            if (serverProject == null) {
                return null;
            }
            ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(null);
            this.frameCalculator = serverFrameStore.getFrameCalculator();
        }
        return this.frameCalculator;
    }

    public void clearServerActivity() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("server activity reset");
        }
        this.serverActive = false;
    }

    public boolean serverInvoked() {
        return this.serverActive;
    }

    protected void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }

    protected Object handleInvoke(Method method, Object[] objectArray) {
        if (!(method.getName().equals("getEvents") || this.getFrameCalculator() != null && this.getFrameCalculator().inFrameCalculatorThread())) {
            if (log.isLoggable(Level.FINE) && !this.serverActive) {
                log.fine("Server is receiving incoming call " + method);
                log.fine("recorded as server activity");
            }
            this.serverActive = true;
        }
        return this.invoke(method, objectArray);
    }
}

