/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.event;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.TransactionAdapter;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collections;

public class TransactionListener_Test
extends APITestCase {
    private static final String TEST_STRING = "test transaction";

    public void testTransactionBegin() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        knowledgeBase.addTransactionListener(new TransactionAdapter(){

            public void transactionBegin(TransactionEvent transactionEvent) {
                TransactionListener_Test.this.recordEventFired(transactionEvent);
            }
        });
        knowledgeBase.beginTransaction(TEST_STRING);
        this.assertEventFired(701);
    }

    public void testTransactionEnd() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        knowledgeBase.addTransactionListener(new TransactionAdapter(){

            public void transactionEnded(TransactionEvent transactionEvent) {
                TransactionListener_Test.this.recordEventFired(transactionEvent);
            }
        });
        knowledgeBase.beginTransaction(TEST_STRING);
        knowledgeBase.endTransaction(true);
        this.assertEventFired(702);
    }

    public void testNestedTransactionsHidden() {
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            TransactionIsolationLevel transactionIsolationLevel;
            TransactionListener_Test.setDBType(dBType);
            if (!TransactionListener_Test.dbConfigured()) continue;
            TransactionListener_Test.setDatabaseProject();
            KnowledgeBase knowledgeBase = this.getDomainKB();
            Cls cls = knowledgeBase.getSystemFrames().getRootCls();
            TransactionMonitor transactionMonitor = knowledgeBase.getFrameStoreManager().getHeadFrameStore().getTransactionStatusMonitor();
            TransactionIsolationLevel transactionIsolationLevel2 = transactionIsolationLevel = transactionMonitor == null ? TransactionIsolationLevel.NONE : transactionMonitor.getTransationIsolationLevel();
            if (transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) < 0) continue;
            this.clearEvents();
            knowledgeBase.addTransactionListener(new TransactionAdapter(){

                public void transactionBegin(TransactionEvent transactionEvent) {
                    TransactionListener_Test.this.recordEventFired(transactionEvent);
                }
            });
            knowledgeBase.addKnowledgeBaseListener(new KnowledgeBaseAdapter(){

                public void clsCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                    TransactionListener_Test.this.recordEventFired(knowledgeBaseEvent);
                }

                public void slotCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
                    TransactionListener_Test.this.recordEventFired(knowledgeBaseEvent);
                }
            });
            knowledgeBase.beginTransaction("Starting outer transaction");
            knowledgeBase.createCls("A", Collections.singleton(cls));
            this.assertEventFired(701);
            assert (this.getEventFired(601) == null);
            knowledgeBase.beginTransaction("Starting inner transaction");
            knowledgeBase.createSlot("f");
            assert (this.getEventFired(603) == null);
            knowledgeBase.commitTransaction();
            assert (this.getEventFired(603) == null);
            assert (this.getEventFired(601) == null);
            knowledgeBase.commitTransaction();
            this.assertEventFired(601);
            this.assertEventFired(603);
        }
    }
}

