/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentCheckingFrameStore
extends AbstractFrameStore {
    private static void assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null " + string);
        }
    }

    private static void fail(String string) {
        throw new IllegalArgumentException(string);
    }

    private static void checkFrame(Frame frame) {
        ArgumentCheckingFrameStore.assertNotNull("frame", frame);
    }

    private static void checkCls(Cls cls) {
        ArgumentCheckingFrameStore.assertNotNull("class", cls);
    }

    private static void checkSlot(Slot slot) {
        ArgumentCheckingFrameStore.assertNotNull("slot", slot);
    }

    private static void checkFacet(Facet facet) {
        ArgumentCheckingFrameStore.assertNotNull("facet", facet);
    }

    private static void checkInstance(Instance instance) {
        ArgumentCheckingFrameStore.assertNotNull("instance", instance);
    }

    private static void checkString(String string) {
        ArgumentCheckingFrameStore.assertNotNull("string", string);
    }

    private static void checkSimpleInstance(SimpleInstance simpleInstance) {
        ArgumentCheckingFrameStore.assertNotNull("simple instance", simpleInstance);
    }

    private static void checkClses(Collection collection) {
        for (Object e : collection) {
            if (e instanceof Cls) continue;
            ArgumentCheckingFrameStore.fail("not a class: " + e);
        }
    }

    private static void checkSlots(Collection collection) {
        for (Object e : collection) {
            if (e instanceof Slot) continue;
            ArgumentCheckingFrameStore.fail("not a slot: " + e);
        }
    }

    private static void checkValue(Object object) {
        ArgumentCheckingFrameStore.assertNotNull("value", object);
        if (!ArgumentCheckingFrameStore.isValidType(object)) {
            ArgumentCheckingFrameStore.fail("invalid type: " + object);
        }
    }

    private static boolean isValidType(Object object) {
        return object instanceof String || object instanceof Frame || object instanceof Boolean || object instanceof Integer || object instanceof Float;
    }

    private static void checkValues(Collection collection) {
        for (Object e : collection) {
            ArgumentCheckingFrameStore.checkValue(e);
        }
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this.getDelegate().getFrame(frameID);
    }

    @Override
    public Frame getFrame(String string) {
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().getFrame(string);
    }

    @Override
    public String getFrameName(Frame frame) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        return this.getDelegate().getFrameName(frame);
    }

    @Override
    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        ArgumentCheckingFrameStore.checkClses(collection);
        ArgumentCheckingFrameStore.checkClses(collection2);
        return this.getDelegate().createCls(frameID, collection, collection2, bl);
    }

    @Override
    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        ArgumentCheckingFrameStore.checkClses(collection);
        ArgumentCheckingFrameStore.checkSlots(collection2);
        return this.getDelegate().createSlot(frameID, collection, collection2, bl);
    }

    @Override
    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        ArgumentCheckingFrameStore.checkClses(collection);
        return this.getDelegate().createFacet(frameID, collection, bl);
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        ArgumentCheckingFrameStore.checkClses(collection);
        return this.getDelegate().createSimpleInstance(frameID, collection, bl);
    }

    @Override
    public void deleteCls(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        this.getDelegate().deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        ArgumentCheckingFrameStore.checkFacet(facet);
        this.getDelegate().deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        ArgumentCheckingFrameStore.checkSimpleInstance(simpleInstance);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    @Override
    public Set<Slot> getOwnSlots(Frame frame) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        return this.getDelegate().getOwnSlots(frame);
    }

    @Override
    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOwnSlotValues(frame, slot);
    }

    @Override
    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValues(frame, slot);
    }

    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValues(collection);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
    }

    @Override
    public Set getOwnFacets(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOwnFacets(frame, slot);
    }

    @Override
    public Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getOwnFacetValues(frame, slot, facet);
    }

    @Override
    public Set getTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getTemplateSlots(cls);
    }

    @Override
    public List getDirectTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectTemplateSlots(cls);
    }

    @Override
    public List getDirectDomain(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectDomain(slot);
    }

    @Override
    public Set getDomain(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDomain(slot);
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getOverriddenTemplateSlots(cls);
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().addDirectTemplateSlot(cls, slot);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
    }

    @Override
    public Collection getTemplateSlotValues(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getTemplateSlotValues(cls, slot);
    }

    @Override
    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectTemplateSlotValues(cls, slot);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValues(collection);
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getTemplateFacets(cls, slot);
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectlyOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
    }

    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkValues(collection);
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    @Override
    public List<Cls> getDirectSuperclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectSuperclasses(cls);
    }

    @Override
    public Set getSuperclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getSuperclasses(cls);
    }

    @Override
    public List<Cls> getDirectSubclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectSubclasses(cls);
    }

    @Override
    public Set<Cls> getSubclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getSubclasses(cls);
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(cls2);
        this.getDelegate().addDirectSuperclass(cls, cls2);
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(cls2);
        this.getDelegate().removeDirectSuperclass(cls, cls2);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(cls2);
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
    }

    @Override
    public List getDirectSuperslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectSuperslots(slot);
    }

    @Override
    public Set getSuperslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getSuperslots(slot);
    }

    @Override
    public List getDirectSubslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectSubslots(slot);
    }

    @Override
    public Set getSubslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getSubslots(slot);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(slot2);
        this.getDelegate().addDirectSuperslot(slot, slot2);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(slot2);
        this.getDelegate().removeDirectSuperslot(slot, slot2);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(slot2);
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
    }

    @Override
    public List getDirectTypes(Instance instance) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        return this.getDelegate().getDirectTypes(instance);
    }

    @Override
    public Set getTypes(Instance instance) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        return this.getDelegate().getTypes(instance);
    }

    @Override
    public List<Instance> getDirectInstances(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectInstances(cls);
    }

    @Override
    public Set<Instance> getInstances(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getInstances(cls);
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(cls);
        this.getDelegate().addDirectType(instance, cls);
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(cls);
        this.getDelegate().removeDirectType(instance, cls);
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(cls);
        this.getDelegate().moveDirectType(instance, cls, n);
    }

    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        ArgumentCheckingFrameStore.checkValue(object);
        return this.getDelegate().getReferences(object);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().getMatchingReferences(string, n);
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        ArgumentCheckingFrameStore.checkString(string);
        ArgumentCheckingFrameStore.checkClses(collection);
        return this.getDelegate().getClsesWithMatchingBrowserText(string, collection, n);
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(object);
        return this.getDelegate().getFramesWithDirectOwnSlotValue(slot, object);
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(string);
        return this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(object);
        return this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, object);
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n);
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkValue(object);
        return this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
    }

    @Override
    public Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
    }

    @Override
    public boolean beginTransaction(String string) {
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    @Override
    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    @Override
    public Set<Cls> getClses() {
        return this.getDelegate().getClses();
    }

    @Override
    public Set<Slot> getSlots() {
        return this.getDelegate().getSlots();
    }

    @Override
    public Set<Facet> getFacets() {
        return this.getDelegate().getFacets();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.getDelegate().getFrames();
    }

    @Override
    public List<AbstractEvent> getEvents() {
        return this.getDelegate().getEvents();
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkFrame(frame2);
        this.getDelegate().replaceFrame(frame, frame2);
    }
}

