/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.RegisterUserServerPanel;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerPanel
extends JPanel
implements Validatable {
    private static final long serialVersionUID = 4729412021203886589L;
    private static final transient Logger log = Log.getLogger(ServerPanel.class);
    private static String _lastPassword = null;
    private JTextField _usernameField = ComponentFactory.createTextField();
    private JTextField _passwordField;
    private JTextField _hostNameField;
    private JComponent _registerUserPanel;
    private JCheckBox _administerServerChekBox;
    private RemoteServer _server;
    private RemoteSession _session;
    private static final String USER_NAME = ServerPanel.class.getName() + ".user_name";
    private static final String HOST_NAME = ServerPanel.class.getName() + ".host_name";

    public ServerPanel() {
        this._usernameField.setText(ApplicationProperties.getString(USER_NAME, "Guest"));
        this._passwordField = ComponentFactory.createPasswordField();
        if (_lastPassword != null) {
            this._passwordField.setText(_lastPassword);
        } else if (this._usernameField.getText().equals("Guest")) {
            this._passwordField.setText("guest");
        }
        this._hostNameField = ComponentFactory.createTextField();
        this._hostNameField.setText(ApplicationProperties.getString(HOST_NAME, "localhost"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(5, 0));
        jPanel.add(new LabeledComponent("Host Machine Name", this._hostNameField));
        jPanel.add(new LabeledComponent("User Name", this._usernameField));
        jPanel.add(new LabeledComponent("Password", this._passwordField));
        this._registerUserPanel = this.getRegisterUserPanel();
        jPanel.add(this._registerUserPanel);
        this._administerServerChekBox = ComponentFactory.createCheckBox("Administer server (requires privileges)");
        this._administerServerChekBox.setSelected(false);
        jPanel.add(this._administerServerChekBox);
        this.add((Component)jPanel, "North");
    }

    public boolean validateContents() {
        boolean bl = false;
        try {
            bl = this.isValidConfiguration();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Could not log in", exception);
        }
        return bl;
    }

    private boolean isValidConfiguration() {
        boolean bl = false;
        String string = this._hostNameField.getText();
        this._server = this.connectToHost(string);
        if (this._server != null) {
            String string2 = this._usernameField.getText();
            String string3 = this._passwordField.getText();
            this._session = this.createSession(string2, string3);
            bl = this._session != null;
        }
        this.saveFields();
        return bl;
    }

    public void saveContents() {
    }

    private void saveFields() {
        ApplicationProperties.setString(USER_NAME, this._usernameField.getText());
        ApplicationProperties.setString(HOST_NAME, this._hostNameField.getText());
        _lastPassword = this._passwordField.getText();
    }

    public RemoteServer getServer() {
        return this._server;
    }

    public RemoteSession getSession() {
        return this._session;
    }

    public boolean isAdminsterServerActivated() {
        return this._administerServerChekBox.isSelected();
    }

    private RemoteServer connectToHost(String string) {
        RemoteServer remoteServer = null;
        try {
            if (SSLFactory.useSSL(SSLFactory.Context.LOGIN)) {
                SSLFactory.resetAuth();
            }
            remoteServer = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            if (SSLFactory.useSSL(SSLFactory.Context.LOGIN) && !SSLFactory.checkAuth()) {
                log.severe("Requested ssl security but server is not secured.");
                return null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.log("Trying to connect to an unknown host: " + string, unknownHostException);
            ModalDialog.showMessageDialog(this, "You are trying to connect to an unknown host: " + string + "\n\n" + "A possible cause of this error is that the specified hostname and port are not correct.", "Unkown host", 14);
        }
        catch (ConnectException connectException) {
            this.log("Cannot connect to: " + string + ". " + connectException.getMessage(), connectException);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + string + "\n\n" + "Possible causes of this error are firewall or network configuration problems.\n" + "Please check also that the hostname and port are correct.", "Unable to connect", 14);
        }
        catch (ConnectIOException connectIOException) {
            this.log("Cannot connect to: " + string + ". " + connectIOException.getMessage(), connectIOException);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + string + "\n\n" + "Possible causes of this error are firewall or network configuration problems.\n" + "Please check also that the hostname and port are correct.", "IO connection error", 14);
        }
        catch (UnmarshalException unmarshalException) {
            this.log("Unmarshalling exception. Possibly, the server and client use different versions of Protege " + unmarshalException.getMessage(), unmarshalException);
            ModalDialog.showMessageDialog(this, "There was a connection problem to: " + string + "\n\n" + "Most likely cause is that the server and client are running different versions of Protege.", "Unmarshalling exception", 14);
        }
        catch (NotBoundException notBoundException) {
            this.log("Not bound exception: " + string + ". " + notBoundException.getMessage() + " Is the Protege server started?", notBoundException);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + string + "\n\n" + "Most likely cause of this problem is that the Protege server is not running.\n" + "Please check also that the hostname and port are correct.\n" + "This error can also be caused by firewall or network problems.", "Not bound exception", 14);
        }
        catch (Exception exception) {
            this.log("Error at connecting to: " + string + ". " + exception.getMessage(), exception);
            ModalDialog.showMessageDialog(this, "An error occured at connecting to: " + string + "\n\n" + "See console for more details.", "Error at connect", 14);
        }
        return remoteServer;
    }

    private RemoteSession createSession(String string, String string2) {
        try {
            this.getAllowsUserCreate(this._server);
        }
        catch (Exception exception) {
            this.log("Firewall or network problems when connecting to the server. " + exception.getMessage() + " Server ref: " + this._server, exception);
            ModalDialog.showMessageDialog(this, "Cannot connect to server.\nPossible causes of this error are firewall or network configuration problems.\n", "Unable to connect", 14);
            return null;
        }
        RemoteSession remoteSession = null;
        try {
            remoteSession = this._server.openSession(string, SystemUtilities.getMachineIpAddress(), string2);
            if (remoteSession == null) {
                this.log("Invalid login for " + string, null);
                ModalDialog.showMessageDialog((Component)this, "Invalid username and password. Please try again.", "Login failed");
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.log("Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nMost probable cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server.\nServer reference: " + this._server, unknownHostException);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nMost probable cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server.\nServer reference: " + this._server, "Unkown host", 14);
        }
        catch (ConnectException connectException) {
            this.log("Connection to RMI registry successful, but cannot connect to the server.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, connectException);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, "Unkown host", 14);
        }
        catch (ConnectIOException connectIOException) {
            this.log("Connection to RMI registry successful, but cannot connect to the server.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, connectIOException);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, "Unkown host", 14);
        }
        catch (UnmarshalException unmarshalException) {
            this.log("Connection to RMI registry successful, but there was an unmarshalling exception connecting to the server.\nPossibly, the server and client use different versions of Protege." + unmarshalException.getMessage(), unmarshalException);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but there was an unmarshalling exception connecting to the server.\nPossibly, the server and client use different versions of Protege.", "Unmarshalling exception", 14);
        }
        catch (RemoteException remoteException) {
            log.log(Level.WARNING, "Connection to RMI registry successful, but at error at creating session for " + string + " Server ref: " + this._server, remoteException);
            ModalDialog.showMessageDialog((Component)this, "There was an error at checking the login credentails.", "Error at login");
        }
        return remoteSession;
    }

    private JComponent getRegisterUserPanel() {
        AllowableAction allowableAction = this.createRegisterUserAction();
        JButton jButton = ComponentFactory.createButton(allowableAction);
        jButton.setText("New user");
        jButton.setToolTipText("Register new user (Checks first if server allows the creation of new users)");
        LabeledComponent labeledComponent = new LabeledComponent("", null);
        labeledComponent.add((Component)jButton, "East");
        return labeledComponent;
    }

    private AllowableAction createRegisterUserAction() {
        AllowableAction allowableAction = new AllowableAction(new ResourceKey("Create new user")){
            private static final long serialVersionUID = -5124239014343816470L;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ServerPanel.this._hostNameField.getText();
                if (ServerPanel.this._hostNameField == null || string.length() == 0) {
                    ModalDialog.showMessageDialog((Component)ServerPanel.this, "Server host name is empty. Please set first the server host name before registering.", "Error: Empty Server Name");
                    return;
                }
                if (!ServerPanel.this.serverAllowsUserCreate(string)) {
                    return;
                }
                try {
                    ServerPanel.this._server = ServerPanel.this.connectToHost(string);
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Error at connecting to host " + string, exception);
                    ModalDialog.showMessageDialog((Component)ServerPanel.this, "Cannot connect to server: " + string + "\nPlease check that the server name is correct." + "\nThis error may also indicate firewall problems.", "Error: Connect to server");
                    return;
                }
                RegisterUserServerPanel registerUserServerPanel = new RegisterUserServerPanel(string);
                int n = ModalDialog.showDialog(ServerPanel.this, registerUserServerPanel, "Register new user", 11);
                if (n == 1) {
                    ServerPanel.this._usernameField.setText(registerUserServerPanel.getUsername());
                    ServerPanel.this._passwordField.setText(registerUserServerPanel.getPassword());
                }
            }
        };
        return allowableAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serverAllowsUserCreate(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        RemoteServer remoteServer = this.connectToHost(string);
        if (remoteServer == null) {
            return false;
        }
        try {
            boolean bl = this.getAllowsUserCreate(remoteServer);
            if (!bl) {
                this.setCursor(Cursor.getDefaultCursor());
                ModalDialog.showMessageDialog((Component)this, "Server " + string + " does not allow the creation of new users.\n", "Warning");
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.log("There was an error at querying the server whether it allows the creation of new users", exception);
            this.setCursor(Cursor.getDefaultCursor());
            ModalDialog.showMessageDialog((Component)this, "There was an error at querying the server whether it allows the creation of users", "Warning");
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean getAllowsUserCreate(RemoteServer remoteServer) throws RemoteException {
        boolean bl = false;
        try {
            bl = remoteServer.allowsCreateUsers();
        }
        catch (RemoteException remoteException) {
            this.log("Error at pinging server", remoteException);
            throw remoteException;
        }
        return bl;
    }

    private void log(String string, Exception exception) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, string, exception);
        }
        log.warning(string);
    }
}

