/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.socket.SimulateDelayInputStream;
import edu.stanford.smi.protege.server.socket.SimulateDelayOutputStream;
import edu.stanford.smi.protege.server.socket.SocketAspect;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimulateDelayAspect
implements SocketAspect {
    private static int nDelayedCalls = 0;
    private SocketAspect delegate;
    private InputStream is;
    private OutputStream os;
    private boolean delaysReported = false;

    public static void delayForLatency() {
        if (ServerProperties.delayInMilliseconds() != 0) {
            SystemUtilities.sleepMsec(ServerProperties.delayInMilliseconds());
            if (++nDelayedCalls % 10 == 0) {
                Log.getLogger().info(nDelayedCalls + " delayed calls");
            }
        }
    }

    public SimulateDelayAspect(SocketAspect socketAspect) {
        this.delegate = socketAspect;
        this.reportDelays();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public SocketAspect getDelegate() {
        return this.delegate;
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new SimulateDelayInputStream(this.delegate.getInputStream());
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new SimulateDelayOutputStream(this.delegate.getOutputStream());
        }
        return this.os;
    }

    public static boolean useSimulatedDelay() {
        return ServerProperties.getKiloBytesPerSecondDownload() != 0 || ServerProperties.getKiloBytesPerSecondUpload() != 0;
    }

    public void reportDelays() {
        if (!(this.delaysReported || ServerProperties.getKiloBytesPerSecondDownload() == 0 && ServerProperties.getKiloBytesPerSecondUpload() == 0 && ServerProperties.delayInMilliseconds() == 0)) {
            StringBuffer stringBuffer = new StringBuffer("Simulated Delays: ");
            stringBuffer.append(ServerProperties.getKiloBytesPerSecondDownload());
            stringBuffer.append(" KByte/sec download, ");
            stringBuffer.append(ServerProperties.getKiloBytesPerSecondUpload());
            stringBuffer.append(" KByte/sec upload, ");
            stringBuffer.append(ServerProperties.delayInMilliseconds());
            stringBuffer.append(" milliseconds latency");
            Log.getLogger().config(stringBuffer.toString());
            this.delaysReported = true;
        }
    }
}

