/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.storage.database.AbstractDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdleConnectionNarrowFrameStore
implements NarrowFrameStore {
    private static Logger logger = Log.getLogger(IdleConnectionNarrowFrameStore.class);
    private final NarrowFrameStore delegate;
    private final AbstractDatabaseFrameDb databaseNfs;

    public IdleConnectionNarrowFrameStore(ValueCachingNarrowFrameStore valueCachingNarrowFrameStore) {
        this.delegate = valueCachingNarrowFrameStore;
        this.databaseNfs = (AbstractDatabaseFrameDb)valueCachingNarrowFrameStore.getFrameDb();
    }

    private void setIdle() {
        try {
            this.databaseNfs.getCurrentConnection().setIdle(true);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        try {
            this.delegate.addValues(frame, slot, facet, bl, collection);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginTransaction(String string) {
        try {
            boolean bl = this.delegate.beginTransaction(string);
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction() {
        try {
            boolean bl = this.delegate.commitTransaction();
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFrame(Frame frame) {
        try {
            this.delegate.deleteFrame(frame);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        try {
            this.delegate.executeQuery(query, queryCallback);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        try {
            Set set = this.delegate.getClosure(frame, slot, facet, bl);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClsCount() {
        try {
            int n = this.delegate.getClsCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFacetCount() {
        try {
            int n = this.delegate.getFacetCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID frameID) {
        try {
            Frame frame = this.delegate.getFrame(frameID);
            return frame;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameCount() {
        try {
            int n = this.delegate.getFrameCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames() {
        try {
            Set<Frame> set = this.delegate.getFrames();
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        try {
            Set<Frame> set = this.delegate.getFrames(slot, facet, bl, object);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        try {
            Set<Frame> set = this.delegate.getFramesWithAnyValue(slot, facet, bl);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        try {
            Set<Frame> set = this.delegate.getMatchingFrames(slot, facet, bl, string, n);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        try {
            Set<Reference> set = this.delegate.getMatchingReferences(string, n);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        try {
            String string = this.delegate.getName();
            return string;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getReferences(Object object) {
        try {
            Set<Reference> set = this.delegate.getReferences(object);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSimpleInstanceCount() {
        try {
            int n = this.delegate.getSimpleInstanceCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSlotCount() {
        try {
            int n = this.delegate.getSlotCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        try {
            TransactionMonitor transactionMonitor = this.delegate.getTransactionStatusMonitor();
            return transactionMonitor;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        try {
            List list = this.delegate.getValues(frame, slot, facet, bl);
            return list;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        try {
            int n = this.delegate.getValuesCount(frame, slot, facet, bl);
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        try {
            this.delegate.moveValue(frame, slot, facet, bl, n, n2);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize() {
        try {
            this.delegate.reinitialize();
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        return this.delegate.setCaching(remoteSession, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        try {
            this.delegate.removeValue(frame, slot, facet, bl, object);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame frame) {
        try {
            this.delegate.replaceFrame(frame);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        try {
            this.delegate.replaceFrame(frame, frame2);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollbackTransaction() {
        try {
            boolean bl = this.delegate.rollbackTransaction();
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public void setName(String string) {
        this.delegate.setName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        try {
            this.delegate.setValues(frame, slot, facet, bl, collection);
        }
        finally {
            this.setIdle();
        }
    }
}

