/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.update.DeferredOperationCache;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheFactory;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.impl.CompleteableCache;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCachingNarrowFrameStore
implements NarrowFrameStore {
    public static final transient Logger CACHE_LOG = Logger.getLogger(CompleteableCache.class.getPackage().getName() + ".ValueCachingNFS");
    public static final Logger LOGGER = Log.getLogger(ValueCachingNarrowFrameStore.class);
    private DatabaseFrameDb framedb;
    private final WeakHashMap<String, SoftReference<DeferredOperationCache>> cacheMap = new WeakHashMap();
    private Sft directInstancesSft;
    private FifoWriter<SerializedCacheUpdate<RemoteSession, Sft, List>> transactions = new FifoWriter();
    private Set<RemoteSession> unCachingSessions;
    private long totalBuildTime = 0L;
    private long cacheBuilds = 0L;
    private long cacheLost = 0L;
    private long cacheHits = 0L;

    public ValueCachingNarrowFrameStore(DatabaseFrameDb databaseFrameDb) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Constructing ValueCachingNarrowFrameStore with delegate " + databaseFrameDb);
        }
        this.framedb = databaseFrameDb;
    }

    @Override
    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        boolean bl2;
        if (this.unCachingSessions == null) {
            this.unCachingSessions = new HashSet<RemoteSession>();
        }
        boolean bl3 = bl2 = !this.unCachingSessions.contains(remoteSession);
        if (bl) {
            this.unCachingSessions.remove(remoteSession);
        } else {
            this.unCachingSessions.add(remoteSession);
        }
        return bl2;
    }

    private boolean cachingDisabledForSession() {
        return this.unCachingSessions != null && this.unCachingSessions.contains(ServerFrameStore.getCurrentSession());
    }

    public void setFrameDb(DatabaseFrameDb databaseFrameDb) {
        this.framedb = databaseFrameDb;
    }

    public DatabaseFrameDb getFrameDb() {
        return this.framedb;
    }

    @Override
    public DatabaseFrameDb getDelegate() {
        return this.framedb;
    }

    private DeferredOperationCache getCache(Frame frame, boolean bl) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        SoftReference<DeferredOperationCache> softReference = this.cacheMap.get(frame.getFrameID().getName());
        DeferredOperationCache deferredOperationCache = null;
        if (softReference != null) {
            deferredOperationCache = softReference.get();
        }
        if (deferredOperationCache != null && deferredOperationCache.isInvalid()) {
            deferredOperationCache = null;
            this.cacheMap.remove(frame.getFrameID().getName());
        }
        if (softReference != null && deferredOperationCache == null) {
            if (CACHE_LOG.isLoggable(Level.FINER)) {
                CACHE_LOG.finer("Cache for frame " + frame.getFrameID().getName() + " garbage collected");
            }
            ++this.cacheLost;
        }
        if (deferredOperationCache == null && bl) {
            String string = frame.getFrameID().getName();
            Cache<RemoteSession, Sft, List> cache = CacheFactory.createEmptyCache(this.getTransactionStatusMonitor().getTransationIsolationLevel());
            deferredOperationCache = new DeferredOperationCache(cache, new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(this.transactions));
            if (CACHE_LOG.isLoggable(Level.FINER)) {
                CACHE_LOG.finer("Created cache " + deferredOperationCache.getCacheId() + " for frame " + frame.getFrameID().getName());
            }
            this.cacheMap.put(string, new SoftReference<DeferredOperationCache>(deferredOperationCache));
            if (!this.cachingDisabledForSession()) {
                if (this.directInstancesSft == null && frame.getKnowledgeBase() != null) {
                    SystemFrames systemFrames = frame.getKnowledgeBase().getSystemFrames();
                    Slot slot = systemFrames.getDirectInstancesSlot();
                    this.directInstancesSft = new Sft(slot, null, false);
                }
                if (!this.getTransactionStatusMonitor().inTransaction() && this.directInstancesSft != null) {
                    long l = System.nanoTime();
                    Map<Sft, List> map = this.framedb.getFrameValues(frame);
                    deferredOperationCache.startCompleteCache();
                    deferredOperationCache.updateCache(remoteSession, this.directInstancesSft);
                    for (Map.Entry<Sft, List> entry : map.entrySet()) {
                        deferredOperationCache.updateCache(remoteSession, entry.getKey(), entry.getValue());
                    }
                    deferredOperationCache.finishCompleteCache();
                    this.totalBuildTime += System.nanoTime() - l;
                }
                ++this.cacheBuilds;
                this.logStats(Level.FINE);
                if (CACHE_LOG.isLoggable(Level.FINER)) {
                    CACHE_LOG.finer("Filled cache " + deferredOperationCache.getCacheId() + " for frame " + frame.getFrameID().getName());
                }
            }
        }
        return deferredOperationCache;
    }

    private void logStats(Level level) {
        if (CACHE_LOG.isLoggable(level) && this.cacheBuilds % 300L == 0L) {
            CACHE_LOG.log(level, "------------------- Database ValueCaching Stats");
            CACHE_LOG.log(level, "Caches built = " + this.cacheBuilds + " but only " + this.cacheMap.size() + " cache references still present.");
            CACHE_LOG.log(level, "Cache references found but were invalid at time of use = " + this.cacheLost);
            CACHE_LOG.log(level, "Ave time per build = " + (float)this.totalBuildTime / (float)(1000000L * this.cacheBuilds) + "ms.");
            CACHE_LOG.log(level, "Ave hits per build = " + this.cacheHits / this.cacheBuilds);
            CACHE_LOG.log(level, "------------------- Database ValueCaching Stats");
        }
    }

    private List getValues(CacheResult<List> cacheResult) {
        ArrayList arrayList = cacheResult.getResult();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public String toString() {
        return "ValueCachingFrameStore(" + this.getName() + ")";
    }

    public void debugOutOfMemory() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(8);
        try {
            while (true) {
                arrayList.addAll(arrayList);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOGGER.info("Out of memory achieved");
            return;
        }
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this.getDelegate().addValues(frame, slot, facet, bl, collection);
        DeferredOperationCache deferredOperationCache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (deferredOperationCache != null) {
            Sft sft;
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            CacheResult<List> cacheResult = deferredOperationCache.readCache(remoteSession, sft = new Sft(slot, facet, bl));
            if (cacheResult.isValid()) {
                ArrayList arrayList = new ArrayList(this.getValues(cacheResult));
                arrayList.addAll(collection);
                deferredOperationCache.modifyCache(remoteSession, sft, arrayList);
            } else {
                deferredOperationCache.modifyCache(remoteSession, sft);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginTransaction(String string) {
        try {
            boolean bl = this.getDelegate().beginTransaction(string);
            return bl;
        }
        finally {
            this.transactions.write(new CacheBeginTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction() {
        try {
            boolean bl = this.getDelegate().commitTransaction();
            return bl;
        }
        finally {
            this.transactions.write(new CacheCommitTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollbackTransaction() {
        try {
            boolean bl = this.getDelegate().rollbackTransaction();
            return bl;
        }
        finally {
            this.transactions.write(new CacheRollbackTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    @Override
    public void close() {
        this.framedb.close();
        this.framedb = null;
        this.cacheMap.clear();
        this.directInstancesSft = null;
        this.transactions = null;
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.removeFrameReferences(frame);
        this.getDelegate().deleteFrame(frame);
    }

    private void removeFrameReferences(Frame frame) {
        if (frame instanceof Slot || frame instanceof Facet) {
            this.cacheMap.clear();
        } else {
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            DeferredOperationCache deferredOperationCache = this.getCache(frame, false);
            if (deferredOperationCache != null) {
                deferredOperationCache.invalidate(remoteSession);
            }
            for (Reference reference : this.framedb.getReferences(frame)) {
                deferredOperationCache = this.getCache(reference.getFrame(), false);
                if (deferredOperationCache == null) continue;
                deferredOperationCache.invalidate(remoteSession);
            }
        }
    }

    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        this.getDelegate().executeQuery(query, queryCallback);
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.getDelegate().getClosure(frame, slot, facet, bl);
    }

    @Override
    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    @Override
    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this.getDelegate().getFrame(frameID);
    }

    @Override
    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.getDelegate().getFrames();
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        return this.getDelegate().getFrames(slot, facet, bl, object);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        return this.getDelegate().getFramesWithAnyValue(slot, facet, bl);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        return this.getDelegate().getMatchingFrames(slot, facet, bl, string, n);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        return this.getDelegate().getMatchingReferences(string, n);
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        return this.getDelegate().getReferences(object);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    @Override
    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        Sft sft;
        RemoteSession remoteSession;
        DeferredOperationCache deferredOperationCache = this.getCache(frame, true);
        CacheResult<List> cacheResult = deferredOperationCache.readCache(remoteSession = ServerFrameStore.getCurrentSession(), sft = new Sft(slot, facet, bl));
        if (cacheResult.isValid()) {
            ++this.cacheHits;
            return new ArrayList(this.getValues(cacheResult));
        }
        List list = this.getDelegate().getValues(frame, slot, facet, bl);
        deferredOperationCache.updateCache(remoteSession, sft, list);
        return list;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        Sft sft;
        RemoteSession remoteSession;
        DeferredOperationCache deferredOperationCache = this.getCache(frame, true);
        CacheResult<List> cacheResult = deferredOperationCache.readCache(remoteSession = ServerFrameStore.getCurrentSession(), sft = new Sft(slot, facet, bl));
        if (cacheResult.isValid()) {
            ++this.cacheHits;
            return this.getValues(cacheResult).size();
        }
        return this.getDelegate().getValuesCount(frame, slot, facet, bl);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        DeferredOperationCache deferredOperationCache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (deferredOperationCache != null) {
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            Sft sft = new Sft(slot, facet, bl);
            deferredOperationCache.modifyCache(remoteSession, sft);
        }
        this.getDelegate().moveValue(frame, slot, facet, bl, n, n2);
    }

    @Override
    public void reinitialize() {
        this.cacheMap.clear();
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        DeferredOperationCache deferredOperationCache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (deferredOperationCache != null) {
            Sft sft;
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            CacheResult<List> cacheResult = deferredOperationCache.readCache(remoteSession, sft = new Sft(slot, facet, bl));
            if (cacheResult.isValid()) {
                ArrayList arrayList = new ArrayList(this.getValues(cacheResult));
                arrayList.remove(object);
                deferredOperationCache.modifyCache(remoteSession, sft, arrayList);
            } else {
                deferredOperationCache.modifyCache(remoteSession, sft);
            }
        }
        this.getDelegate().removeValue(frame, slot, facet, bl, object);
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.getDelegate().replaceFrame(frame);
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        this.removeFrameReferences(frame);
        DeferredOperationCache deferredOperationCache = this.getCache(frame2, false);
        if (deferredOperationCache != null) {
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            deferredOperationCache.invalidate(remoteSession);
        }
        this.getDelegate().replaceFrame(frame, frame2);
    }

    @Override
    public void setName(String string) {
        this.getDelegate().setName(string);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        DeferredOperationCache deferredOperationCache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (deferredOperationCache != null) {
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            Sft sft = new Sft(slot, facet, bl);
            deferredOperationCache.modifyCache(remoteSession, sft, new ArrayList(collection));
        }
        this.getDelegate().setValues(frame, slot, facet, bl, collection);
    }
}

