/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

public class XMLUtil {
    private static final int FIRST_PRINTABLE = 32;
    private static final int LAST_PRINTABLE = 126;

    private static String getEntityRef(char c) {
        String string;
        switch (c) {
            case '<': {
                string = "&lt;";
                break;
            }
            case '>': {
                string = "&gt;";
                break;
            }
            case '\"': {
                string = "&quot;";
                break;
            }
            case '\'': {
                string = "&apos;";
                break;
            }
            case '&': {
                string = "&amp;";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String escape(char c) {
        String string = XMLUtil.getEntityRef(c);
        if (string == null) {
            string = XMLUtil.isPrintable(c) ? "" + c : "&#" + Integer.toString(c) + ";";
        }
        return string;
    }

    private static boolean isPrintable(char c) {
        return ' ' <= c && c <= '~' && c != '\u00f7' || c == '\n' || c == '\r' || c == '\t';
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(XMLUtil.escape(string.charAt(i)));
        }
        return stringBuffer.toString();
    }
}

