/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SelectInstanceFromCollectionPanel
extends JComponent {
    private static final long serialVersionUID = 1189735912135124770L;
    private JList _list;
    private Icon _clsIcon;

    public SelectInstanceFromCollectionPanel(Collection collection, int n) {
        this.setLayout(new BorderLayout());
        this._list = ComponentFactory.createList(ModalDialog.getCloseAction(this));
        collection = SelectInstanceFromCollectionPanel.removeHidden(collection);
        this._list.setListData(collection.toArray());
        this.configureRenderer();
        if (n >= 0) {
            this.setSelection(n);
        }
        JScrollPane jScrollPane = ComponentFactory.createScrollPane(this._list);
        this.add(jScrollPane);
        this.setPreferredSize(new Dimension(300, 150));
    }

    private boolean isMultiUserClient() {
        Object e;
        boolean bl = false;
        if (this._list.getModel().getSize() > 0 && (e = this._list.getModel().getElementAt(0)) instanceof Frame) {
            Frame frame = (Frame)e;
            Project project = frame.getProject();
            bl = project.isMultiUserClient();
        }
        return bl;
    }

    private void configureRenderer() {
        FrameRenderer frameRenderer;
        if (this.isMultiUserClient()) {
            frameRenderer = new FrameRenderer(){
                private static final long serialVersionUID = -4327868983862509964L;

                protected Icon getIcon(Cls cls) {
                    Icon icon;
                    if (SelectInstanceFromCollectionPanel.this._clsIcon == null) {
                        icon = cls.getIcon();
                        if (!cls.isMetaCls()) {
                            SelectInstanceFromCollectionPanel.this._clsIcon = icon;
                        }
                    } else {
                        icon = SelectInstanceFromCollectionPanel.this._clsIcon;
                    }
                    return icon;
                }
            };
        } else {
            frameRenderer = FrameRenderer.createInstance();
            frameRenderer.setDisplayTrailingIcons(false);
        }
        this._list.setCellRenderer(frameRenderer);
    }

    public Instance getSelection() {
        return (Instance)this._list.getSelectedValue();
    }

    private static Collection removeHidden(Collection arrayList) {
        ArrayList<Instance> arrayList2;
        Project project = ((Instance)CollectionUtilities.getFirstItem(arrayList)).getProject();
        if (project.getDisplayHiddenClasses()) {
            arrayList2 = arrayList;
        } else {
            arrayList2 = new ArrayList<Instance>();
            for (Instance instance : arrayList) {
                if (!instance.isVisible()) continue;
                arrayList2.add(instance);
            }
        }
        return arrayList2;
    }

    private void setSelection(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectInstanceFromCollectionPanel.this._list.setSelectedIndex(n);
                SelectInstanceFromCollectionPanel.this._list.ensureIndexIsVisible(n);
            }
        });
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this._list.setCellRenderer(listCellRenderer);
        }
    }
}

