/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.DefaultRenderer;
import java.util.Collection;

public class TypeFacetRenderer
extends DefaultRenderer {
    private static final long serialVersionUID = -7154991031361614206L;

    public void load(Object object) {
        FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        ValueType valueType = cls.getTemplateSlotValueType(slot);
        String string = valueType.toString();
        if (valueType == ValueType.INSTANCE) {
            Collection collection = cls.getTemplateSlotAllowedClses(slot);
            string = TypeFacetRenderer.append(string, "of", collection);
        } else if (valueType == ValueType.CLS) {
            Collection collection = cls.getTemplateSlotAllowedParents(slot);
            string = TypeFacetRenderer.append(string, "with superclass", collection);
        }
        this.setMainText(string);
        this.setGrayedText(!frameSlotCombination.getFrame().isEditable());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    private static String append(String string, String string2, Collection collection) {
        if (!collection.isEmpty()) {
            string = string + " " + string2 + " ";
            boolean bl = true;
            for (Cls cls : collection) {
                if (!bl) {
                    string = string + " or ";
                }
                bl = false;
                string = string + cls.getBrowserText();
            }
        }
        return string;
    }
}

