/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;

public class DefaultLogger
implements Log.LegacyLogger {
    private static final boolean INDENTATION_ENABLED = false;
    private int _nEntries = 0;
    private PrintWriter _writer;
    private boolean _displayTrace = true;
    private boolean _displayWarnings = true;
    private boolean _doPause = false;
    private boolean _showStack = false;
    private int _directTraceCount;
    private int _directWarningCount;
    private int _directErrorCount;

    public DefaultLogger() {
        this._writer = new PrintWriter(System.err);
    }

    public DefaultLogger(Writer writer) {
        this._writer = new PrintWriter(writer);
    }

    private String createMessage(String string, String string2, Object object, String string3, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        String string4 = object instanceof Class ? StringUtilities.getClassName((Class)object) : StringUtilities.getClassName(object);
        stringBuffer.append(string4);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append("(");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(DefaultLogger.toString(objectArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        if (!(object instanceof Class)) {
            stringBuffer.append(" - ");
            stringBuffer.append(object);
            stringBuffer.append(" ");
            stringBuffer.append(Integer.toHexString(object.hashCode()).toUpperCase());
        }
        return stringBuffer.toString();
    }

    public void enter(Object object, String string, Object[] objectArray) {
        this.trace("enter", object, string, objectArray);
        ++this._nEntries;
    }

    public void error(String string, Object object, String string2, Object[] objectArray) {
        this.output("ERROR", string, object, string2, objectArray);
        ++this._directErrorCount;
    }

    public void exception(Throwable throwable, Object object, String string, Object[] objectArray) {
        this.output("Exception", "failed", object, string, objectArray);
        throwable.printStackTrace(this._writer);
        this._writer.flush();
        ++this._directErrorCount;
    }

    public void exit(Object object, String string, Object[] objectArray) {
        this.trace("exit", object, string, objectArray);
        --this._nEntries;
    }

    public int getErrorCount() {
        return this._directErrorCount;
    }

    public int getTraceCount() {
        return this._directTraceCount + this.getWarningCount();
    }

    public int getWarningCount() {
        return this._directWarningCount + this.getErrorCount();
    }

    private void output(String string, String string2, Object object, String string3, Object[] objectArray) {
        this.output(string, string2, object, string3, objectArray, false);
    }

    private void output(String string, String string2, Object object, String string3, Object[] objectArray, boolean bl) {
        String string4 = this.createMessage(string, string2, object, string3, objectArray);
        if (bl || this._showStack) {
            new Throwable(string4).printStackTrace(this._writer);
        } else {
            this._writer.println(string4);
        }
        this._writer.flush();
        if (this._doPause) {
            SystemUtilities.pause();
        }
    }

    public void resetCounts() {
        this._directTraceCount = 0;
        this._directWarningCount = 0;
        this._directErrorCount = 0;
    }

    public void setDisplayTrace(boolean bl) {
        this._displayTrace = bl;
    }

    public void setDisplayWarnings(boolean bl) {
        this._displayWarnings = bl;
    }

    public void setDoPause(boolean bl) {
        this._doPause = bl;
    }

    public void setShowStack(boolean bl) {
        this._showStack = bl;
    }

    public void stack(String string, Object object, String string2, Object[] objectArray) {
        this.output("Stack Dump", string, object, string2, objectArray, true);
        ++this._directTraceCount;
    }

    private static String toString(Object object) {
        String string;
        try {
            string = object == null ? null : (object instanceof Collection ? "[" + CollectionUtilities.toString((Collection)object) + "]" : (object.getClass().isArray() ? "{" + CollectionUtilities.toString(Arrays.asList((Object[])object)) + "}" : object.toString()));
        }
        catch (Exception exception) {
            string = "<<toString() exception>>";
        }
        return string;
    }

    public void trace(String string, Object object, String string2, Object[] objectArray) {
        if (this._displayTrace) {
            this.output("Trace", string, object, string2, objectArray);
        }
        ++this._directTraceCount;
    }

    public void warning(String string, Object object, String string2, Object[] objectArray) {
        if (this._displayWarnings || this._displayTrace) {
            this.output("Warning", string, object, string2, objectArray);
        }
        ++this._directWarningCount;
    }
}

