/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<X>
implements Cloneable {
    private X root;
    private Map<X, Set<X>> nodeToChildrenMap = new LinkedHashMap<X, Set<X>>();

    public Tree(X x) {
        this.setRoot(x);
    }

    public Tree() {
    }

    public Tree<X> clone() {
        Tree<X> tree = new Tree<X>(this.root);
        for (Map.Entry<X, Set<X>> entry : this.nodeToChildrenMap.entrySet()) {
            X x = entry.getKey();
            Set<X> set = entry.getValue();
            tree.nodeToChildrenMap.put(x, new LinkedHashSet<X>(set));
        }
        return tree;
    }

    public void setRoot(X x) {
        this.root = x;
    }

    public void swapNode(X x, X x2) {
        Set<X> set;
        if (this.root == x) {
            this.root = x2;
        }
        if ((set = this.nodeToChildrenMap.remove(x)) != null) {
            this.nodeToChildrenMap.put(x2, set);
        }
        for (Set<X> set2 : this.nodeToChildrenMap.values()) {
            boolean bl = set2.remove(x);
            if (!bl) continue;
            set2.add(x2);
        }
    }

    public X getRoot() {
        return this.root;
    }

    public boolean isReachable(X x) {
        return this.root == x || this.getDescendents(this.root).contains(x);
    }

    public void addChild(X x, X x2) {
        if (x == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (x2 == null) {
            throw new IllegalArgumentException("Null child");
        }
        Set<X> set = this.nodeToChildrenMap.get(x);
        if (set == null) {
            set = new LinkedHashSet<X>();
            this.nodeToChildrenMap.put(x, set);
        }
        set.add(x2);
    }

    public void removeChild(X x, X x2) {
        Set<X> set = this.nodeToChildrenMap.get(x);
        if (set == null) {
            Tree.logNoSuchChild(x, x2);
        } else {
            boolean bl = set.remove(x2);
            if (!bl) {
                Tree.logNoSuchChild(x, x2);
            }
        }
    }

    public void removeNode(X x) {
        if (this.root == x) {
            this.root = null;
        }
        this.nodeToChildrenMap.remove(x);
        for (Set<X> set : this.nodeToChildrenMap.values()) {
            set.remove(x);
        }
    }

    private static void logNoSuchChild(Object object, Object object2) {
        Log.getLogger().warning("No such child: " + object + " " + object2);
    }

    public Set<X> getChildren(X x) {
        Set<X> set = this.nodeToChildrenMap.get(x);
        return set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
    }

    public Set<X> getNodeAndDescendents(X x) {
        Set<X> set = this.getDescendents(x);
        if (x == null) {
            Log.getLogger().severe("Null parent");
        } else {
            set.add(x);
        }
        return set;
    }

    public Set<X> getDescendents(X x) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.getDescendents(x, linkedHashSet);
        return linkedHashSet;
    }

    private void getDescendents(X x, Set<X> set) {
        Set<X> set2 = this.nodeToChildrenMap.get(x);
        if (set2 != null) {
            for (X x2 : set2) {
                boolean bl = set.add(x2);
                if (!bl) continue;
                this.getDescendents(x2, set);
            }
        }
    }

    public Set<X> getNodes() {
        return this.getDescendents(this.root);
    }
}

