/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.serialize;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheRead<S, V, R>
extends SerializedCacheUpdate<S, V, R> {
    private static final long serialVersionUID = -1535032893706670178L;
    private V var;
    private CacheResult<R> value;

    public CacheRead(S s, V v, CacheResult<R> cacheResult) {
        super(s);
        this.var = v;
        this.value = cacheResult;
    }

    public V getVar() {
        return this.var;
    }

    public CacheResult<R> getValue() {
        return this.value;
    }

    @Override
    public void performUpdate(Cache<S, V, R> cache) {
        if (this.value.isValid()) {
            cache.updateCache(this.getSession(), this.var, this.value.getResult());
        } else {
            cache.updateCache(this.getSession(), this.var);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<CacheOp: Session ");
        stringBuffer.append(this.getSession());
        stringBuffer.append(" reads var ");
        stringBuffer.append(this.getVar());
        stringBuffer.append(" retrieving ");
        stringBuffer.append(this.getValue());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

