/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;

public class BooleanListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = -4884073729270631387L;
    private static final Collection ALLOWED_VALUES = new ArrayList();

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -4209277615930518731L;

            public void onCreate() {
                BooleanListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 8093323243741620L;

            public void onView(Object object) {
                BooleanListWidget.this.handleViewAction((Boolean)object);
            }
        };
    }

    private Action getRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 3228703105413852749L;

            public void onRemove(Collection collection) {
                BooleanListWidget.this.handleRemoveAction(collection);
            }
        };
    }

    protected void handleCreateAction() {
        Boolean bl = this.edit("Create Boolean Value", null);
        if (bl != null) {
            this.addItem(bl);
        }
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(Boolean bl) {
        Boolean bl2 = this.edit("Edit Boolean Value", bl);
        if (bl2 != null) {
            this.replaceItem(bl, bl2);
        }
    }

    private Boolean edit(String string, Boolean bl) {
        return (Boolean)DisplayUtilities.pickSymbol(this, string, bl, ALLOWED_VALUES);
    }

    public void initialize() {
        Action action = this.getEditAction();
        super.initialize(action);
        this.addButton(action);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = cls.getTemplateSlotValueType(slot) == ValueType.BOOLEAN;
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl3;
        }
        return bl;
    }

    static {
        ALLOWED_VALUES.add(Boolean.TRUE);
        ALLOWED_VALUES.add(Boolean.FALSE);
    }
}

