/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.ClsCode;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotAtClassCode
implements Comparable<SlotAtClassCode> {
    private Cls cls;
    private Slot slot;

    public SlotAtClassCode(Cls cls, Slot slot) {
        this.cls = cls;
        this.slot = slot;
    }

    public String getJavaName() {
        return ClsCode.getValidJavaName(this.slot.getName());
    }

    public String getJavaType() {
        return this.getJavaType(false);
    }

    public String getJavaType(boolean bl) {
        ValueType valueType = this.slot.getValueType();
        if (valueType == ValueType.STRING || valueType == ValueType.SYMBOL) {
            return "String";
        }
        if (valueType == ValueType.BOOLEAN) {
            return bl ? "java.lang.Boolean" : "boolean";
        }
        if (valueType == ValueType.FLOAT) {
            return bl ? "java.lang.Float" : "float";
        }
        if (valueType == ValueType.INTEGER) {
            return bl ? "java.lang.Integer" : "int";
        }
        if (valueType == ValueType.CLS) {
            Log.getLogger().warning("Value type CLS for " + this.slot + " is not supported by the code generator.");
            return "Object";
        }
        if (valueType == ValueType.INSTANCE) {
            return this.getInstanceValueJavaTypeName();
        }
        if (valueType == ValueType.ANY) {
            return "Object";
        }
        Log.getLogger().warning("Unrecognized value type for " + this.slot);
        return "Object";
    }

    public String getPrimitiveMethod() {
        ValueType valueType = this.slot.getValueType();
        if (valueType == ValueType.INTEGER) {
            return "intValue()";
        }
        if (valueType == ValueType.FLOAT) {
            return "floatValue()";
        }
        if (valueType == ValueType.BOOLEAN) {
            return "booleanValue()";
        }
        return "";
    }

    public boolean needsPrimitiveMethod() {
        ValueType valueType = this.slot.getValueType();
        return valueType == ValueType.INTEGER || valueType == ValueType.FLOAT || valueType == ValueType.BOOLEAN;
    }

    protected String getInstanceValueJavaTypeName() {
        Collection collection = this.cls.getTemplateSlotAllowedClses(this.slot);
        if (collection.size() > 1) {
            return "Object";
        }
        Cls cls = (Cls)CollectionUtilities.getSoleItem(collection);
        return ClsCode.getValidJavaName(cls.getName());
    }

    public String getRangeClsName() {
        return this.getRangeCls().getName();
    }

    public Cls getRangeCls() {
        Collection collection = this.cls.getTemplateSlotAllowedClses(this.slot);
        if (collection.size() == 0) {
            return this.cls.getKnowledgeBase().getRootCls();
        }
        return (Cls)CollectionUtilities.getSoleItem(collection);
    }

    public Slot getSlot() {
        return this.slot;
    }

    public Cls getCls() {
        return this.cls;
    }

    public String getUpperCaseJavaName() {
        String string = this.getJavaName();
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string.toUpperCase();
    }

    public boolean isCustomType() {
        return this.cls.getTemplateSlotAllowedClses(this.slot).size() > 0;
    }

    public boolean isMultiple() {
        return this.cls.getTemplateSlotAllowsMultipleValues(this.slot);
    }

    public boolean isPrimitive() {
        ValueType valueType = this.slot.getValueType();
        return valueType == ValueType.BOOLEAN || valueType == ValueType.INTEGER || valueType == ValueType.FLOAT;
    }

    @Override
    public int compareTo(SlotAtClassCode slotAtClassCode) {
        SlotAtClassCode slotAtClassCode2 = slotAtClassCode;
        return this.getJavaName().compareTo(slotAtClassCode2.getJavaName());
    }
}

