/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;

public class ServerProject
extends UnicastRemoteObject
implements RemoteServerProject {
    private static final long serialVersionUID = 7320382402535936929L;
    private URI _uri;
    private Server _server;
    private Project _project;
    private ProjectInstance metaProjectInstance;
    private ServerFrameStore _domainKbFrameStore;
    private ServerFrameStore _projectKbFrameStore;

    public ServerProject(Server server, URI uRI, ProjectInstance projectInstance, Project project) throws RemoteException {
        super(SSLFactory.getServerPort(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS));
        this._server = server;
        this._uri = uRI;
        this._project = project;
        this.metaProjectInstance = projectInstance;
        this._domainKbFrameStore = ServerProject.createServerFrameStore(this._project.getKnowledgeBase());
        this._domainKbFrameStore.setMetaProjectInstance(projectInstance);
        this._projectKbFrameStore = ServerProject.createServerFrameStore(this._project.getInternalProjectKnowledgeBase());
    }

    private static ServerFrameStore createServerFrameStore(KnowledgeBase knowledgeBase) throws RemoteException {
        ServerFrameStore serverFrameStore = new ServerFrameStore(knowledgeBase);
        return serverFrameStore;
    }

    public ProjectInstance getMetaProjectInstance() {
        return this.metaProjectInstance;
    }

    public URI getURI(RemoteSession remoteSession) {
        return this._uri;
    }

    public String getDomainKbFactoryClassName() {
        return this._project.getKnowledgeBase().getKnowledgeBaseFactory().getClass().getName();
    }

    public String getProjectKbFactoryClassName() {
        return this._project.getInternalProjectKnowledgeBase().getKnowledgeBaseFactory().getClass().getName();
    }

    public RemoteServerFrameStore getDomainKbFrameStore(RemoteSession remoteSession) {
        return this._domainKbFrameStore;
    }

    public RemoteServerFrameStore getProjectKbFrameStore(RemoteSession remoteSession) {
        return this._projectKbFrameStore;
    }

    public void register(RemoteSession remoteSession) throws ServerSessionLost {
        this._domainKbFrameStore.register(remoteSession);
        this._projectKbFrameStore.register(remoteSession);
    }

    public void deregister(RemoteSession remoteSession) throws ServerSessionLost {
        this._domainKbFrameStore.deregister(remoteSession);
        this._projectKbFrameStore.deregister(remoteSession);
    }

    public void close(RemoteSession remoteSession) throws ServerSessionLost {
        this._server.disconnectFromProject(this, remoteSession);
    }

    public Collection getCurrentSessions(RemoteSession remoteSession) {
        return this._server.getCurrentSessions(this);
    }

    public boolean isDirty() {
        return this._domainKbFrameStore.isDirty();
    }

    public void setClean() {
        this._domainKbFrameStore.markClean();
        this._projectKbFrameStore.markClean();
    }

    public void setFrameCalculatorDisabled(boolean bl) {
        this._domainKbFrameStore.setFrameCalculatorDisabled(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectStatus implements Localizable
    {
        READY,
        SHUTTING_DOWN,
        CLOSED_FOR_MAINTENANCE;


        @Override
        public void localize(KnowledgeBase knowledgeBase) {
        }
    }
}

