/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7730063885739903457L;
    Map<RemoteSession, Boolean> userInfo = new HashMap<RemoteSession, Boolean>();
    FrameCalculatorStats stats = null;
    List<RemoteSession> sessions = new ArrayList<RemoteSession>();

    public void setUserInfo(Map<RemoteSession, Boolean> map, FrameCalculatorStats frameCalculatorStats) {
        this.userInfo = map;
        this.stats = frameCalculatorStats;
        this.sessions = new ArrayList<RemoteSession>();
        if (map != null && frameCalculatorStats != null) {
            for (RemoteSession remoteSession : map.keySet()) {
                this.sessions.add(remoteSession);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.userInfo == null ? 0 : this.userInfo.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Column column = Column.values()[n2];
        switch (column) {
            case sessionId: {
                RemoteSession remoteSession = this.sessions.get(n);
                if (remoteSession instanceof Session) {
                    return ((Session)remoteSession).getId();
                }
                return "(none)";
            }
            case user: {
                return this.sessions.get(n).getUserName();
            }
            case ipAddr: {
                return this.sessions.get(n).getUserIpAddress();
            }
            case transaction: {
                return this.userInfo.get(this.sessions.get(n));
            }
            case backlog: {
                if (this.stats == null) {
                    return new Integer(-1);
                }
                RemoteSession remoteSession = this.sessions.get(n);
                Integer n3 = this.stats.getPreCacheBacklog().get(remoteSession);
                if (n3 == null) {
                    return 0;
                }
                return new Integer(n3);
            }
        }
        throw new UnsupportedOperationException("Programmer Error");
    }

    public RemoteSession getSession(int n) {
        return this.sessions.get(n);
    }

    @Override
    public String getColumnName(int n) {
        Column column = Column.values()[n];
        return column.getColumnName();
    }

    public Class getColumnClass(int n) {
        Column column = Column.values()[n];
        switch (column) {
            case sessionId: 
            case user: 
            case ipAddr: {
                return String.class;
            }
            case transaction: {
                return Boolean.class;
            }
            case backlog: {
                return Integer.class;
            }
        }
        throw new UnsupportedOperationException("Programmer Error");
    }

    public RemoteSession getRemoteSession(int n) {
        return this.sessions.get(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        sessionId("Session ID"),
        user("User"),
        ipAddr("IP Adress"),
        transaction("In Transaction?"),
        backlog("Server Backlog");

        private String name;

        private Column(String string2) {
            this.name = string2;
        }

        public String getColumnName() {
            return this.name;
        }
    }
}

