/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.ClientAndFrame;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.util.ApplicationProperties;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkInfo
implements Comparable<WorkInfo> {
    public static final String WORK_INFO_TIMEOUT_PROPERTY = "edu.stanford.smi.protege.server.framecalculator.work.info.expiration";
    public static final int WORK_INFO_TIMEOUT = ApplicationProperties.getIntegerProperty("edu.stanford.smi.protege.server.framecalculator.work.info.expiration", 60000);
    private static int counter = 0;
    private RemoteSession client;
    private Frame frame;
    private Set<ServerCachedState> states = new HashSet<ServerCachedState>();
    private EnumSet<CacheRequestReason> reasons = EnumSet.noneOf(CacheRequestReason.class);
    private boolean skipDirectInstances = false;
    private boolean targetFullCache = true;
    private int sequence = counter++;
    private long timeWorkInfoAdded = System.currentTimeMillis();

    public boolean expired() {
        return System.currentTimeMillis() - this.timeWorkInfoAdded > (long)WORK_INFO_TIMEOUT;
    }

    public RemoteSession getClient() {
        return this.client;
    }

    public void setClient(RemoteSession remoteSession) {
        this.client = remoteSession;
    }

    public void addState(ServerCachedState serverCachedState) {
        this.states.add(serverCachedState);
    }

    public Set<ServerCachedState> getStates() {
        return this.states;
    }

    public void addReason(CacheRequestReason cacheRequestReason) {
        this.reasons.add(cacheRequestReason);
    }

    public EnumSet<CacheRequestReason> getReasons() {
        return this.reasons;
    }

    public boolean skipDirectInstances() {
        return this.skipDirectInstances;
    }

    public void setSkipDirectInstances(boolean bl) {
        this.skipDirectInstances = bl;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setNewest() {
        this.sequence = counter++;
    }

    @Override
    public int compareTo(WorkInfo workInfo) {
        int n;
        int n2 = CacheRequestReason.priority(this.reasons);
        if (n2 != (n = CacheRequestReason.priority(workInfo.reasons))) {
            return n - n2;
        }
        return workInfo.sequence - this.sequence;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public boolean isTargetFullCache() {
        return this.targetFullCache;
    }

    public void setTargetFullCache(boolean bl) {
        this.targetFullCache = bl;
    }

    public ClientAndFrame getClientAndFrame() {
        return new ClientAndFrame(this.client, this.frame);
    }
}

