/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WrappedProtegeInstanceImpl
implements Localizable,
Serializable {
    private static final long serialVersionUID = -1976680694911360227L;
    MetaProjectImpl mp;
    private Instance i;
    private MetaProjectImpl.ClsEnum cls;

    public WrappedProtegeInstanceImpl(MetaProjectImpl metaProjectImpl, Instance instance, MetaProjectImpl.ClsEnum clsEnum) {
        if (!instance.hasType(metaProjectImpl.getCls(clsEnum))) {
            throw new IllegalArgumentException("" + instance + " should be of type " + (Object)((Object)clsEnum));
        }
        this.i = instance;
        this.cls = clsEnum;
        this.mp = metaProjectImpl;
    }

    public MetaProjectImpl getMetaProject() {
        return this.mp;
    }

    public Instance getProtegeInstance() {
        return this.i;
    }

    public MetaProjectImpl.ClsEnum getCls() {
        return this.cls;
    }

    protected Set getSlotValues(MetaProjectImpl.SlotEnum slotEnum, MetaProjectImpl.ClsEnum clsEnum) {
        HashSet<WrappedProtegeInstanceImpl> hashSet = new HashSet<WrappedProtegeInstanceImpl>();
        for (Object e : this.i.getOwnSlotValues(this.mp.getSlot(slotEnum))) {
            if (!(e instanceof Instance)) continue;
            hashSet.add(this.mp.wrapInstance(clsEnum, (Instance)e));
        }
        return hashSet;
    }

    protected Object getSlotValue(MetaProjectImpl.SlotEnum slotEnum, MetaProjectImpl.ClsEnum clsEnum) {
        Object object = this.i.getOwnSlotValue(this.mp.getSlot(slotEnum));
        if (object != null && object instanceof Instance) {
            return this.mp.wrapInstance(clsEnum, (Instance)object);
        }
        return object;
    }

    protected void setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum slotEnum, Collection collection) {
        Slot slot = this.mp.getSlot(slotEnum);
        this.i.setDirectOwnSlotValues(slot, this.getProtegeCollection(collection));
    }

    protected void setSlotValue(MetaProjectImpl.SlotEnum slotEnum, Object object) {
        Slot slot = this.mp.getSlot(slotEnum);
        if (object instanceof WrappedProtegeInstanceImpl) {
            object = ((WrappedProtegeInstanceImpl)object).getProtegeInstance();
        }
        this.i.setDirectOwnSlotValue(slot, object);
    }

    protected void addSlotValue(MetaProjectImpl.SlotEnum slotEnum, Object object) {
        Slot slot = this.mp.getSlot(slotEnum);
        if (object instanceof WrappedProtegeInstanceImpl) {
            Instance instance = ((WrappedProtegeInstanceImpl)object).getProtegeInstance();
            if (instance == null) {
                throw new OntologyException("Failed to add for " + this.i.getName() + " slot " + slot.getName() + " value: " + object + ". Probably " + object + " is not in the metaproject.");
            }
            this.i.addOwnSlotValue(slot, instance);
        } else {
            this.i.addOwnSlotValue(slot, object);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof WrappedProtegeInstanceImpl)) {
            return false;
        }
        WrappedProtegeInstanceImpl wrappedProtegeInstanceImpl = (WrappedProtegeInstanceImpl)object;
        return this.mp == wrappedProtegeInstanceImpl.mp && this.getProtegeInstance().equals(wrappedProtegeInstanceImpl.getProtegeInstance());
    }

    public int hashCode() {
        return this.getProtegeInstance().hashCode();
    }

    public Collection getProtegeCollection(Collection collection) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (Object e : collection) {
            if (e instanceof WrappedProtegeInstanceImpl) {
                WrappedProtegeInstanceImpl wrappedProtegeInstanceImpl = (WrappedProtegeInstanceImpl)e;
                arrayList.add(wrappedProtegeInstanceImpl.getProtegeInstance());
                continue;
            }
            arrayList.add((Instance)e);
        }
        return arrayList;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        this.mp.localize(knowledgeBase);
        LocalizeUtils.localize(this.i, knowledgeBase);
    }

    public String toString() {
        return "[" + (Object)((Object)this.cls) + ": " + this.i.getName() + "]";
    }
}

