/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.AbstractKnowledgeBaseFactory;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.xml.FileSourcesPanel;
import edu.stanford.smi.protege.storage.xml.XMLLoader;
import edu.stanford.smi.protege.storage.xml.XMLStorer;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;

public class XMLKnowledgeBaseFactory
extends AbstractKnowledgeBaseFactory {
    public static final String DESCRIPTION = "Experimental XML File (.xml)";
    private static final String SOURCE_FILE_NAME = "source_file_name";

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase(this);
        return defaultKnowledgeBase;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        return new FileSourcesPanel(string, propertyList);
    }

    public static String getSourceFile(PropertyList propertyList) {
        return propertyList.getString(SOURCE_FILE_NAME);
    }

    public static URI getSourceRelativeURI(PropertyList propertyList) {
        return URIUtilities.createURI(XMLKnowledgeBaseFactory.getSourceFile(propertyList));
    }

    public BufferedReader getSourceReader(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = XMLKnowledgeBaseFactory.getSourceFile(propertyList);
        return string == null ? null : this.createReader(knowledgeBase, string, collection);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isComplete(PropertyList propertyList) {
        return true;
    }

    protected void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, boolean bl, Collection collection) {
        BufferedReader bufferedReader = this.getSourceReader(knowledgeBase, propertyList, collection);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(knowledgeBase, bufferedReader, bl, collection);
        this.close(bufferedReader);
    }

    public static void loadKnowledgeBase(KnowledgeBase knowledgeBase, BufferedReader bufferedReader, boolean bl, Collection collection) {
        boolean bl2 = knowledgeBase.setCallCachingEnabled(false);
        boolean bl3 = knowledgeBase.setGenerateEventsEnabled(false);
        new XMLLoader(knowledgeBase, bufferedReader, bl, collection).load();
        knowledgeBase.setGenerateEventsEnabled(bl3);
        knowledgeBase.setCallCachingEnabled(bl2);
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, String string, boolean bl, Collection collection) {
        BufferedReader bufferedReader = this.createReader(knowledgeBase, string, collection);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(knowledgeBase, bufferedReader, bl, collection);
        FileUtilities.close(bufferedReader);
    }

    public KnowledgeBase loadKnowledgeBase(BufferedReader bufferedReader, Collection collection) {
        KnowledgeBase knowledgeBase = this.createKnowledgeBase(collection);
        XMLKnowledgeBaseFactory.loadKnowledgeBase(knowledgeBase, bufferedReader, false, collection);
        return knowledgeBase;
    }

    public KnowledgeBase loadKnowledgeBase(String string, Collection collection) {
        KnowledgeBase knowledgeBase = this.createKnowledgeBase(collection);
        this.loadKnowledgeBase(knowledgeBase, string, false, collection);
        return knowledgeBase;
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = knowledgeBase.getProject().getProjectName();
        String string2 = XMLKnowledgeBaseFactory.getSourceFile(propertyList);
        if (string2 == null) {
            string2 = string + ".xml";
            XMLKnowledgeBaseFactory.setSourceFile(propertyList, string2);
        }
        this.saveKnowledgeBase(knowledgeBase, string2, collection);
    }

    public static void saveKnowledgeBase(KnowledgeBase knowledgeBase, Writer writer, Collection collection) {
        new XMLStorer(knowledgeBase, writer, collection).store();
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, String string, Collection collection) {
        BufferedWriter bufferedWriter = null;
        try {
            File file = this.createTempFile(knowledgeBase, string);
            bufferedWriter = this.createWriter(file);
            XMLKnowledgeBaseFactory.saveKnowledgeBase(knowledgeBase, bufferedWriter, collection);
            this.close(bufferedWriter);
            if (collection.isEmpty()) {
                this.makeTempFilePermanent(file);
            }
        }
        catch (Exception exception) {
            String string2 = "Errors saving file " + string;
            collection.add(new MessageError(exception, string2));
            Log.getLogger().log(Level.SEVERE, string2, exception);
            this.close(bufferedWriter);
        }
    }

    public static void setSourceFile(PropertyList propertyList, String string) {
        XMLKnowledgeBaseFactory.setProperty(propertyList, SOURCE_FILE_NAME, string);
    }

    public static void setSourceURIs(PropertyList propertyList, URI uRI) {
        XMLKnowledgeBaseFactory.setSourceFile(propertyList, XMLKnowledgeBaseFactory.toString(uRI));
    }

    private static String toString(URI uRI) {
        return uRI == null ? null : uRI.toString();
    }

    private static void setProperty(PropertyList propertyList, String string, String string2) {
        propertyList.setString(string, string2);
    }
}

