/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public class DirectTypesList
extends SelectableContainer {
    private SelectableList list;
    private Instance instance;
    private KnowledgeBase knowledgeBase;
    private AbstractAction addAction;
    private InstanceListener instanceListener = new InstanceListener(){

        public void directTypeAdded(InstanceEvent instanceEvent) {
            ComponentUtilities.addListValue(DirectTypesList.this.list, instanceEvent.getCls());
        }

        public void directTypeRemoved(InstanceEvent instanceEvent) {
            ComponentUtilities.removeListValue(DirectTypesList.this.list, instanceEvent.getCls());
        }
    };

    public DirectTypesList(Project project) {
        this.knowledgeBase = project.getKnowledgeBase();
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer(new FrameRenderer());
        this.setSelectable(this.list);
        LabeledComponent labeledComponent = new LabeledComponent("Types", new JScrollPane(this.list));
        labeledComponent.addHeaderButton(this.createAddTypeAction());
        labeledComponent.addHeaderButton(this.createRemoteTypeAction());
        this.setLayout(new BorderLayout());
        this.add(labeledComponent);
        this.setPreferredSize(new Dimension(0, 100));
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new FrameTransferHandler());
    }

    public void setInstance(Instance instance) {
        if (this.instance != null) {
            this.instance.removeInstanceListener(this.instanceListener);
        }
        this.instance = instance;
        if (this.instance != null) {
            this.instance.addInstanceListener(this.instanceListener);
        }
        this.updateModel();
        this.updateAddButton();
    }

    public void updateModel() {
        AbstractListModel abstractListModel;
        if (this.instance == null) {
            abstractListModel = new DefaultListModel();
        } else {
            Collection collection = this.instance.getDirectTypes();
            abstractListModel = new SimpleListModel(collection);
        }
        this.list.setModel(abstractListModel);
    }

    public void updateAddButton() {
        this.addAction.setEnabled(this.instance != null);
    }

    private Action createAddTypeAction() {
        this.addAction = new AddAction(ResourceKey.CLASS_ADD){

            public void onAdd() {
                Collection collection = DisplayUtilities.pickClses((Component)DirectTypesList.this, DirectTypesList.this.knowledgeBase);
                for (Cls cls : collection) {
                    if (DirectTypesList.this.instance.hasType(cls)) continue;
                    DirectTypesList.this.instance.addDirectType(cls);
                }
            }
        };
        return this.addAction;
    }

    private Action createRemoteTypeAction() {
        return new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this.list){

            public void onRemove(Object object) {
                Cls cls = (Cls)object;
                DirectTypesList.this.instance.removeDirectType(cls);
            }
        };
    }

    private class FrameTransferHandler
    extends TransferHandler {
        private FrameTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            Collection collection = DirectTypesList.this.getSelection();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return true;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                for (Cls cls : DirectTypesList.this.getSelection()) {
                    int n2 = 0;
                    Log.getLogger().info("Move " + cls + " to: " + n2);
                    DirectTypesList.this.instance.moveDirectType(cls, n2);
                    DirectTypesList.this.updateModel();
                }
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }
}

