/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.test.TestUtilities;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class InstanceDisplay_Test
extends APITestCase {
    private void deleteAllStickies() {
        KnowledgeBase knowledgeBase = this.getDomainKB();
        Cls cls = knowledgeBase.getCls(":INSTANCE-ANNOTATION");
        for (Instance instance : new ArrayList<Instance>(cls.getInstances())) {
            knowledgeBase.deleteInstance(instance);
        }
    }

    private JFrame loadIntoFrame(String string) {
        JFrame jFrame = new JFrame();
        InstanceDisplay instanceDisplay = new InstanceDisplay(this.getProject());
        jFrame.getContentPane().add(instanceDisplay);
        Instance instance = this.getInstance(string);
        InstanceDisplay_Test.assertNotNull((String)("instance exists: " + string), (Object)instance);
        instanceDisplay.setInstance(instance, null);
        jFrame.pack();
        jFrame.setVisible(true);
        Toolkit.getDefaultToolkit().sync();
        SystemUtilities.sleepMsec(100);
        return jFrame;
    }

    private static void pressMessageOK() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    ModalDialog modalDialog = null;
                    while (modalDialog == null) {
                        modalDialog = ModalDialog.getCurrentDialog();
                        if (modalDialog != null) {
                            InstanceDisplay_Test.pressButton(modalDialog, Icons.getYesIcon());
                            return;
                        }
                        SystemUtilities.sleepMsec(100);
                    }
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static void pressButton(Component component, Icon icon) {
        TestUtilities.pressButton(component, icon);
    }

    public void testYellowStickyCreation() {
        this.deleteAllStickies();
        String string = this.createCls().getName();
        JFrame jFrame = this.loadIntoFrame(string);
        int n = this.getFrameCount();
        InstanceDisplay_Test.pressButton(jFrame, Icons.getCreateClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"frame count", (int)(n + 1), (int)this.getFrameCount());
        JInternalFrame jInternalFrame = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, jFrame);
        InstanceDisplay_Test.assertNotNull((String)"internal frame", (Object)jInternalFrame);
        JTextArea jTextArea = (JTextArea)ComponentUtilities.getDescendentOfClass(JTextArea.class, jInternalFrame);
        InstanceDisplay_Test.assertNotNull((String)"text area", (Object)jTextArea);
        jTextArea.setText("This is a test - " + System.currentTimeMillis());
        JFrame jFrame2 = this.loadIntoFrame(string);
        Point point = jFrame2.getLocation();
        point.x += 200;
        jFrame2.setLocation(point);
        ComponentUtilities.dispose(jFrame);
        ComponentUtilities.dispose(jFrame2);
        this.deleteAllStickies();
    }

    public void testYellowStickyDeletion() {
        this.deleteAllStickies();
        String string = this.createCls().getName();
        JFrame jFrame = this.loadIntoFrame(string);
        int n = this.getFrameCount();
        InstanceDisplay_Test.pressButton(jFrame, Icons.getCreateClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"added sticky", (int)(n + 1), (int)this.getFrameCount());
        InstanceDisplay_Test.pressMessageOK();
        InstanceDisplay_Test.pressButton(jFrame, Icons.getDeleteClsNoteIcon());
        InstanceDisplay_Test.assertEquals((String)"deleted sticky", (int)n, (int)this.getFrameCount());
        ComponentUtilities.dispose(jFrame);
        this.deleteAllStickies();
    }

    public void testYellowStickyLocationSave() {
        String string = this.createCls().getName();
        JFrame jFrame = this.loadIntoFrame(string);
        InstanceDisplay_Test.pressButton(jFrame, Icons.getCreateClsNoteIcon());
        final JInternalFrame jInternalFrame = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, jFrame);
        JTextArea jTextArea = (JTextArea)ComponentUtilities.getDescendentOfClass(JTextArea.class, jInternalFrame);
        jTextArea.setText("This is a test - " + System.currentTimeMillis());
        final Point point = jInternalFrame.getLocation();
        point.x += 100;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    jInternalFrame.setLocation(point);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            InstanceDisplay_Test.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            InstanceDisplay_Test.fail();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    jInternalFrame.setLocation(point);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            InstanceDisplay_Test.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            InstanceDisplay_Test.fail();
        }
        ComponentUtilities.dispose(jFrame);
        JFrame jFrame2 = this.loadIntoFrame(string);
        JInternalFrame jInternalFrame2 = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, jFrame2);
        InstanceDisplay_Test.assertEquals((String)"within project", (Object)point, (Object)jInternalFrame2.getLocation());
        ComponentUtilities.dispose(jFrame2);
        InstanceDisplay_Test.saveAndReload();
        JFrame jFrame3 = this.loadIntoFrame(string);
        JInternalFrame jInternalFrame3 = (JInternalFrame)ComponentUtilities.getDescendentOfClass(JInternalFrame.class, jFrame3);
        InstanceDisplay_Test.assertEquals((String)"after reload", (Object)point, (Object)jInternalFrame3.getLocation());
        ComponentUtilities.dispose(jFrame3);
        this.deleteAllStickies();
    }
}

