/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.SlotAdapter;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.ui.SlotSubslotNode;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SlotSubslotRoot
extends LazyTreeRoot {
    private KnowledgeBase _knowledgeBase;
    private KnowledgeBaseListener _listener = new KnowledgeBaseAdapter(){

        public void slotCreated(KnowledgeBaseEvent knowledgeBaseEvent) {
            if (knowledgeBaseEvent.isReplacementEvent()) {
                return;
            }
            super.slotCreated(knowledgeBaseEvent);
            Slot slot = knowledgeBaseEvent.getSlot();
            if (slot.getDirectSuperslots().isEmpty()) {
                List list = (List)SlotSubslotRoot.this.getUserObject();
                int n = 0;
                list.add(n, slot);
                SlotSubslotRoot.this.childAdded(slot, n);
                if (SlotSubslotRoot.this.getChildCount() == 1) {
                    SlotSubslotRoot.this.notifyNodeStructureChanged(SlotSubslotRoot.this);
                }
            }
        }

        public void slotDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
            if (knowledgeBaseEvent.isReplacementEvent()) {
                return;
            }
            super.slotDeleted(knowledgeBaseEvent);
            Slot slot = knowledgeBaseEvent.getSlot();
            List list = (List)SlotSubslotRoot.this.getUserObject();
            boolean bl = list.remove(slot);
            if (bl) {
                SlotSubslotRoot.this.childRemoved(slot);
            }
        }
    };
    private SlotListener _slotListener = new SlotAdapter(){

        public void directSuperslotAdded(SlotEvent slotEvent) {
            if (slotEvent.isReplacementEvent()) {
                return;
            }
            Slot slot = slotEvent.getSlot();
            if (slot.getDirectSuperslotCount() == 1) {
                SlotSubslotRoot.this.removeChild(slot);
            }
        }

        public void directSuperslotRemoved(SlotEvent slotEvent) {
            if (slotEvent.isReplacementEvent()) {
                return;
            }
            Slot slot = slotEvent.getSlot();
            if (slot.getDirectSuperslotCount() == 0) {
                SlotSubslotRoot.this.addChild(slot);
            }
        }
    };

    private void removeChild(Slot slot) {
        List list = (List)this.getUserObject();
        list.remove(slot);
        this.childRemoved(slot);
    }

    private void addChild(Slot slot) {
        List list = (List)this.getUserObject();
        list.add(slot);
        this.childAdded(slot);
    }

    public SlotSubslotRoot(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, SlotSubslotRoot.getSlots(knowledgeBase));
    }

    public SlotSubslotRoot(KnowledgeBase knowledgeBase, Collection collection) {
        this(knowledgeBase, collection, ApplicationProperties.getSortSlotTreeOption());
    }

    public SlotSubslotRoot(KnowledgeBase knowledgeBase, Collection collection, boolean bl) {
        super(collection);
        knowledgeBase.addKnowledgeBaseListener(this._listener);
        knowledgeBase.addSlotListener(this._slotListener);
        this._knowledgeBase = knowledgeBase;
    }

    public LazyTreeNode createNode(Object object) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)object);
    }

    public void dispose() {
        super.dispose();
        this._knowledgeBase.removeKnowledgeBaseListener(this._listener);
        this._knowledgeBase.removeSlotListener(this._slotListener);
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    private static Collection getSlots(KnowledgeBase knowledgeBase) {
        ArrayList arrayList = new ArrayList(knowledgeBase.getSlots());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (slot.getDirectSuperslotCount() <= 0) continue;
            iterator.remove();
        }
        if (ApplicationProperties.getSortSlotTreeOption()) {
            Collections.sort(arrayList, new FrameComparator());
        }
        return arrayList;
    }
}

