/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.ErrorLazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;

public abstract class LazyTreeNode
implements TreeNode {
    private LazyTreeNode _parent;
    private Object _userObject;
    private List _childNodes;
    private int _childCount = -1;
    private boolean _isLoaded;
    private boolean _isDuplicate;
    private boolean _isSorted = false;

    protected LazyTreeNode(LazyTreeNode lazyTreeNode, Object object) {
        this(lazyTreeNode, object, false);
    }

    protected LazyTreeNode(LazyTreeNode lazyTreeNode, Object object, boolean bl) {
        this._parent = lazyTreeNode;
        this._userObject = object;
        this._isDuplicate = LazyTreeNode.isDuplicate(object, lazyTreeNode);
        this._isSorted = bl;
    }

    private static boolean isDuplicate(Object object, LazyTreeNode lazyTreeNode) {
        boolean bl = false;
        for (LazyTreeNode lazyTreeNode2 = lazyTreeNode; lazyTreeNode2 != null; lazyTreeNode2 = lazyTreeNode2.getLazyTreeNodeParent()) {
            if (!lazyTreeNode2.getUserObject().equals(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isDuplicate() {
        return this._isDuplicate;
    }

    public void childAdded(Object object) {
        int n = this._isLoaded ? this._childNodes.size() : -1;
        this.childAdded(object, n);
    }

    private int getAddToIndex(Object object) {
        if (!this._isLoaded) {
            return -1;
        }
        if (!this._isSorted) {
            return this._childNodes.size();
        }
        return this.getSortedAddIndex(object);
    }

    private int getSortedAddIndex(Object object) {
        if (this._childNodes == null) {
            return -1;
        }
        int n = this._childNodes.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.get(i);
            if (this.compareTo(lazyTreeNode.getUserObject(), object) <= 0) continue;
            return i;
        }
        return n;
    }

    protected int compareTo(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return object == null ? 0 : 1;
        }
        if (object instanceof Frame) {
            return object2 instanceof Frame ? ((Frame)object).compareTo((Frame)object2) : ((Frame)object).getBrowserText().compareTo(object2.toString());
        }
        return object.toString().compareTo(object2.toString());
    }

    public void childAdded(Object object, int n) {
        if (this._isLoaded) {
            int n2 = this.getIndex(object);
            if (n2 != -1) {
                LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.get(n2);
                this.notifyChildNodeAdded(this, n2, lazyTreeNode);
            } else {
                LazyTreeNode lazyTreeNode = this.createNode(object);
                this._childNodes.add(n, lazyTreeNode);
                ++this._childCount;
                this.notifyChildNodeAdded(this, n, lazyTreeNode);
            }
        } else {
            this.ensureChildrenLoaded();
            this._childCount = this._childNodes.size();
            n = this.getIndex(object);
            if (n != -1) {
                LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.get(n);
                this.notifyChildNodeAdded(this, n, lazyTreeNode);
            }
        }
    }

    public void childRemoved(Object object) {
        if (this._childCount != -1) {
            --this._childCount;
        }
        if (this._isLoaded) {
            int n = this.getIndex(object);
            if (n < 0) {
                ++this._childCount;
            } else {
                LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.remove(n);
                lazyTreeNode.dispose();
                this.notifyChildNodeRemoved(this, n, lazyTreeNode);
            }
        }
    }

    public Enumeration children() {
        this.ensureChildrenLoaded();
        return Collections.enumeration(this._childNodes);
    }

    private void clearNodes() {
        if (this._childNodes != null) {
            this._childCount = 0;
            for (LazyTreeNode lazyTreeNode : this._childNodes) {
                lazyTreeNode.dispose();
            }
            this._childNodes.clear();
        }
    }

    private LazyTreeNode createErrorNode(Object object) {
        return new ErrorLazyTreeNode(this, object);
    }

    protected abstract LazyTreeNode createNode(Object var1);

    protected void dispose() {
        if (this._childNodes != null) {
            for (LazyTreeNode lazyTreeNode : this._childNodes) {
                lazyTreeNode.dispose();
            }
        }
    }

    private void ensureChildCountLoaded() {
        if (this._childCount == -1) {
            this._childCount = this.getChildObjectCount();
        }
    }

    private void ensureChildrenLoaded() {
        if (!this._isLoaded) {
            this.loadNodes();
            this._isLoaded = true;
        }
    }

    protected void setIsLoaded(boolean bl) {
        this._isLoaded = bl;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        this.ensureChildrenLoaded();
        if (n >= this._childNodes.size()) {
            n = this._childNodes.size() - 1;
        }
        return n == -1 ? null : (TreeNode)this._childNodes.get(n);
    }

    public int getChildCount() {
        this.ensureChildCountLoaded();
        return this._childCount;
    }

    protected abstract int getChildObjectCount();

    protected abstract Collection getChildObjects();

    protected abstract Comparator getComparator();

    public int getIndex(Object object) {
        int n = this._childNodes.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.get(i);
            if (!LazyTreeNode.equals(lazyTreeNode.getUserObject(), object)) continue;
            n2 = i;
        }
        return n2;
    }

    public int getIndex(TreeNode treeNode) {
        this.ensureChildrenLoaded();
        return this._childNodes.indexOf(treeNode);
    }

    public LazyTreeNode getLazyTreeNodeParent() {
        return this._parent;
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public int getUserObjectIndex(Object object) {
        this.ensureChildrenLoaded();
        int n = -1;
        int n2 = this._childNodes.size();
        for (int i = 0; i < n2; ++i) {
            LazyTreeNode lazyTreeNode = (LazyTreeNode)this._childNodes.get(i);
            if (!LazyTreeNode.equals(lazyTreeNode.getUserObject(), object)) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean isLeaf() {
        if (this.isDuplicate()) {
            return true;
        }
        this.ensureChildCountLoaded();
        return this._childCount == 0;
    }

    protected void loadChildObjects(Collection object) {
        Object object2;
        if (this._childNodes == null) {
            this._childNodes = new ArrayList();
        } else {
            this._childNodes.clear();
        }
        if (this._isSorted) {
            object2 = new ArrayList(object);
            Collections.sort(object2, this.getComparator());
            object = object2;
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            LazyTreeNode lazyTreeNode;
            Object e = object2.next();
            try {
                lazyTreeNode = this.createNode(e);
            }
            catch (Exception exception) {
                if (Log.getLogger().isLoggable(Level.FINE)) {
                    Log.getLogger().log(Level.FINE, "Exception caught ", exception);
                } else {
                    Log.getLogger().warning("Exception caught " + exception.toString());
                    Log.getLogger().warning(" For more information use fine logging");
                }
                lazyTreeNode = this.createErrorNode(e);
            }
            this._childNodes.add(lazyTreeNode);
        }
        this._childCount = this._childNodes.size();
    }

    private void loadNodes() {
        Collection collection = this.getChildObjects();
        this.loadChildObjects(collection);
    }

    public void notifyChildNodeAdded(LazyTreeNode lazyTreeNode, int n, LazyTreeNode lazyTreeNode2) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + lazyTreeNode2);
        } else {
            this._parent.notifyChildNodeAdded(lazyTreeNode, n, lazyTreeNode2);
        }
    }

    public void notifyChildNodeRemoved(LazyTreeNode lazyTreeNode, int n, LazyTreeNode lazyTreeNode2) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + lazyTreeNode2);
        } else {
            this._parent.notifyChildNodeRemoved(lazyTreeNode, n, lazyTreeNode2);
        }
    }

    public void notifyNodeChanged(LazyTreeNode lazyTreeNode) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + lazyTreeNode);
        } else {
            this._parent.notifyNodeChanged(lazyTreeNode);
        }
    }

    public void notifyNodeStructureChanged(LazyTreeNode lazyTreeNode) {
        if (this._parent == null) {
            Log.getLogger().warning("Notification message lost: " + lazyTreeNode);
        } else {
            this._parent.notifyNodeStructureChanged(lazyTreeNode);
        }
    }

    public void reload() {
        this.clearNodes();
        this.loadNodes();
        this.notifyNodeStructureChanged(this);
    }

    public void reload(Object object) {
        this._userObject = object;
        this.reload();
    }

    public String toString() {
        return "LazyTreeNode(" + this._userObject + ")";
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public boolean isSorted() {
        return this._isSorted;
    }
}

