/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionMonitor {
    private Map<RemoteSession, Integer> transactionsInProgress = new HashMap<RemoteSession, Integer>();

    public synchronized void beginTransaction() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        int n = this.getNesting();
        this.transactionsInProgress.put(remoteSession, n + 1);
    }

    public synchronized void rollbackTransaction() {
        this.decrementTransaction();
    }

    public synchronized void commitTransaction() {
        this.decrementTransaction();
    }

    private void decrementTransaction() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        int n = this.getNesting();
        if (n <= 0) {
            Log.getLogger().warning("Exiting a transaction when no transaction is in progress");
        } else if (n == 1) {
            this.transactionsInProgress.remove(remoteSession);
        } else {
            this.transactionsInProgress.put(remoteSession, n - 1);
        }
    }

    public synchronized boolean inTransaction() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        Integer n = this.transactionsInProgress.get(remoteSession);
        return n != null;
    }

    public synchronized boolean existsTransaction() {
        return !this.transactionsInProgress.isEmpty();
    }

    public synchronized boolean exclusiveTransaction() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        for (RemoteSession remoteSession2 : this.transactionsInProgress.keySet()) {
            int n = this.transactionsInProgress.get(remoteSession2);
            if (remoteSession2.equals(remoteSession) && n <= 0) {
                return false;
            }
            if (remoteSession2.equals(remoteSession) || n <= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized int getNesting() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        return this.getNesting(remoteSession);
    }

    public synchronized int getNesting(RemoteSession remoteSession) {
        Integer n = this.transactionsInProgress.get(remoteSession);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static boolean updatesSeenByUntransactedClients(TransactionMonitor transactionMonitor) {
        return transactionMonitor == null || transactionMonitor.updatesSeenByUntransactedClients();
    }

    public static boolean updatesSeenByUntransactedClients(TransactionMonitor transactionMonitor, TransactionIsolationLevel transactionIsolationLevel) {
        return transactionMonitor == null || transactionMonitor.updatesSeenByUntransactedClients(transactionIsolationLevel);
    }

    public boolean updatesSeenByUntransactedClients() {
        TransactionIsolationLevel transactionIsolationLevel = this.getTransationIsolationLevel();
        return this.updatesSeenByUntransactedClients(transactionIsolationLevel);
    }

    public boolean updatesSeenByUntransactedClients(TransactionIsolationLevel transactionIsolationLevel) {
        return !this.inTransaction() || transactionIsolationLevel != null && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0;
    }

    public synchronized Set<RemoteSession> getSessions() {
        return this.transactionsInProgress.keySet();
    }

    public abstract TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException;

    public abstract void setTransactionIsolationLevel(TransactionIsolationLevel var1) throws TransactionException;
}

