/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.serialize;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheModify<S, V, R>
extends SerializedCacheUpdate<S, V, R> {
    private V var;
    private CacheResult<R> newValue;

    public CacheModify(S s, V v, CacheResult<R> cacheResult) {
        super(s);
        this.var = v;
        this.newValue = cacheResult;
    }

    public V getVar() {
        return this.var;
    }

    public CacheResult<R> getNewValue() {
        return this.newValue;
    }

    @Override
    public void performUpdate(Cache<S, V, R> cache) {
        if (this.newValue.isValid()) {
            cache.modifyCache(this.getSession(), this.var, this.newValue.getResult());
        } else {
            cache.modifyCache(this.getSession(), this.var);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<CacheOp: Session ");
        stringBuffer.append(this.getSession());
        stringBuffer.append(" modifies var ");
        stringBuffer.append(this.getVar());
        stringBuffer.append(" to ");
        stringBuffer.append(this.getNewValue());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

