/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class StringListWidget
extends AbstractListWidget {
    private AllowableAction _createAction;
    private AllowableAction _removeAction;

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_ADD){

            public void onCreate() {
                StringListWidget.this.handleCreateAction();
            }
        };
        return this._createAction;
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){

            public void onView(Object object) {
                StringListWidget.this.handleViewAction((String)object);
            }
        };
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                StringListWidget.this.handleRemoveAction(collection);
            }
        };
        return this._removeAction;
    }

    protected void handleCreateAction() {
        String string = DisplayUtilities.editString(this, "Create String Value", null, null);
        if (string != null) {
            this.addItem(string);
        }
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(String string) {
        String string2 = DisplayUtilities.editString(this, "Edit String Value", string, null);
        if (string2 != null) {
            this.replaceItem(string, string2);
        }
    }

    public void initialize() {
        Action action = this.getEditAction();
        super.initialize(action);
        this.addButton(action);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = StringListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.STRING);
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl3;
        }
        return bl;
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        this._createAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
    }
}

