/*
 * #%L
 * Protempa Framework
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.protempa;

import org.apache.commons.lang3.exception.ExceptionUtils;

/**
 * Class for exceptions that are thrown when an error occurs while closing
 * a data, knowledge, algorithm or term source.
 *
 * @author Andrew Post
 *
 */
public final class SourceCloseException extends CloseException {

    SourceCloseException(BackendCloseException... exceptions) {
        super(exceptionsToString(exceptions));
    }

    private static String exceptionsToString(BackendCloseException[] causes) {
        StringBuilder stackTrace = new StringBuilder();
        for (BackendCloseException ex : causes) {
            stackTrace.append(ExceptionUtils.getStackTrace(ex));
        }
        
        return stackTrace.toString();
    }
}
