/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.DeleteFrameCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteClsCommand
extends DeleteFrameCommand {
    private Map<Slot, Collection> directTemplateSlotValues = new HashMap<Slot, Collection>();
    private Map<Slot, Map<Facet, Collection>> directTemplateSlotFacetValues = new HashMap<Slot, Map<Facet, Collection>>();

    public DeleteClsCommand(FrameStore frameStore, Cls cls) {
        super(frameStore, cls);
    }

    public Cls getCls() {
        return (Cls)this.getFrame();
    }

    protected void saveFrame() {
        super.saveFrame();
        this.saveCls();
    }

    protected void restoreFrame() {
        super.restoreFrame();
        this.restoreCls();
    }

    private void saveCls() {
        Cls cls = this.getCls();
        Set set = this.getDelegate().getTemplateSlots(cls);
        for (Slot slot : set) {
            List list = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
            if (list != null && !list.isEmpty()) {
                this.directTemplateSlotValues.put(slot, list);
            }
            HashMap<Facet, List> hashMap = new HashMap<Facet, List>();
            this.directTemplateSlotFacetValues.put(slot, hashMap);
            Set<Facet> set2 = this.getDelegate().getTemplateFacets(cls, slot);
            for (Facet facet : set2) {
                List list2 = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
                if (list2 == null || list2.isEmpty()) continue;
                hashMap.put(facet, list2);
            }
        }
    }

    private void restoreCls() {
        Cls cls = this.getCls();
        for (Map.Entry<Slot, Collection> entry : this.directTemplateSlotValues.entrySet()) {
            this.getDelegate().setDirectTemplateSlotValues(cls, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Slot, Object> entry : this.directTemplateSlotFacetValues.entrySet()) {
            Slot slot = entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.getDelegate().setDirectTemplateFacetValues(cls, slot, (Facet)entry2.getKey(), (Collection)entry2.getValue());
            }
        }
    }
}

