/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server_Test;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import junit.framework.TestCase;

public class ServerDelegationTest
extends TestCase {
    public static final String ADMIN_USER = "Admin";
    public static final String ADMIN_PASSWORD = "admin";
    private RemoteServer server;

    protected void setUp() throws Exception {
        super.setUp();
        Server_Test.startServer();
        this.server = (RemoteServer)Naming.lookup(Server_Test.NAME);
        this.server.reinitialize();
    }

    public void testSuccessfulDelegation() throws MalformedURLException, RemoteException, NotBoundException {
        if (!Server_Test.isServerRunning()) {
            return;
        }
        RemoteSession remoteSession = this.server.openSession(ADMIN_USER, "localhost", ADMIN_PASSWORD);
        ServerDelegationTest.assertTrue((boolean)remoteSession.allowDelegation());
        ServerDelegationTest.assertTrue((boolean)remoteSession.getUserName().equals(ADMIN_USER));
        ServerDelegationTest.assertTrue((boolean)remoteSession.getRealUserName().equals(ADMIN_USER));
        RemoteServerProject remoteServerProject = this.server.openProject("Newspaper", remoteSession);
        ServerDelegationTest.assertTrue((remoteServerProject == null ? 1 : 0) != 0);
        remoteSession.setDelegate("Ray Fergerson");
        ServerDelegationTest.assertTrue((boolean)remoteSession.getUserName().equals("Ray Fergerson"));
        ServerDelegationTest.assertTrue((boolean)remoteSession.getRealUserName().equals(ADMIN_USER));
        remoteServerProject = this.server.openProject("Newspaper", remoteSession);
        Project project = RemoteClientProject.createProject(this.server, remoteServerProject, remoteSession, false);
        ServerDelegationTest.assertTrue((project.getKnowledgeBase().getCls("Article").getInstanceCount() == 9 ? 1 : 0) != 0);
        project.dispose();
    }

    public void testFailedDelegation() throws MalformedURLException, RemoteException, NotBoundException {
        if (!Server_Test.isServerRunning()) {
            return;
        }
        RemoteSession remoteSession = this.server.openSession("Ray Fergerson", "localhost", "claudia");
        ServerDelegationTest.assertTrue((!remoteSession.allowDelegation() ? 1 : 0) != 0);
        ServerDelegationTest.assertTrue((boolean)remoteSession.getUserName().equals("Ray Fergerson"));
        ServerDelegationTest.assertTrue((boolean)remoteSession.getRealUserName().equals("Ray Fergerson"));
        boolean bl = false;
        try {
            remoteSession.setDelegate("Jennifer Vendetti");
        }
        catch (IllegalAccessError illegalAccessError) {
            bl = true;
        }
        ServerDelegationTest.assertTrue((boolean)bl);
    }

    static {
        Server_Test.setMetaProject("junit/pprj/policy/metaproject02.pprj");
    }
}

