/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;

public class DatabaseUtils {
    public static final String NULL_FRAME_ID_STRING = "";
    private static final int VALUE_TYPE_INTEGER = 1;
    private static final int VALUE_TYPE_FLOAT = 2;
    private static final int VALUE_TYPE_STRING = 3;
    private static final int VALUE_TYPE_BOOLEAN = 4;
    public static final int BASE_FRAME_TYPE_VALUE = 5;
    private static final char SINGLE_QUOTE = '\'';
    static boolean first = true;

    public static String getValue(FrameID frameID) {
        return frameID == null ? NULL_FRAME_ID_STRING : frameID.getName();
    }

    public static int getStringValueType() {
        return 3;
    }

    private static void setId(PreparedStatement preparedStatement, int n, Frame frame) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, DatabaseUtils.getId(frame));
    }

    private static FrameID getId(Frame frame) {
        return frame == null ? null : frame.getFrameID();
    }

    private static void setId(PreparedStatement preparedStatement, int n, FrameID frameID) throws SQLException {
        preparedStatement.setString(n, DatabaseUtils.getValue(frameID));
    }

    private static String getFrameIDValueString(FrameID frameID) {
        return frameID == null ? NULL_FRAME_ID_STRING : frameID.getName();
    }

    public static void setValueType(PreparedStatement preparedStatement, int n, Object object, FrameFactory frameFactory) throws SQLException {
        DatabaseUtils.setValueType(preparedStatement, n, DatabaseUtils.valueType(object, frameFactory));
    }

    public static void setValueType(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        preparedStatement.setInt(n, (short)n2);
    }

    public static int valueType(Object object, FrameFactory frameFactory) {
        int n = object instanceof String ? 3 : (object instanceof Integer ? 1 : (object instanceof Float ? 2 : (object instanceof Boolean ? 4 : frameFactory.getJavaClassId((Frame)object))));
        return n;
    }

    public static void setFrameId(PreparedStatement preparedStatement, int n, FrameID frameID) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, frameID);
    }

    public static void setFrame(PreparedStatement preparedStatement, int n, Frame frame) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, frame);
    }

    public static void setFrame(PreparedStatement preparedStatement, int n, int n2, Frame frame, FrameFactory frameFactory) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, frame);
        DatabaseUtils.setValueType(preparedStatement, n2, frame, frameFactory);
    }

    public static void setSlot(PreparedStatement preparedStatement, int n, Slot slot) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, slot);
    }

    public static void setFacet(PreparedStatement preparedStatement, int n, Facet facet) throws SQLException {
        DatabaseUtils.setId(preparedStatement, n, facet);
    }

    public static void setIsTemplate(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        preparedStatement.setBoolean(n, bl);
    }

    public static int getIsTemplateValue(boolean bl) {
        return bl ? 1 : 0;
    }

    public static void setValueIndex(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        preparedStatement.setInt(n, n2);
    }

    public static void setShortValue(PreparedStatement preparedStatement, int n, int n2, Object object, FrameFactory frameFactory) throws SQLException {
        preparedStatement.setString(n, DatabaseUtils.toString(object));
        DatabaseUtils.setValueType(preparedStatement, n2, object, frameFactory);
    }

    private static String toString(Object object) {
        Assert.assertNotNull("object", object);
        String string = object instanceof Frame ? DatabaseUtils.getFrameIDValueString(((Frame)object).getFrameID()) : object.toString();
        return string;
    }

    public static void setShortMatchValue(PreparedStatement preparedStatement, int n, int n2, String string, char c) throws SQLException {
        preparedStatement.setString(n, DatabaseUtils.getMatchString(string, c));
        DatabaseUtils.setValueType(preparedStatement, n2, 3);
    }

    private static void setNullShortValue(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (DatabaseUtils.isJdbcOdbcBridge(preparedStatement)) {
            preparedStatement.setString(n, NULL_FRAME_ID_STRING);
        } else {
            preparedStatement.setNull(n, 12);
        }
        DatabaseUtils.setValueType(preparedStatement, n2, 3);
    }

    private static boolean isJdbcOdbcBridge(Statement statement) {
        return statement.getClass().getName().startsWith("sun.jdbc.odbc.JdbcOdbcPreparedStatement");
    }

    public static void setLongValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        preparedStatement.setString(n, DatabaseUtils.toString(object));
    }

    public static void setNullLongValue(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setNull(n, -1);
    }

    public static void setValue(PreparedStatement preparedStatement, int n, int n2, int n3, Object object, int n4, FrameFactory frameFactory) throws SQLException {
        if (DatabaseUtils.isShortValue(object, n4)) {
            DatabaseUtils.setShortValue(preparedStatement, n, n3, object, frameFactory);
            DatabaseUtils.setNullLongValue(preparedStatement, n2);
        } else {
            DatabaseUtils.setNullShortValue(preparedStatement, n, n3);
            DatabaseUtils.setLongValue(preparedStatement, n2, object);
        }
    }

    public static String getMatchString(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            c2 = Character.toUpperCase(c2);
            if (c != '\u0000' && (c2 == '%' || c2 == '_' || c2 == c)) {
                stringBuffer.append(c);
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '\'') {
                stringBuffer.append('\'');
                stringBuffer.append('\'');
                continue;
            }
            if (c2 == '*') {
                stringBuffer.append('%');
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c2));
        }
        return stringBuffer.toString();
    }

    private static boolean isShortValue(Object object, int n) {
        boolean bl = object instanceof String ? ((String)object).length() <= n : true;
        return bl;
    }

    public static Frame getFrame(ResultSet resultSet, int n, int n2, FrameFactory frameFactory, boolean bl) throws SQLException {
        FrameID frameID = DatabaseUtils.getFrameId(resultSet, n);
        int n3 = resultSet.getInt(n2);
        return DatabaseUtils.getFrame(frameID, n3, frameFactory, bl);
    }

    private static Frame getFrame(FrameID frameID, int n, FrameFactory frameFactory, boolean bl) {
        if (frameID == null) {
            return null;
        }
        Frame frame = frameFactory.createFrameFromClassId(n, frameID);
        if (bl) {
            frame.setIncluded(true);
        }
        return frame;
    }

    private static FrameID getFrameId(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        if (string.equals(NULL_FRAME_ID_STRING)) {
            return null;
        }
        return new FrameID(string);
    }

    public static Slot getSlot(ResultSet resultSet, int n, FrameFactory frameFactory, boolean bl) throws SQLException {
        List list = Collections.EMPTY_LIST;
        FrameID frameID = DatabaseUtils.getFrameId(resultSet, n);
        Slot slot = frameFactory.createSlot(frameID, list);
        if (bl) {
            slot.setIncluded(bl);
        }
        return slot;
    }

    public static Facet getFacet(ResultSet resultSet, int n, FrameFactory frameFactory, boolean bl) throws SQLException {
        Facet facet;
        List list = Collections.EMPTY_LIST;
        FrameID frameID = DatabaseUtils.getFrameId(resultSet, n);
        if (frameID == null) {
            facet = null;
        } else {
            facet = frameFactory.createFacet(frameID, list);
            if (bl) {
                facet.setIncluded(true);
            }
        }
        return facet;
    }

    public static Object getShortValue(ResultSet resultSet, int n, int n2, FrameFactory frameFactory, int n3, boolean bl) throws SQLException {
        Object object;
        byte by = resultSet.getByte(n2);
        String string = resultSet.getString(n);
        switch (by) {
            case 1: {
                object = Integer.valueOf(string);
                break;
            }
            case 2: {
                object = Float.valueOf(string);
                break;
            }
            case 4: {
                object = Boolean.valueOf(string);
                break;
            }
            case 3: {
                object = string;
                if (string == null || string.length() != 0) break;
                object = null;
                break;
            }
            default: {
                FrameID frameID = new FrameID(string);
                object = DatabaseUtils.getFrame(frameID, by, frameFactory, bl);
            }
        }
        return object;
    }

    public static Object getLongValue(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getString(n);
    }

    public static int getIndex(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getInt(n);
    }

    public static boolean getIsTemplate(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getBoolean(n);
    }

    public static void setFrameType(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        DatabaseUtils.setValueType(preparedStatement, n, n2);
    }
}

