/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database.pool;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class ConnectionInfo {
    private Connection connection;
    private long lastAccessTime;
    private Map<String, PreparedStatement> preparedStatementMap = new HashMap<String, PreparedStatement>();
    private Statement genericStatement;

    public ConnectionInfo(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.preparedStatementMap.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.connection.prepareStatement(string);
            this.preparedStatementMap.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    public synchronized Statement getStatement() throws SQLException {
        if (this.genericStatement == null) {
            this.genericStatement = this.connection.createStatement();
        }
        return this.genericStatement;
    }

    public void close() throws SQLException {
        this.closeStatements();
        this.connection.close();
    }

    public synchronized void closeStatements() throws SQLException {
        for (PreparedStatement preparedStatement : this.preparedStatementMap.values()) {
            preparedStatement.close();
        }
        this.preparedStatementMap.clear();
        if (this.genericStatement != null) {
            this.genericStatement.close();
            this.genericStatement = null;
        }
    }
}

