/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameWithBrowserText
implements Serializable,
Localizable {
    private static final long serialVersionUID = -8597023478383674378L;
    private Frame frame;
    private String browserText;
    private Collection<Cls> types;
    private String iconName;

    public FrameWithBrowserText(Frame frame) {
        this(frame, null);
    }

    public FrameWithBrowserText(Frame frame, String string) {
        this(frame, string, null, null);
    }

    public FrameWithBrowserText(Frame frame, String string, Collection<Cls> collection) {
        this(frame, string, collection, null);
    }

    public FrameWithBrowserText(Frame frame, String string, Collection<Cls> arrayList, String string2) {
        this.frame = frame;
        this.browserText = string == null ? frame.getName() : string;
        this.types = arrayList == null ? new ArrayList() : arrayList;
        this.iconName = string2;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public String getBrowserText() {
        return this.browserText;
    }

    public void setBrowserText(String string) {
        this.browserText = string;
    }

    public Collection<Cls> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<Cls> collection) {
        this.types = collection;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String string) {
        this.iconName = string;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this.frame, knowledgeBase);
        LocalizeUtils.localize(this.types, knowledgeBase);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FrameWithBrowserText)) {
            return false;
        }
        FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)object;
        return frameWithBrowserText.getFrame() == null ? false : frameWithBrowserText.getFrame().equals(this.frame);
    }

    public int hashCode() {
        return this.frame == null ? 42 : this.frame.getName().length() * 43 + 7 * this.browserText.length() + 5 * this.types.size() + 3;
    }

    public static Collection<FrameWithBrowserText> getFramesWithBrowserText(Collection<? extends Frame> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<FrameWithBrowserText> arrayList = new ArrayList<FrameWithBrowserText>();
        for (Frame frame : collection) {
            FrameWithBrowserText frameWithBrowserText = FrameWithBrowserText.getFrameWithBrowserText(frame);
            if (frameWithBrowserText == null) continue;
            arrayList.add(frameWithBrowserText);
        }
        return arrayList;
    }

    public static FrameWithBrowserText getFrameWithBrowserText(Frame frame) {
        if (frame == null) {
            return null;
        }
        return new FrameWithBrowserText(frame, frame.getBrowserText(), frame instanceof Instance ? ((Instance)frame).getDirectTypes() : null);
    }

    public static Collection<Frame> getFrames(Collection<FrameWithBrowserText> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (FrameWithBrowserText frameWithBrowserText : collection) {
            Frame frame = frameWithBrowserText.getFrame();
            if (frame == null) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }
}

