/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Rectangle;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapUtil {
    private static final String MAP_CLASS = "Map";
    private static final String ENTRIES_SLOT = "entries";
    private static final String REFERENCED_MAPS_SLOT = "referenced_maps";
    private static final String MAP_ENTRY_CLASS = "Map_Entry";
    private static final String KEY_SLOT = "key";
    private static final String KEY_CLASS_SLOT = "key_class";
    private static final String VALUE_SLOT = "value";
    private static final String VALUE_CLASS_SLOT = "value_class";
    private static KnowledgeBase _domainKB;
    private static KnowledgeBase _projectKB;
    private static Map _valuesToMaps;

    private static Instance createEntryInstance(Instance instance) {
        Cls cls = _projectKB.getCls(MAP_ENTRY_CLASS);
        Instance instance2 = _projectKB.createInstance(null, cls);
        ModelUtilities.addOwnSlotValue(instance, ENTRIES_SLOT, instance2);
        return instance2;
    }

    private static Instance createMapInstance() {
        Cls cls = _projectKB.getCls(MAP_CLASS);
        return _projectKB.createInstance(null, cls);
    }

    public static void emptyMapInstance(Instance instance) {
    }

    private static Entry getEntry(Object object) {
        Entry entry = null;
        if (object instanceof Frame) {
            Frame frame = (Frame)object;
            if (!frame.isDeleted()) {
                entry = new Entry(frame.getName(), Frame.class);
            }
        } else {
            entry = object instanceof Rectangle ? new Entry(PropertyMapUtil.rectToString((Rectangle)object), Rectangle.class) : (object instanceof Map ? new Entry(PropertyMapUtil.mapToString((Map)object), Map.class) : (object instanceof Class ? new Entry(((Class)object).getName(), Class.class) : new Entry(object.toString(), object.getClass())));
        }
        return entry;
    }

    private static Object getFrame(String string) {
        Frame frame = _domainKB.getFrame(string);
        if (frame == null) {
            Log.getLogger().warning("unable to load frame: " + string);
        }
        return frame;
    }

    private static Object getJavaClass(String string) {
        Class clazz = SystemUtilities.forName(string);
        if (clazz == null) {
            Log.getLogger().warning("unable to load class: " + string);
        }
        return clazz;
    }

    private static Object getJavaClassObject(String string, String string2) {
        Object var2_2 = null;
        Class clazz = SystemUtilities.forName(string, true);
        if (clazz == null) {
            Log.getLogger().warning("Unable to load class: " + string);
        } else {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                if (constructor == null) {
                    Log.getLogger().warning("Class has no string constructor" + string);
                } else {
                    var2_2 = constructor.newInstance(string2);
                }
            }
            catch (Exception exception) {
                Log.getLogger().warning(exception.getMessage());
            }
        }
        return var2_2;
    }

    private static Object getMap(String string) {
        HashMap hashMap = (HashMap)_valuesToMaps.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            _valuesToMaps.put(string, hashMap);
            Instance instance = _projectKB.getInstance(string);
            if (instance == null) {
                Log.getLogger().warning("Missing map instance: " + string);
            } else {
                PropertyMapUtil.load(hashMap, instance);
            }
        }
        return hashMap;
    }

    private static Object getRectangle(String string) {
        Rectangle rectangle;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.nextToken();
            int n = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n3 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n4 = (int)streamTokenizer.nval;
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.getMessage());
            rectangle = null;
        }
        return rectangle;
    }

    private static Object getSlotValue(Instance instance, String string) {
        return ModelUtilities.getDirectOwnSlotValue(instance, string);
    }

    private static void setSlotValue(Instance instance, String string, Object object) {
        ModelUtilities.setOwnSlotValue(instance, string, object);
    }

    private static Collection getSlotValues(Instance instance, String string) {
        return ModelUtilities.getDirectOwnSlotValues(instance, string);
    }

    public static Map load(Instance instance, KnowledgeBase knowledgeBase) {
        _domainKB = knowledgeBase;
        _projectKB = instance.getKnowledgeBase();
        _valuesToMaps.clear();
        HashMap hashMap = new HashMap();
        PropertyMapUtil.load(hashMap, instance);
        return hashMap;
    }

    private static void load(Map map, Instance instance) {
        for (Instance instance2 : new ArrayList(PropertyMapUtil.getSlotValues(instance, ENTRIES_SLOT))) {
            boolean bl = PropertyMapUtil.loadEntry(map, instance2);
            if (bl) continue;
            PropertyMapUtil.removeSlotValue(instance, ENTRIES_SLOT, instance2);
        }
    }

    private static boolean loadEntry(Map map, Instance instance) {
        boolean bl;
        Object object = PropertyMapUtil.loadObject(instance, KEY_SLOT, KEY_CLASS_SLOT);
        Object object2 = PropertyMapUtil.loadObject(instance, VALUE_SLOT, VALUE_CLASS_SLOT);
        if (object == null || object2 == null) {
            bl = false;
        } else {
            map.put(object, object2);
            bl = true;
        }
        return bl;
    }

    private static Object loadObject(Instance instance, String string, String string2) {
        String string3 = (String)PropertyMapUtil.getSlotValue(instance, string);
        String string4 = (String)PropertyMapUtil.getSlotValue(instance, string2);
        Object object = string4.equals(Frame.class.getName()) ? PropertyMapUtil.getFrame(string3) : (string4.equals(Map.class.getName()) ? PropertyMapUtil.getMap(string3) : (string4.equals(Rectangle.class.getName()) ? PropertyMapUtil.getRectangle(string3) : (string4.equals(Class.class.getName()) ? PropertyMapUtil.getJavaClass(string3) : PropertyMapUtil.getJavaClassObject(string4, string3))));
        return object;
    }

    private static String mapToString(Map map) {
        Instance instance = PropertyMapUtil.createMapInstance();
        _valuesToMaps.put(instance.getName(), map);
        PropertyMapUtil.storeMap(map, instance);
        return instance.getName();
    }

    private static String rectToString(Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rectangle.x);
        stringBuffer.append(' ');
        stringBuffer.append(rectangle.y);
        stringBuffer.append(' ');
        stringBuffer.append(rectangle.width);
        stringBuffer.append(' ');
        stringBuffer.append(rectangle.height);
        return stringBuffer.toString();
    }

    private static void removeSlotValue(Instance instance, String string, Object object) {
        ModelUtilities.removeOwnSlotValue(instance, string, object);
    }

    private static void saveReferencedMaps(Instance instance) {
        for (String string : _valuesToMaps.keySet()) {
            Instance instance2 = _projectKB.getInstance(string);
            ModelUtilities.addOwnSlotValue(instance, REFERENCED_MAPS_SLOT, instance2);
        }
    }

    public static void store(Map map, Instance instance) {
        Object var2_2 = null;
        _projectKB = instance.getKnowledgeBase();
        _domainKB = var2_2;
        _valuesToMaps.clear();
        PropertyMapUtil.deleteMapEntries(instance);
        PropertyMapUtil.storeMap(map, instance);
        PropertyMapUtil.saveReferencedMaps(instance);
    }

    private static void deleteMapEntries(Instance instance) {
        for (Instance instance2 : PropertyMapUtil.getSlotValues(instance, ENTRIES_SLOT)) {
            PropertyMapUtil.deleteMapEntry(instance2);
        }
        PropertyMapUtil.setSlotValue(instance, ENTRIES_SLOT, null);
    }

    private static void deleteMapEntry(Instance instance) {
        String string = (String)PropertyMapUtil.getSlotValue(instance, VALUE_CLASS_SLOT);
        if (string.equals(Map.class.getName())) {
            String string2 = (String)PropertyMapUtil.getSlotValue(instance, VALUE_SLOT);
            Instance instance2 = instance.getKnowledgeBase().getInstance(string2);
            if (instance2 != null) {
                PropertyMapUtil.deleteMapEntries(instance2);
                instance2.delete();
            }
        }
        instance.delete();
    }

    private static void storeMap(Map map, Instance instance) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null) {
                Log.getLogger().warning("Unable to store null");
                continue;
            }
            PropertyMapUtil.storeMapEntry(k, v, instance);
        }
    }

    private static void storeMapEntry(Object object, Object object2, Instance instance) {
        Entry entry = PropertyMapUtil.getEntry(object);
        Entry entry2 = PropertyMapUtil.getEntry(object2);
        if (entry != null && entry2 != null) {
            Instance instance2 = PropertyMapUtil.createEntryInstance(instance);
            ModelUtilities.setOwnSlotValue(instance2, KEY_SLOT, entry.value);
            ModelUtilities.setOwnSlotValue(instance2, KEY_CLASS_SLOT, entry.valueClass);
            ModelUtilities.setOwnSlotValue(instance2, VALUE_SLOT, entry2.value);
            ModelUtilities.setOwnSlotValue(instance2, VALUE_CLASS_SLOT, entry2.valueClass);
        }
    }

    public static void dispose() {
        _valuesToMaps.clear();
        _domainKB = null;
        _projectKB = null;
    }

    static {
        _valuesToMaps = new HashMap();
    }

    private static class Entry {
        private String value;
        String valueClass;

        Entry(String string, Class clazz) {
            this.value = string;
            this.valueClass = clazz.getName();
        }

        public String toString() {
            return this.value;
        }
    }
}

