/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.util.URIUtilities;
import java.util.Set;

public class Policy_Test
extends SimpleTestCase {
    public static final String METAPROJECT = "junit/pprj/policy/metaproject.pprj";
    public static final String PROJECT1 = "Newspaper";
    public static final String NATASHA = "Natasha Noy";
    public static final String BOB = "Bob";
    public static final String PAUL = "Paul";
    public static final String DOUBLEO = "Bond, James Bond";
    public static final Operation RESTART = new UnbackedOperationImpl("RestartServer", null);
    public static final Operation SELF_DESTRUCT = new UnbackedOperationImpl("DestroyInstallationToProtectAgents", null);
    public static final Operation KILL = new UnbackedOperationImpl("LicensedKill", null);

    public static void checkAuthorization(Policy policy, String string, Operation operation, String string2, boolean bl) {
        User user = policy.getUserByName(string);
        ProjectInstance projectInstance = policy.getProjectInstanceByName(string2);
        Policy_Test.checkAuthorization(policy, user, operation, projectInstance, bl);
    }

    public static void checkAuthorization(Policy policy, User user, Operation operation, ProjectInstance projectInstance, boolean bl) {
        Set<Operation> set = policy.getAllowedOperations(user, projectInstance);
        if (bl) {
            Policy_Test.assertTrue((boolean)policy.isOperationAuthorized(user, operation, projectInstance));
            Policy_Test.assertTrue((boolean)set.contains(operation));
        } else {
            Policy_Test.assertFalse((boolean)policy.isOperationAuthorized(user, operation, projectInstance));
            Policy_Test.assertFalse((boolean)set.contains(operation));
        }
    }

    public void testPolicy01() {
        MetaProjectImpl metaProjectImpl = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        Policy policy = metaProjectImpl.getPolicy();
        Policy_Test.checkAuthorization(policy, NATASHA, MetaProjectConstants.OPERATION_WRITE, PROJECT1, true);
        Policy_Test.checkAuthorization(policy, BOB, MetaProjectConstants.OPERATION_WRITE, PROJECT1, false);
        Policy_Test.checkAuthorization(policy, PAUL, MetaProjectConstants.OPERATION_WRITE, PROJECT1, false);
        Policy_Test.checkAuthorization(policy, PAUL, KILL, PROJECT1, false);
        Policy_Test.checkAuthorization(policy, PAUL, RESTART, PROJECT1, true);
        Policy_Test.checkAuthorization(policy, DOUBLEO, KILL, PROJECT1, true);
        Policy_Test.checkAuthorization(policy, DOUBLEO, SELF_DESTRUCT, PROJECT1, true);
        Policy_Test.checkAuthorization(policy, DOUBLEO, MetaProjectConstants.OPERATION_WRITE, PROJECT1, false);
    }
}

