/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.ParentChildNodeComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ParentChildNode
extends LazyTreeNode {
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ParentChildNode.this.childAdded(clsEvent.getSubclass());
            }
        }

        public void directSubclassRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ParentChildNode.this.childRemoved(clsEvent.getSubclass());
            }
        }

        public void directSubclassMoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            Cls cls = clsEvent.getSubclass();
            int n = new ArrayList(ParentChildNode.this.getChildObjects()).indexOf(cls);
            if (n != -1) {
                ParentChildNode.this.childRemoved(cls);
                ParentChildNode.this.childAdded(cls, n);
            }
        }

        public void directInstanceAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void frameReplaced(FrameEvent frameEvent) {
            Frame frame = frameEvent.getFrame();
            Frame frame2 = frameEvent.getNewFrame();
            Cls cls = ParentChildNode.this.getCls();
            if (cls != null && cls.equals(frame)) {
                ParentChildNode.this.reload(frame2);
            }
        }

        public void browserTextChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            if (frameEvent.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ParentChildNode.this.getCls().getKnowledgeBase().getCls(ParentChildNode.this.getCls().getName());
                ParentChildNode.this.reload(cls);
            } else {
                ParentChildNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            ParentChildNode.this.notifyNodeChanged();
        }
    };

    public ParentChildNode(LazyTreeNode lazyTreeNode, Cls cls) {
        super(lazyTreeNode, cls, lazyTreeNode.isSorted());
        cls.addClsListener(this._clsListener);
        cls.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object object) {
        return new ParentChildNode((LazyTreeNode)this, (Cls)object);
    }

    protected void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        this.getCls().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        return this.showHidden() ? this.getCls().getDirectSubclassCount() : this.getCls().getVisibleDirectSubclassCount();
    }

    protected Collection getChildObjects() {
        return this.showHidden() ? this.getCls().getDirectSubclasses() : this.getCls().getVisibleDirectSubclasses();
    }

    protected Cls getCls() {
        return (Cls)this.getUserObject();
    }

    protected Comparator getComparator() {
        return new ParentChildNodeComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    public String toString() {
        return "ParentChildNode(" + this.getCls() + ")";
    }
}

