/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.WidgetEventDispatcher;
import edu.stanford.smi.protege.event.WidgetListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.AbstractWidget;
import edu.stanford.smi.protege.widget.ClsWidget;

public abstract class AbstractClsWidget
extends AbstractWidget
implements ClsWidget {
    private static final long serialVersionUID = -3827881889241261768L;
    private Cls _cls;
    private Cls _associatedCls;
    private Instance _instance;
    private ListenerCollection _widgetListeners = new ListenerList(new WidgetEventDispatcher());
    private FrameListener _instanceListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            AbstractClsWidget.this.handleOwnSlotValueChanged(frameEvent.getSlot());
        }

        public void browserTextChanged(FrameEvent frameEvent) {
            AbstractClsWidget.this.handleBrowserTextChanged();
        }
    };

    public void dispose() {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
    }

    public Instance getInstance() {
        return this._instance;
    }

    public void postWidgetEvent(int n) {
        this._widgetListeners.postEvent(this, n);
    }

    public void addWidgetListener(WidgetListener widgetListener) {
        this._widgetListeners.add(this, widgetListener);
    }

    public void removeWidgetListener(WidgetListener widgetListener) {
        this._widgetListeners.remove(this, widgetListener);
    }

    public void setup(WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls) {
        super.setup(widgetDescriptor, bl, project);
        this._cls = cls;
    }

    protected void handleBrowserTextChanged() {
        this.postWidgetEvent(1);
    }

    protected void handleFrameNameChanged() {
        this.postWidgetEvent(1);
    }

    public Cls getCls() {
        return this._cls;
    }

    public Cls getAssociatedCls() {
        return this._associatedCls;
    }

    public void setAssociatedCls(Cls cls) {
        this._associatedCls = cls;
    }

    public void setInstance(Instance instance) {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        this._instance = instance;
        if (this._instance != null) {
            this._instance.addFrameListener(this._instanceListener);
        }
    }

    protected void handleOwnSlotValueChanged(Slot slot) {
        AbstractSlotWidget abstractSlotWidget = (AbstractSlotWidget)this.getSlotWidget(slot);
        if (abstractSlotWidget != null) {
            abstractSlotWidget.loadValues();
        }
    }
}

