/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.JournalFormater;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.model.query.QueryCallbackClone;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JournalingFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    public static final String journaller_name = "protege.journal";
    private Logger journaler;
    private Handler handler;
    private boolean recordQueries = false;

    public void start(URI uRI) {
        try {
            this.stop();
            this.handler = new FileHandler(new File(uRI).getPath(), true);
            this.journaler = Logger.getLogger(journaller_name);
            this.journaler.setUseParentHandlers(false);
            this.journaler.addHandler(this.handler);
            this.journaler.setLevel(Level.ALL);
            this.handler.setFormatter(new JournalFormater());
            this.handler.setLevel(Level.ALL);
        }
        catch (IOException iOException) {
            Log.getLogger().throwing("JournalingFrameStoreHandler", "start", iOException);
        }
    }

    public void stop() {
        if (this.handler != null) {
            this.journaler.removeHandler(this.handler);
            this.handler.flush();
            this.handler.close();
            this.handler = null;
        }
        this.journaler = null;
    }

    public void handleClose() {
        this.stop();
    }

    public Object handleInvoke(Method method, Object[] objectArray) {
        Object object = this.invoke(method, objectArray);
        if (this.doRecord(method)) {
            this.record(method, objectArray, object);
        }
        return object;
    }

    public void executeQuery(Query query, QueryCallback queryCallback) {
        QueryCallback queryCallback2 = queryCallback;
        if (this.recordQueries) {
            queryCallback2 = new QueryCallbackClone(queryCallback){

                public void provideQueryResults(Set<Frame> set) {
                    JournalingFrameStoreHandler.this.journaler.info("Query Callback returning results");
                    super.provideQueryResults(set);
                }
            };
        }
        this.getDelegate().executeQuery(query, queryCallback2);
        if (this.recordQueries) {
            this.journaler.info("Executing query " + query + " (callback may log entry before this log)");
        }
    }

    protected void record(Method method, Object[] objectArray, Object object) {
        int n = objectArray == null ? 2 : objectArray.length + 2;
        Object[] objectArray2 = new Object[n];
        objectArray2[0] = method;
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        }
        objectArray2[n - 1] = object;
        this.journaler.log(Level.INFO, "entry", objectArray2);
    }

    protected boolean doRecord(Method method) {
        return this.journaler != null && (this.recordQueries || JournalingFrameStoreHandler.isModification(method));
    }
}

