/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileField
extends JComponent {
    private JTextField _textField;
    private String _description;
    private String _extension;
    private ExtensionFilter _extensionFilter;
    private ChangeListener _changeListener;
    private int _fileMode;
    private int _dialogType = 0;

    public FileField(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, 0);
    }

    public FileField(String string, String string2, ExtensionFilter extensionFilter) {
        this(string, string2, "", "", 0);
        this._extensionFilter = extensionFilter;
    }

    public FileField(String string, String string2, String string3) {
        this(string, string2, "", string3, 1);
    }

    public void setDialogType(int n) {
        this._dialogType = n;
    }

    private FileField(String string, String string2, String string3, String string4, int n) {
        this._fileMode = n;
        this._description = string4;
        this._extension = string3;
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent(string, this.createComponent(string2));
        labeledComponent.addHeaderButton(new AbstractAction("Browse for File", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                FileField.this.browse();
            }
        });
        this.add(labeledComponent);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Assert.assertNull("existing change listener", this._changeListener);
        this._changeListener = changeListener;
    }

    protected void browse() {
        JFileChooser jFileChooser = this._extensionFilter == null ? ComponentFactory.createFileChooser(this._description, this._extension) : ComponentFactory.createFileChooser(null, this._extensionFilter);
        jFileChooser.setApproveButtonText("Select");
        jFileChooser.setFileSelectionMode(this._fileMode);
        jFileChooser.setDialogType(this._dialogType);
        int n = jFileChooser.showDialog(this, "Select");
        switch (n) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this._textField.setText(jFileChooser.getSelectedFile().getPath());
                break;
            }
            default: {
                Assert.fail("bad result: " + n);
            }
        }
    }

    private JComponent createComponent(String string) {
        this._textField = ComponentFactory.createTextField();
        this._textField.setColumns(40);
        if ((string == null || string.length() == 0) && this._fileMode == 1) {
            string = SystemUtilities.getUserDirectory();
        }
        this._textField.setText(string);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FileField.this.notifyListener();
            }
        });
        return this._textField;
    }

    public String getPath() {
        String string = this._textField.getText();
        if (string.length() == 0) {
            string = null;
        } else {
            try {
                string = new File(string).getAbsolutePath();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string;
    }

    public File getFilePath() {
        String string = this.getPath();
        return string == null ? null : new File(string);
    }

    private void notifyListener() {
        if (this._changeListener != null) {
            this._changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setPath(String string) {
        this._textField.setText(string);
    }
}

