/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Properties;

public class FileUtilities {
    public static final char EXTENSION_SEPARATOR = '.';
    private static final String TEMP_EXTENSION = ".tmp";
    private static String _readEncodingOverride;
    private static String _writeEncodingOverride;
    private static final int READ_BUFFER_SIZE = 1000000;
    private static final int WRITE_BUFFER_SIZE = 1000000;

    public static File createTempFile(File file) throws IOException {
        File file2 = null;
        if (file != null) {
            if (file.exists() && !file.canWrite()) {
                throw new IOException("Cannot write to " + file + ".  Perhaps it is write-protected");
            }
            file2 = new File(file.toString() + TEMP_EXTENSION);
        }
        return file2;
    }

    public static String getAbsolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static String getAbsolutePath(String string, Project project) {
        URI uRI = project.getProjectDirectoryURI();
        File file = uRI == null ? new File(string) : new File(new File(uRI), string);
        return file.getAbsolutePath();
    }

    public static String getName(String string) {
        return string == null ? null : new File(string).getName();
    }

    public static String getBaseName(String string) {
        return FileUtilities.getBaseName(new File(string));
    }

    public static String getBaseName(File file) {
        String string = null;
        if (file != null) {
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n == -1) {
                n = string2.length();
            }
            string = string2.substring(0, n);
        }
        return string;
    }

    public static String replaceExtension(String string, String string2) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + string2;
        }
        return string;
    }

    public static String ensureExtension(String string, String string2) {
        if (string != null && !string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    public static BufferedReader createBufferedReader(String string) {
        return FileUtilities.createBufferedReader(new File(string));
    }

    public static BufferedReader createBufferedReader(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(FileUtilities.createReader(file), 1000000);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferedReader;
    }

    public static BufferedWriter createBufferedWriter(File file, boolean bl) {
        BufferedWriter bufferedWriter = null;
        if (file != null) {
            try {
                bufferedWriter = new BufferedWriter(FileUtilities.createWriter(file, bl), 1000000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedWriter;
    }

    public static BufferedWriter createBufferedWriter(String string) {
        return FileUtilities.createBufferedWriter(new File(string));
    }

    public static BufferedWriter createBufferedWriter(File file) {
        return FileUtilities.createBufferedWriter(file, false);
    }

    private static Reader createReader(File file) throws IOException {
        return FileUtilities.createInputStreamReader(new FileInputStream(file));
    }

    private static Writer createWriter(File file, boolean bl) throws IOException {
        return FileUtilities.createOutputStreamWriter(new FileOutputStream(file, bl));
    }

    public static BufferedReader createBufferedReader(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            try {
                bufferedReader = new BufferedReader(FileUtilities.createInputStreamReader(inputStream), 1000000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedReader;
    }

    private static OutputStreamWriter createOutputStreamWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return new OutputStreamWriter(outputStream, FileUtilities.getWriteEncoding());
    }

    private static InputStreamReader createInputStreamReader(InputStream inputStream) throws UnsupportedEncodingException {
        return new InputStreamReader(inputStream, FileUtilities.getReadEncoding());
    }

    public static PrintWriter createPrintWriter(File file, boolean bl) {
        PrintWriter printWriter = null;
        if (file != null) {
            BufferedWriter bufferedWriter = FileUtilities.createBufferedWriter(file);
            printWriter = new PrintWriter((Writer)bufferedWriter, bl);
        }
        return printWriter;
    }

    public static Writer getWriter(String string) {
        return string == null ? null : FileUtilities.createBufferedWriter(new File(string), false);
    }

    public static Reader getReader(String string) {
        return FileUtilities.createBufferedReader(new File(string));
    }

    public static Reader getResourceReader(Class clazz, String string) {
        InputStream inputStream = FileUtilities.getResourceStream(clazz, string);
        BufferedReader bufferedReader = inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream), 1000000);
        return bufferedReader;
    }

    public static Reader getResourceReader(Class clazz, String string, String string2) {
        return FileUtilities.getResourceReader(clazz, string + "/" + string2);
    }

    public static InputStream getResourceStream(Class clazz, String string) {
        Assert.assertNotNull("class", clazz);
        Assert.assertNotNull("path", string);
        return clazz.getResourceAsStream(string);
    }

    public static InputStream getResourceStream(Class clazz, String string, String string2) {
        return FileUtilities.getResourceStream(clazz, string + "/" + string2);
    }

    public static void makeTempFilePermanent(File file) throws IOException {
        if (file != null) {
            String string = file.toString();
            if (string.endsWith(TEMP_EXTENSION)) {
                String string2 = string.substring(0, string.length() - TEMP_EXTENSION.length());
                FileUtilities.replaceFile(file, new File(string2));
            } else {
                throw new IOException("Not a temporary file: " + file);
            }
        }
    }

    public static void replaceFile(File file, File file2) throws IOException {
        if (file2.exists()) {
            if (!file2.canWrite()) {
                throw new IOException("Cannot write to file " + file2 + ".  It may be write-protected.");
            }
            if (!file2.delete()) {
                throw new IOException("Delete of existing " + file2 + " failed");
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Rename of " + file + " to " + file2 + " failed");
        }
    }

    public static void setReadEncodingOverride(String string) {
        _readEncodingOverride = string;
    }

    public static void setWriteEncodingOverride(String string) {
        _writeEncodingOverride = string;
    }

    public static String getReadEncodingOverride() {
        return _readEncodingOverride;
    }

    public static String getReadEncoding() {
        return _readEncodingOverride == null ? FileUtilities.getEncoding() : _readEncodingOverride;
    }

    public static String getWriteEncoding() {
        return _writeEncodingOverride == null ? FileUtilities.getEncoding() : _writeEncodingOverride;
    }

    public static String getEncoding() {
        return SystemUtilities.getFileEncoding();
    }

    public static String replaceFileName(String string, String string2) {
        int n = string.lastIndexOf(File.separatorChar);
        return string.substring(0, n + 1) + string2;
    }

    public static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    FileUtilities.deleteDirectory(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public static URL toURL(File file) {
        URL uRL = null;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static String urlEncode(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, FileUtilities.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    public static String urlDecode(String string) {
        String string2;
        try {
            string2 = URLDecoder.decode(string, FileUtilities.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
    }

    public static boolean savePropertiesFile(File file, Properties properties) {
        try {
            File file2 = File.createTempFile(file.getName(), "temp");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, "Generated by ProtegePropertyTab");
            fileOutputStream.flush();
            fileOutputStream.close();
            BufferedReader bufferedReader = FileUtilities.createBufferedReader(file2);
            PrintWriter printWriter = new PrintWriter(file);
            String string = bufferedReader.readLine();
            while (string != null) {
                string = string.replace("\\:", ":");
                printWriter.println(string);
                string = bufferedReader.readLine();
            }
            printWriter.close();
            bufferedReader.close();
            file2.delete();
        }
        catch (Exception exception) {
            Log.getLogger().warning("Error writing property file " + file + " Error message: " + exception.getMessage());
            return false;
        }
        return true;
    }
}

