/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.InstanceUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;

public class WidgetDescriptor
implements Cloneable {
    private static final String CLASS_WIDGET = "Widget";
    private static final String SLOT_WIDGET_CLASSNAME = "widget_class_name";
    private static final String SLOT_PROPERTY_LIST = "property_list";
    private static final String SLOT_LABEL = "label";
    private static final String SLOT_NAME = "name";
    private static final String SLOT_HIDDEN = "is_hidden";
    private boolean _isTemporary;
    private boolean _isDirectlyCustomizedByUser;
    private Instance _instance;

    private WidgetDescriptor(Instance instance) {
        this._instance = instance;
    }

    public Object clone() {
        WidgetDescriptor widgetDescriptor;
        try {
            widgetDescriptor = (WidgetDescriptor)super.clone();
            widgetDescriptor._instance = (Instance)this._instance.deepCopy(this._instance.getKnowledgeBase(), null);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.getLogger().severe(Log.toString(cloneNotSupportedException));
            widgetDescriptor = null;
        }
        return widgetDescriptor;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof WidgetDescriptor) {
            WidgetDescriptor widgetDescriptor = (WidgetDescriptor)object;
            bl = this._instance.equals(widgetDescriptor._instance);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this._instance.hashCode();
    }

    public static boolean isActiveWidget(Instance instance) {
        boolean bl = false;
        Cls cls = instance.getDirectType();
        if (cls.getName().equals(CLASS_WIDGET)) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance, SLOT_WIDGET_CLASSNAME);
            bl = string != null;
        }
        return bl;
    }

    public static WidgetDescriptor create(Instance instance) {
        WidgetDescriptor widgetDescriptor = null;
        Cls cls = instance.getDirectType();
        if (cls == null) {
            Log.getLogger().severe("instance has null type" + instance.getName());
        } else if (cls.getName().equals(CLASS_WIDGET)) {
            widgetDescriptor = new WidgetDescriptor(instance);
        } else {
            Log.getLogger().severe("not an instance of Widget: " + instance.getName());
        }
        return widgetDescriptor;
    }

    public static WidgetDescriptor create(KnowledgeBase knowledgeBase) {
        Cls cls = knowledgeBase.getCls(CLASS_WIDGET);
        Assert.assertNotNull("widgetCls", cls);
        Instance instance = knowledgeBase.createInstance(null, cls);
        return WidgetDescriptor.create(instance);
    }

    private static void deletePropertyListInstance(Instance instance) {
        KnowledgeBase knowledgeBase = instance.getKnowledgeBase();
        Collection<Instance> collection = CollectionUtilities.createCollection(instance);
        for (Instance instance2 : knowledgeBase.getReachableSimpleInstances(collection)) {
            instance2.delete();
        }
    }

    public Rectangle getBounds() {
        Rectangle rectangle = InstanceUtilities.getRectangle(this._instance);
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle = null;
        }
        return rectangle;
    }

    public Instance getInstance() {
        return this._instance;
    }

    private Instance getInstanceValue(String string) {
        return (Instance)this.getValue(string);
    }

    public String getLabel() {
        String string = this.getStringValue(SLOT_LABEL);
        return string;
    }

    public Point getLocation() {
        return this.getBounds().getLocation();
    }

    public String getName() {
        return this.getStringValue(SLOT_NAME);
    }

    public PropertyList getPropertyList() {
        Instance instance = this.getInstanceValue(SLOT_PROPERTY_LIST);
        if (instance == null) {
            KnowledgeBase knowledgeBase = this._instance.getKnowledgeBase();
            Cls cls = knowledgeBase.getCls("Property_List");
            instance = this._instance.getKnowledgeBase().createInstance(null, cls);
            this.setValue(SLOT_PROPERTY_LIST, instance);
        }
        return new PropertyList(instance);
    }

    private String getStringValue(String string) {
        return (String)this.getValue(string);
    }

    private Object getValue(String string) {
        return this._instance == null ? (Object)null : ModelUtilities.getDirectOwnSlotValue(this._instance, string);
    }

    public String getWidgetClassName() {
        return this.getStringValue(SLOT_WIDGET_CLASSNAME);
    }

    public boolean isDirectlyCustomizedByUser() {
        return this._isDirectlyCustomizedByUser;
    }

    public boolean isIncluded() {
        return this._instance.isIncluded();
    }

    public boolean isNull() {
        return this.getWidgetClassName() == null;
    }

    public boolean isTemporary() {
        return this._isTemporary;
    }

    public boolean isVisible() {
        Boolean bl = (Boolean)this.getValue(SLOT_HIDDEN);
        return bl == null ? true : bl == false;
    }

    public void setBounds(Rectangle rectangle) {
        InstanceUtilities.setRectangle(this._instance, rectangle);
    }

    public void setDirectlyCustomizedByUser(boolean bl) {
        if (this._isDirectlyCustomizedByUser != bl) {
            this._isDirectlyCustomizedByUser = bl;
            this._isTemporary = !this._isDirectlyCustomizedByUser;
        }
    }

    public void setIncluded(boolean bl) {
        WidgetDescriptor.setInstanceTreeIncluded(this._instance, bl);
    }

    private static void setInstanceTreeIncluded(Instance instance, boolean bl) {
        WidgetDescriptor.setIncluded(instance, bl);
        for (Instance instance2 : instance.getReachableSimpleInstances()) {
            WidgetDescriptor.setIncluded(instance2, bl);
        }
    }

    private static void setIncluded(Instance instance, boolean bl) {
        instance.setIncluded(bl);
    }

    public void setLabel(String string) {
        this.setValue(SLOT_LABEL, string);
    }

    public void setName(String string) {
        this.setValue(SLOT_NAME, string);
    }

    public void setPropertyList(PropertyList propertyList) {
        Instance instance = (Instance)this.getValue(SLOT_PROPERTY_LIST);
        if (instance != null) {
            WidgetDescriptor.deletePropertyListInstance(instance);
        }
        Instance instance2 = propertyList.getWrappedInstance();
        this.setValue(SLOT_PROPERTY_LIST, instance2);
        WidgetDescriptor.setInstanceTreeIncluded(instance2, this._instance.isIncluded());
    }

    public void setTemporary(boolean bl) {
        this._isTemporary = bl;
    }

    private void setValue(String string, Object object) {
        ModelUtilities.setOwnSlotValue(this._instance, string, object);
    }

    public void setVisible(boolean bl) {
        this.setValue(SLOT_HIDDEN, !bl);
    }

    public void setWidgetClassName(String string) {
        String string2 = this.getWidgetClassName();
        if (!SystemUtilities.equals(string, string2)) {
            this.setValue(SLOT_WIDGET_CLASSNAME, string);
            this.getPropertyList().clear();
        }
    }

    public String toString() {
        String string = "WidgetDescriptor(name=" + this.getName();
        string = string + ", temp=" + this.isTemporary();
        string = string + ", included=" + this.isIncluded();
        string = string + ", classname=" + this.getWidgetClassName();
        string = string + ")";
        return string;
    }
}

