/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public abstract class LazyTreeRoot
extends LazyTreeNode {
    private LazyTreeModel _model;

    protected LazyTreeRoot(Object object) {
        this(CollectionUtilities.createCollection(object), false);
    }

    protected LazyTreeRoot(Collection collection) {
        this(collection, false);
    }

    protected LazyTreeRoot(Object object, boolean bl) {
        super(null, CollectionUtilities.createCollection(object), bl);
    }

    protected LazyTreeRoot(Collection collection, boolean bl) {
        super(null, LazyTreeRoot.getRootCollection(collection, bl), bl);
    }

    private static Collection getRootCollection(Collection arrayList, boolean bl) {
        if (bl) {
            ArrayList arrayList2 = new ArrayList(arrayList);
            Collections.sort(arrayList2, new FrameComparator());
            arrayList = arrayList2;
        }
        return arrayList;
    }

    protected int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public Collection getChildObjects() {
        return (Collection)this.getUserObject();
    }

    public void childReplaced(Object object, Object object2) {
        List list = (List)this.getUserObject();
        int n = list.indexOf(object);
        if (n < 0) {
            if (Log.getLogger().isLoggable(Level.FINE)) {
                Log.getLogger().fine("Could not replace object " + object + " with " + object2 + " in tree root. Object not found.");
            }
            return;
        }
        list.set(n, object2);
    }

    public void notifyChildNodeAdded(LazyTreeNode lazyTreeNode, int n, LazyTreeNode lazyTreeNode2) {
        this._model.nodesWereInserted(lazyTreeNode, new int[]{n});
    }

    public void notifyChildNodeRemoved(LazyTreeNode lazyTreeNode, int n, LazyTreeNode lazyTreeNode2) {
        this._model.nodesWereRemoved(lazyTreeNode, new int[]{n}, new Object[]{lazyTreeNode2});
    }

    public void notifyNodeChanged(LazyTreeNode lazyTreeNode) {
        this._model.nodeChanged(lazyTreeNode);
    }

    public void notifyNodeStructureChanged(LazyTreeNode lazyTreeNode) {
        this._model.nodeStructureChanged(lazyTreeNode);
    }

    public void setModel(LazyTreeModel lazyTreeModel) {
        this._model = lazyTreeModel;
    }
}

