/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidatableCache<S, V, R>
implements Cache<S, V, R> {
    private Logger logger = Log.getLogger(InvalidatableCache.class);
    private boolean ignoreTransactions;
    private Set<S> sessionsWithCacheDeleted = new HashSet<S>();
    private boolean invalid = false;
    private Cache<S, V, R> delegate;
    private int id;

    public InvalidatableCache(Cache<S, V, R> cache, boolean bl) {
        this.delegate = cache;
        this.ignoreTransactions = bl;
        this.id = cache.getCacheId();
    }

    private boolean isInvalidInternal(S s) {
        return this.invalid || this.sessionsWithCacheDeleted.contains(s);
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        if (this.isInvalidInternal(s)) {
            return CacheResult.getInvalid();
        }
        return this.delegate.readCache(s, v);
    }

    @Override
    public void updateCache(S s, V v) {
        if (this.isInvalidInternal(s)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " is invalid for session " + s);
            }
            return;
        }
        this.delegate.updateCache(s, v);
    }

    @Override
    public void updateCache(S s, V v, R r) {
        if (this.isInvalidInternal(s)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Read ignored, Cache " + this.getCacheId() + " is invalid for session " + s);
            }
            return;
        }
        this.delegate.updateCache(s, v, r);
    }

    @Override
    public void modifyCache(S s, V v) {
        if (this.isInvalidInternal(s)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Read ignored, Cache " + this.getCacheId() + " is invalid for session " + s);
            }
            return;
        }
        this.delegate.modifyCache(s, v);
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        if (this.isInvalidInternal(s)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Write ignored, Cache " + this.getCacheId() + " is invalid for session " + s);
            }
            return;
        }
        this.delegate.modifyCache(s, v, r);
    }

    @Override
    public void invalidate(S s) {
        if (this.isInvalidInternal(s)) {
            return;
        }
        if (!this.ignoreTransactions && this.delegate.getTransactionNesting(s) > 0) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " invalidated for " + s);
            }
            this.sessionsWithCacheDeleted.add(s);
        } else {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " invalidated");
            }
            this.die();
        }
    }

    @Override
    public boolean isInvalid() {
        return this.invalid || this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        if (this.invalid) {
            return false;
        }
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S s) {
        if (this.invalid) {
            return;
        }
        this.delegate.beginTransaction(s);
    }

    @Override
    public void commitTransaction(S s) {
        if (this.invalid) {
            return;
        }
        if (this.getTransactionNesting(s) <= 0) {
            this.die();
        } else {
            this.delegate.commitTransaction(s);
            if (!this.ignoreTransactions && this.delegate.getTransactionNesting(s) == 0 && this.sessionsWithCacheDeleted.contains(s)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Commmited delete of cache " + this.getCacheId());
                }
                this.die();
            }
        }
    }

    @Override
    public void rollbackTransaction(S s) {
        if (this.invalid) {
            return;
        }
        if (this.getTransactionNesting(s) <= 0) {
            this.die();
        } else {
            this.delegate.rollbackTransaction(s);
            if (!this.ignoreTransactions && this.delegate.getTransactionNesting(s) == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Delete of cache rolled back " + this.getCacheId());
                }
                this.sessionsWithCacheDeleted.remove(s);
            }
        }
    }

    private void die() {
        this.invalid = true;
        try {
            this.delegate.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.delegate = null;
        this.sessionsWithCacheDeleted.clear();
    }

    @Override
    public int getTransactionNesting(S s) {
        if (this.isInvalidInternal(s)) {
            return 0;
        }
        return this.delegate.getTransactionNesting(s);
    }

    @Override
    public void flush() {
        if (this.invalid) {
            return;
        }
        if (!this.sessionsWithCacheDeleted.isEmpty()) {
            this.die();
        } else {
            this.delegate.flush();
        }
    }

    @Override
    public int getCacheId() {
        return this.id;
    }
}

